/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.benchmark;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SpaceEater
extends Test {
    private static final String help = "help for SpaceEater";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public SpaceEater(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public SpaceEater(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = "SpaceEater";
        String string2 = this.getUnicodeIdentifier(string);
        this.dropTable(string2);
        int[] nArray = new int[]{16, 32, 64, 128, 256, 512, 1024};
        int n = 100000;
        this.stmt.execute("CREATE TABLE " + string2 + " (a varchar(1024))");
        System.out.println("Test measures conversion of " + n + " string values from a VARCHAR(1024) column");
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            String string3 = this.makeEmptyString(n2);
            String string4 = null;
            this.stmt.executeUpdate("delete from " + string2);
            this.stmt.executeUpdate("Insert into " + string2 + " values ('" + string3 + "')");
            ResultSet resultSet = this.stmt.executeQuery("Select * from " + string2);
            resultSet.next();
            long l = System.currentTimeMillis();
            for (int j = 0; j < n; ++j) {
                string4 = resultSet.getString(1);
            }
            long l2 = System.currentTimeMillis() - l;
            System.out.println("used characters " + n2 + " duration " + l2 + " ms - " + l2 / (long)n + " ms/stmt");
            this.log.addDifference(string, "check result value", string3.substring(0, n2), string4);
        }
    }

    String makeEmptyString(int n) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        for (int i = 0; i < stringBuffer.capacity(); ++i) {
            if (i < n) {
                stringBuffer.append('x');
                continue;
            }
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        SpaceEater spaceEater = new SpaceEater(stringArray);
        try {
            spaceEater.runInner();
        }
        finally {
            spaceEater.connection.close();
        }
        if (spaceEater.log.hasErrors()) {
            System.exit(5);
        }
    }
}

