/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.benchmark;

import java.sql.SQLException;

public abstract class SimulatedUser
implements Comparable {
    public static final int EMPTY = 0;
    public static final int INITIALIZED = 1;
    public static final int READY = 2;
    public static final int RUNNING = 3;
    public static final int FINISHED_OK = 4;
    public static final int FINISHED_BAD = 5;
    public static final String SIMULATED_USER_NAME = "bench";
    public static final String SIMULATED_USER_PASSWORD = "bench";
    protected static boolean waitingForBegin = false;
    protected int currentState = 0;
    private int id;

    public static String convertState(int n) {
        if (n == 0) {
            return "EMPTY";
        }
        if (n == 1) {
            return "INITIALIZED";
        }
        if (n == 2) {
            return "READY";
        }
        if (n == 3) {
            return "RUNNING";
        }
        if (n == 4) {
            return "FINISHED_OK";
        }
        if (n == 5) {
            return "FINISHED_BAD";
        }
        return "UNKNOWN";
    }

    public static void setWaitingForBegin(boolean bl) {
        waitingForBegin = bl;
    }

    protected SimulatedUser(int n) {
        this.id = n;
        this.currentState = 1;
    }

    public abstract int getExitValue() throws IllegalThreadStateException;

    public abstract void abort();

    public abstract void runUser() throws SQLException;

    public abstract void runUser(int var1) throws SQLException;

    public int getId() {
        return this.id;
    }

    public boolean isFinished() {
        return this.currentState == 4 || this.currentState == 5;
    }

    public int getCurrentState() {
        return this.currentState;
    }

    public int compareTo(Object object) {
        if (object instanceof SimulatedUser) {
            return this.getId() - ((SimulatedUser)object).getId();
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object instanceof SimulatedUser) {
            return this.getId() == ((SimulatedUser)object).getId();
        }
        return false;
    }
}

