/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.TestDifference;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ReadASCII
extends Test {
    private static final String help = "help for ReadASCII";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public ReadASCII(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public ReadASCII(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        ResultSet resultSet = this.select("select strcol from asciitest where keycol = 'from python'");
        if (!resultSet.next()) {
            this.log.addFailure(new TestDifference("could not read entry"));
            return;
        }
        String string = (String)resultSet.getObject(1);
        for (int i = 0; i < 256; ++i) {
            int n = string.charAt(i);
            if (n != i) {
                this.log.addFailure(new TestDifference("at " + i + " => '" + (char)n + "' " + n));
                continue;
            }
            this.log.addInfo("at " + i + " => '" + (char)n + "' " + n);
        }
        try {
            this.stmt.execute("delete from asciitest where keycol = 'from java'");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        PreparedStatement preparedStatement = this.prepare("insert into asciitest (keycol, strcol) values (?, ?)");
        preparedStatement.setString(1, "from java");
        preparedStatement.setString(2, string);
        preparedStatement.execute();
        this.connection.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        ReadASCII readASCII = new ReadASCII(stringArray);
        try {
            readASCII.runInner();
        }
        finally {
            readASCII.connection.close();
        }
    }
}

