/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.test;

import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class testdata3 {
    private static testdata3 s_instance;
    private static final int INS = 0;
    private static final int UPD = 1;
    private static final int DEL = 2;
    private static final int STRING = 0;
    private static final int INT = 1;
    private static final int DOUBLE = 2;
    private static final int BOOLEAN = 3;
    private static final int DATE = 4;
    private static final int TIME = 5;
    private static final int TIMESTAMP = 6;
    private static final Tabledesc[] s_table;
    private int m_inner;
    private int m_outer;
    private long m_sleep;
    private String m_prefix;
    private Connection m_con;
    private PreparedStatement[][] m_stmt;
    private Tabledesc[] m_table;

    public static void main(String[] args) throws Exception {
        s_instance = new testdata3(args, s_table);
        s_instance.main_internal();
    }

    private testdata3(String[] args, Tabledesc[] tables) throws Exception {
        this.m_outer = Integer.parseInt(args[4]);
        this.m_inner = Integer.parseInt(args[5]);
        this.m_prefix = args[6];
        this.m_sleep = Long.parseLong(args[7]);
        Class.forName(args[1]);
        this.m_con = DriverManager.getConnection(args[0], args[2], args[3]);
        this.m_con.setAutoCommit(false);
        this.m_table = tables;
        this.m_stmt = new PreparedStatement[3][3];
        for (int tidx = 0; tidx < this.m_table.length; ++tidx) {
            Coldesc col;
            int cidx;
            int cnumb = this.m_table[tidx].col.length;
            int key_numb = 0;
            int nonkey_numb = 0;
            for (cidx = 0; cidx < cnumb; ++cidx) {
                col = this.m_table[tidx].col[cidx];
                if (col.isKey) {
                    ++key_numb;
                    continue;
                }
                ++nonkey_numb;
            }
            String whereClause = " where ";
            int key_idx = 0;
            for (cidx = 0; cidx < cnumb; ++cidx) {
                col = this.m_table[tidx].col[cidx];
                if (!col.isKey) continue;
                whereClause = whereClause + "\"" + col.name + "\"=?";
                whereClause = whereClause + (key_idx == key_numb - 1 ? "" : "and ");
                ++key_idx;
            }
            String insSQL = "insert into \"" + this.m_table[tidx].name + "\" (";
            for (cidx = 0; cidx < cnumb; ++cidx) {
                col = this.m_table[tidx].col[cidx];
                insSQL = insSQL + "\"" + col.name + "\"";
                insSQL = insSQL + (cidx == cnumb - 1 ? "" : ", ");
            }
            insSQL = insSQL + ") values (";
            for (cidx = 0; cidx < cnumb; ++cidx) {
                insSQL = insSQL + "?";
                insSQL = insSQL + (cidx == cnumb - 1 ? "" : ", ");
            }
            insSQL = insSQL + ")";
            this.m_stmt[0][tidx] = this.m_con.prepareStatement(insSQL);
            String updSQL = "update  \"" + this.m_table[tidx].name + "\" set ";
            int nonkey_idx = 0;
            for (cidx = 0; cidx < cnumb; ++cidx) {
                col = this.m_table[tidx].col[cidx];
                if (col.isKey) continue;
                updSQL = updSQL + "\"" + col.name + "\"=?";
                updSQL = updSQL + (nonkey_idx == nonkey_numb - 1 ? "" : ", ");
                ++nonkey_idx;
            }
            updSQL = updSQL + whereClause;
            this.m_stmt[1][tidx] = this.m_con.prepareStatement(updSQL);
            String delSQL = "delete from \"" + this.m_table[tidx].name + "\"";
            delSQL = delSQL + whereClause;
            this.m_stmt[2][tidx] = this.m_con.prepareStatement(delSQL);
        }
    }

    private void main_internal() throws Exception {
        this.doLoop(0, "insert00", 0);
        this.doLoop(3, "update01", 1);
        this.doLoop(2, "delete02", 2);
        this.doLoop(5, "insert03", 0);
        this.doLoop(7, "delete04", 2);
        this.doLoop(6, "update05", 1);
        this.doLoop(14, "delete06", 2);
        this.doLoop(10, "insert07", 0);
        this.doLoop(15, "update08", 1);
    }

    private void doLoop(int modulus, String caption, int type) throws Exception {
        int cnt = 0;
        boolean rollback = false;
        System.out.println(this.m_prefix + ":" + caption + " : " + this.m_outer * this.m_inner + " runs ...");
        for (int j = 0; j < this.m_outer; ++j) {
            rollback = modulus != 0 && j % modulus == 0;
            for (int i = 0; i < this.m_inner; ++i) {
                cnt = j * this.m_inner + i;
                String str = this.m_prefix + ":" + caption + ":" + cnt;
                String small_str = ".";
                try {
                    long millis = 1040688000000L;
                    this.execStmts(type, cnt, "qap", cnt, str, millis);
                }
                catch (SQLException ex) {
                    if (ex.getErrorCode() == 200) {
                        str = str + "(duplicate)";
                        small_str = "+";
                    }
                    throw ex;
                }
                if (cnt % 50 == 0 && cnt != 0) {
                    System.out.println();
                    Thread.sleep(this.m_sleep);
                }
                if (rollback) {
                    small_str = "-";
                }
                System.out.print(small_str);
            }
            if (!rollback) {
                this.m_con.commit();
                continue;
            }
            this.m_con.rollback();
        }
        System.out.println();
        System.out.println(" ... " + this.m_prefix + ":" + caption + " done.");
        System.out.println();
    }

    private void execStmts(int type, int key_int, String key_str, int val_int, String val_str, long val_tstmp) throws Exception {
        for (int tidx = 0; tidx < this.m_table.length; ++tidx) {
            Coldesc col;
            int cidx;
            int cnumb = this.m_table[tidx].col.length;
            int pidx = 0;
            PreparedStatement pstmt = this.m_stmt[type][tidx];
            if (type == 0) {
                for (cidx = 0; cidx < cnumb; ++cidx) {
                    col = this.m_table[tidx].col[cidx];
                    if (col.isKey) {
                        this.setParam(pstmt, col.type, ++pidx, key_int, key_str, val_tstmp);
                        continue;
                    }
                    this.setParam(pstmt, col.type, ++pidx, val_int, val_str, val_tstmp);
                }
            } else if (type == 1) {
                for (cidx = 0; cidx < cnumb; ++cidx) {
                    col = this.m_table[tidx].col[cidx];
                    if (col.isKey) continue;
                    this.setParam(pstmt, col.type, ++pidx, val_int, val_str, val_tstmp);
                }
                for (cidx = 0; cidx < cnumb; ++cidx) {
                    col = this.m_table[tidx].col[cidx];
                    if (!col.isKey) continue;
                    this.setParam(pstmt, col.type, ++pidx, key_int, key_str, val_tstmp);
                }
            } else if (type == 2) {
                for (cidx = 0; cidx < cnumb; ++cidx) {
                    col = this.m_table[tidx].col[cidx];
                    if (!col.isKey) continue;
                    this.setParam(pstmt, col.type, ++pidx, key_int, key_str, val_tstmp);
                }
            }
            pstmt.executeUpdate();
        }
    }

    private void setParam(PreparedStatement pstmt, int coltype, int pidx, int intval, String strval, long tstmpval) throws Exception {
        switch (coltype) {
            case 0: {
                pstmt.setString(pidx, strval);
                break;
            }
            case 1: {
                pstmt.setInt(pidx, intval);
                break;
            }
            case 2: {
                pstmt.setDouble(pidx, (double)intval / 100.0);
                break;
            }
            case 3: {
                pstmt.setBoolean(pidx, intval % 2 == 0);
                break;
            }
            case 4: {
                pstmt.setDate(pidx, new Date(tstmpval));
                break;
            }
            case 5: {
                pstmt.setTime(pidx, new Time(tstmpval));
                break;
            }
            case 6: {
                pstmt.setTimestamp(pidx, new Timestamp(tstmpval));
                break;
            }
            default: {
                pstmt.setObject(pidx, strval);
            }
        }
    }

    static {
        s_table = new Tabledesc[]{new Tabledesc("A_REP_A", new Coldesc[]{new Coldesc("COL1", 1, true), new Coldesc("COL2", 0, false)}), new Tabledesc("DELETE", new Coldesc[]{new Coldesc("COL1", 0, true), new Coldesc("SIN", 0, false), new Coldesc("SELECT", 1, true), new Coldesc("COL4", 1, false), new Coldesc("INSERT", 2, false), new Coldesc("COL6", 2, false), new Coldesc("COL7", 3, false), new Coldesc("COL8", 4, false), new Coldesc("COL9", 5, false), new Coldesc("COL10", 6, false)}), new Tabledesc("A_REP_C", new Coldesc[]{new Coldesc("COL1", 1, true), new Coldesc("COL2", 0, false)})};
    }

    private static final class Coldesc {
        public String name;
        public int type;
        public boolean isKey;

        public Coldesc(String p_name, int p_type, boolean p_isKey) {
            this.name = p_name;
            this.type = p_type;
            this.isKey = p_isKey;
        }
    }

    private static final class Tabledesc {
        public String name;
        public Coldesc[] col;

        public Tabledesc(String p_name, Coldesc[] p_col) {
            this.name = p_name;
            this.col = p_col;
        }
    }
}

