/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.test;

import com.sap.sdb.syncMan.test.ApplicationParam;
import com.sap.sdb.syncMan.util.DebugOutput;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

public class CreateTestSubsetTables {
    private static final String TAB1 = "subset_tab1";
    private static final String TAB2 = "subset_tab2";
    private static final String CREATE_TAB1 = "CREATE TABLE subset_tab1 (key1 CHAR(10),  key2 CHAR(10),  col  CHAR(10), PRIMARY KEY (key1, key2))";
    private static final String CREATE_TAB2 = "CREATE TABLE subset_tab2 (keyCol INTEGER,  colA_5 FIXED(30),  colB_4 FIXED(10,2),  colC_6 FLOAT(10),  colX_3 FIXED(5),  colY_1 INTEGER, PRIMARY KEY (keyCol))";
    private static final String DROP_TAB1 = "DROP TABLE subset_tab1";
    private static final String DROP_TAB2 = "DROP TABLE subset_tab2";
    private static final int RC_UNKNOWN_TABLE_NAME = -4004;

    public static void main(String[] argv) {
        DebugOutput.setVerboseTraceback();
        ApplicationParam param = new ApplicationParam(argv);
        param.enableParamUser(null, null);
        if (param.createProperties()) {
            new CreateTestSubsetTables().doWork(param);
        }
    }

    private CreateTestSubsetTables() {
    }

    private void doWork(ApplicationParam param) {
        try {
            Connection con = DriverManager.getConnection(param.getURL(), param.getUser(), param.getPassword());
            con.setAutoCommit(false);
            CreateTestSubsetTables.printDatabaseConnection(con, param);
            Statement stmt = con.createStatement();
            this.executeIgnoreUnknownTable(stmt, DROP_TAB1);
            this.executeIgnoreUnknownTable(stmt, DROP_TAB2);
            stmt.execute(CREATE_TAB1);
            stmt.execute(CREATE_TAB2);
            con.commit();
            DebugOutput.println((String)"tables subset_tab1 and subset_tab2 created");
        }
        catch (SQLException ex) {
            DebugOutput.printException((Exception)ex);
        }
    }

    private void executeIgnoreUnknownTable(Statement stmt, String cmd) throws SQLException {
        block2: {
            try {
                stmt.execute(cmd);
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == -4004) break block2;
                throw ex;
            }
        }
    }

    static void printDatabaseConnection(Connection con, ApplicationParam param) throws SQLException {
        DatabaseMetaData metaData = con.getMetaData();
        DebugOutput.println();
        DebugOutput.println((String)("Database URL : " + param.getURL()));
        DebugOutput.println((String)("Database user: " + param.getUser()));
        DebugOutput.println((String)("Product name : " + metaData.getDatabaseProductName()));
        DebugOutput.println((String)("Product vers : " + metaData.getDatabaseProductVersion()));
        DebugOutput.println((String)("JDBC driver  : " + metaData.getDriverVersion()));
        DebugOutput.println();
    }
}

