/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.test;

import com.sap.sdb.syncMan.test.ApplicationParam;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class CreateExampleTables {
    private boolean m_handleMaster;
    private boolean m_handleClient;
    private boolean m_clear;
    private boolean m_createSyncuser;
    private int m_databaseType = 0;
    private Connection m_connection = null;
    private Statement m_stmt = null;
    private String m_username = null;
    private String m_urlMaster = null;
    private String m_urlClient = null;
    private ApplicationParam m_param;
    private PreparedStatement m_insertCustomer = null;
    private PreparedStatement m_insertReservation = null;
    private static final int DATABASE_UNKNOWN = 0;
    private static final int DATABASE_MAXDB = 1;
    private static final int DATABASE_MINDB = 2;
    private static final int DATABASE_MYSQL = 3;
    private static final String URL_PREFIX_MAXDB = "jdbc:sapdb:";
    private static final String URL_PREFIX_MINDB = "jdbc:mindb:";
    private static final String URL_PREFIX_MYSQL = "jdbc:mysql:";
    private static final String PARAM_CLEAR = "clear";
    private static final String PARAM_CREATE_SYNCUSER = "createServiceUser";
    private static final String PARAM_NO_MASTER = "noMaster";
    private static final String PARAM_NO_CLIENT = "noClient";
    private static final String PARAM_MASTER_DRIVER = "masterDriver";
    private static final String PARAM_CLIENT_DRIVER = "clientDriver";
    private static final String PARAM_MASTER_URL = "masterURL";
    private static final String PARAM_CLIENT_URL = "clientURL";
    private static final String PARAM_MASTER_USER = "masterUser";
    private static final String PARAM_MASTER_PASSWORD = "masterPassword";
    private static final String PARAM_CLIENT_USER = "clientUser";
    private static final String PARAM_CLIENT_PASSWORD = "clientPassword";
    private static final String DEFAULT_DRIVER = "com.sap.dbtech.jdbc.DriverSapDB";
    private static final String DEFAULT_MASTER_URL = "jdbc:sapdb://127.0.0.1/DBMASTER";
    private static final String DEFAULT_CLIENT_URL = "jdbc:sapdb://127.0.0.1/DBCLIENT";
    private static final String SYNCUSER = "DBSERVICE";
    private static final String SYNCUSER_PASSWORD = "SECRET";
    private static final String EXAMPLE_MASTER_USER = "USER_MASTER";
    private static final String EXAMPLE_MASTER_PASSWORD = "MASTER";
    private static final String EXAMPLE_CLIENT1_USER = "USER1_CLIENT";
    private static final String EXAMPLE_CLIENT1_PASSWORD = "CLIENT";
    private static final String EXAMPLE_CLIENT2_USER = "USER2_CLIENT";
    private static final String EXAMPLE_CLIENT2_PASSWORD = "CLIENT";
    private static final String SCHEMA_MSGSERVER = "MESSAGESERVICE";
    private static final String SCHEMA_SYNCSERVICE = "SYNCHRONIZATIONSERVICE";
    private static final String DRIVER_CLASS = "JDBCDriverClass";
    private static final String PASSWORD = "password";
    private static final String URL = "databaseURL";
    private static final String USERNAME = "userName";
    private static final String TABLE_BOOKING = "booking";
    private static final String TABLE_GUEST = "guest";
    private static final String TABLE_CUSTOMER = "customer";
    private static final String TABLE_RESERVATION = "reservation";
    private static final String CREATE_EXAMPLE_USER_OPTIONS = " RESOURCE NOT EXCLUSIVE";
    private static final String CREATE_SYNCUSER_OPTIONS = " DBA NOT EXCLUSIVE REPLICATION";
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final String GRANT_TABLE = "GRANT SELECT, INSERT, UPDATE, DELETE ON ";
    private static final String CREATE_TABLE_BOOKING = "CREATE TABLE booking" + LINE_SEP + "     (id        INTEGER NOT NULL," + LINE_SEP + "      arrival   DATE," + LINE_SEP + "      departure DATE," + LINE_SEP + "      guest     INTEGER," + LINE_SEP + "      PRIMARY KEY (id))";
    private static final String CREATE_TABLE_CUSTOMER = "CREATE TABLE customer" + LINE_SEP + "     (cno       INTEGER NOT NULL," + LINE_SEP + "      title     CHAR (10)," + LINE_SEP + "      firstname CHAR (20)," + LINE_SEP + "      name      CHAR (20)," + LINE_SEP + "      zip       CHAR  (5)," + LINE_SEP + "      city      CHAR (20)," + LINE_SEP + "      state     CHAR  (5)," + LINE_SEP + "      address   CHAR (30)," + LINE_SEP + "      portrait  LONG BYTE," + LINE_SEP + "      PRIMARY KEY (cno))";
    private static final String CREATE_TABLE_GUEST = "CREATE TABLE guest" + LINE_SEP + "     (guest     INTEGER NOT NULL," + LINE_SEP + "      surname   CHAR (20)," + LINE_SEP + "      firstname CHAR (20)," + LINE_SEP + "      title     CHAR (10)," + LINE_SEP + "      PRIMARY KEY (guest))";
    private static final String CREATE_TABLE_RESERVATION = "CREATE TABLE reservation" + LINE_SEP + "     (rno       INTEGER NOT NULL," + LINE_SEP + "      cno       INTEGER," + LINE_SEP + "      type      CHAR (10)," + LINE_SEP + "      arrival   DATE," + LINE_SEP + "      departure DATE," + LINE_SEP + "      PRIMARY KEY (rno))";
    private static final int RC_UNKNOWN_USER_NAME = -4003;
    private static final int RC_DUPLICATE_USER_NAME = -6006;

    public static void main(String[] argv) {
        ApplicationParam param = new ApplicationParam(argv);
        param.defineBoolParam(PARAM_CLEAR, "drops the schemas and users");
        param.defineBoolParam(PARAM_CREATE_SYNCUSER, "creates the user DBSERVICE");
        param.defineBoolParam(PARAM_NO_MASTER, "without master database");
        param.defineBoolParam(PARAM_NO_CLIENT, "without client database");
        param.defineParam(PARAM_MASTER_DRIVER, DRIVER_CLASS, DEFAULT_DRIVER);
        param.defineParam(PARAM_CLIENT_DRIVER, DRIVER_CLASS, DEFAULT_DRIVER);
        param.defineParam(PARAM_MASTER_URL, URL, DEFAULT_MASTER_URL);
        param.defineParam(PARAM_CLIENT_URL, URL, DEFAULT_CLIENT_URL);
        param.defineParam(PARAM_MASTER_USER, USERNAME, SYNCUSER);
        param.defineParam(PARAM_MASTER_PASSWORD, PASSWORD, SYNCUSER_PASSWORD);
        param.defineParam(PARAM_CLIENT_USER, USERNAME, SYNCUSER);
        param.defineParam(PARAM_CLIENT_PASSWORD, PASSWORD, SYNCUSER_PASSWORD);
        if (param.createProperties()) {
            new CreateExampleTables(param).doWork();
        }
    }

    private void doWork() {
        String[] skipList = new String[]{"Password"};
        this.m_param.printParameters(skipList);
        this.m_handleMaster = !this.m_param.getBoolean(PARAM_NO_MASTER);
        this.m_handleClient = !this.m_param.getBoolean(PARAM_NO_CLIENT);
        this.m_clear = this.m_param.getBoolean(PARAM_CLEAR);
        this.m_createSyncuser = this.m_param.getBoolean(PARAM_CREATE_SYNCUSER);
        try {
            if (this.m_handleMaster) {
                if (!this.m_param.loadJDBCDriver(PARAM_MASTER_DRIVER)) {
                    return;
                }
                this.m_urlMaster = this.m_param.getString(PARAM_MASTER_URL);
            }
            if (this.m_handleClient) {
                if (!this.m_param.loadJDBCDriver(PARAM_CLIENT_DRIVER)) {
                    return;
                }
                this.m_urlClient = this.m_param.getString(PARAM_CLIENT_URL);
            }
            this.handleUsers();
            if (this.m_clear || this.m_createSyncuser) {
                return;
            }
            if (this.m_handleMaster) {
                this.createMasterTables();
            }
            if (this.m_handleClient) {
                this.createClient1Tables();
                this.createClient2Tables();
            }
        }
        catch (SQLException ex) {
            this.printException(ex);
        }
    }

    private CreateExampleTables(ApplicationParam param) {
        this.m_param = param;
    }

    private void commitRelease() throws SQLException {
        System.out.println();
        System.out.println("COMMIT RELEASE " + this.m_username);
        this.m_stmt = null;
        this.m_connection.commit();
        this.m_connection.close();
        this.m_username = null;
        this.m_connection = null;
        this.m_insertCustomer = null;
        this.m_insertReservation = null;
    }

    private void connect(String url, String username, String password) throws SQLException {
        System.out.println();
        System.out.println("---------------------------------------------");
        System.out.println();
        System.out.println("CONNECT " + username);
        this.m_connection = DriverManager.getConnection(url, username, password);
        this.m_username = username;
        this.m_databaseType = url.startsWith(URL_PREFIX_MAXDB) ? 1 : (url.startsWith(URL_PREFIX_MINDB) ? 2 : (url.startsWith(URL_PREFIX_MYSQL) ? 3 : 0));
        this.m_connection.setAutoCommit(false);
        this.m_stmt = this.m_connection.createStatement();
        this.printDatabaseConnection();
    }

    private void createClient1Tables() throws SQLException {
        this.connect(this.m_urlClient, EXAMPLE_CLIENT1_USER, "CLIENT");
        this.execute(CREATE_TABLE_CUSTOMER);
        this.grantTable(TABLE_CUSTOMER, PARAM_CLIENT_USER);
        this.commitRelease();
    }

    private void createClient2Tables() throws SQLException {
        this.connect(this.m_urlClient, EXAMPLE_CLIENT2_USER, "CLIENT");
        this.execute(CREATE_TABLE_BOOKING);
        this.execute(CREATE_TABLE_GUEST);
        this.grantTable(TABLE_BOOKING, PARAM_CLIENT_USER);
        this.grantTable(TABLE_GUEST, PARAM_CLIENT_USER);
        this.commitRelease();
    }

    private void createMasterTables() throws SQLException {
        this.connect(this.m_urlMaster, EXAMPLE_MASTER_USER, EXAMPLE_MASTER_PASSWORD);
        this.execute(CREATE_TABLE_CUSTOMER);
        this.execute(CREATE_TABLE_RESERVATION);
        this.grantTable(TABLE_CUSTOMER, PARAM_MASTER_USER);
        this.grantTable(TABLE_RESERVATION, PARAM_MASTER_USER);
        this.insertCustomer(3000, "Mrs", "Jenny", "Porter", "10580", "New York", "NY", "1340 N.Ash Street, #3");
        this.insertCustomer(3100, "Mr", "Peter", "Brown", "48226", "Detroit", "MI", "1001 34th Str., APT.3");
        this.insertCustomer(3200, "Company", null, "Datasoft", "90018", "Los Angeles", "CA", "486 Maple Str.");
        this.insertCustomer(3300, "Mrs", "Rose", "Brian", "75243", "Dallas", "TX", "500 Yellowstone Drive, #2");
        this.insertCustomer(3400, "Mrs", "Mary", "Griffith", "20005", "Washington", "DC", "3401 Elder Lane");
        this.insertCustomer(3500, "Mr", "Martin", "Randolph", "60615", "Chicago", "IL", "340 MAIN STREET, #7");
        this.insertCustomer(3600, "Mrs", "Sally", "Smith", "75243", "Dallas", "TX", "250 Curtis Street");
        this.insertCustomer(3700, "Mr", "Mike", "Jackson", "45211", "Cincinnati", "OH", "133 BROADWAY APT. 1");
        this.insertCustomer(3800, "Mrs", "Rita", "Doe", "97213", "Portland", "OR", "2000 Humboldt Str., #6");
        this.insertCustomer(3900, "Mr", "George", "Howe", "75243", "Dallas", "TX", "111 B Parkway, #23");
        this.insertCustomer(4000, "Mr", "Frank", "Miller", "95054", "Santa Clara", "CA", "27 5th Str., 76");
        this.insertCustomer(4100, "Mrs", "Susan", "Baker", "90018", "Los Angeles", "CA", "200 MAIN STREET, #94");
        this.insertCustomer(4200, "Mr", "Joseph", "Peters", "92714", "Irvine", "CA", "700 S. Ash Str., APT.12");
        this.insertCustomer(4300, "Company", null, "TOOLware", "20019", "Washington", "DC", "410 Mariposa Str., #10");
        this.insertCustomer(4400, "Mr", "Antony", "Jenkins", "20903", "Silver Spring", "MD", "55 A Parkway, #15");
        this.insertReservation(100, 3000, "single", "2004-11-13", "2004-11-15");
        this.insertReservation(110, 3000, "double", "2004-12-24", "2005-01-06");
        this.insertReservation(120, 3200, "suite", "2004-11-14", "2004-11-18");
        this.insertReservation(130, 3900, "single", "2005-02-01", "2005-02-03");
        this.insertReservation(150, 3600, "double", "2005-03-14", "2005-03-24");
        this.insertReservation(140, 4300, "double", "2004-04-12", "2004-04-30");
        this.insertReservation(160, 4100, "single", "2004-04-12", "2004-04-15");
        this.insertReservation(170, 4400, "suite", "2004-09-01", "2004-09-03");
        this.insertReservation(180, 3100, "double", "2004-12-23", "2005-01-08");
        this.insertReservation(190, 4300, "double", "2004-11-14", "2004-11-17");
        this.commitRelease();
    }

    private void createUser(String username, String password, String options) throws SQLException {
        String sql = "CREATE USER " + username + " PASSWORD " + password + options;
        this.executeIgnoreError(sql, -6006);
    }

    private void dropSchema(String schema) throws SQLException {
        try {
            this.execute("DROP SCHEMA " + schema);
        }
        catch (SQLException ex) {
            System.out.println("   --> " + ex.getMessage());
        }
    }

    private void dropUser(String username) throws SQLException {
        this.executeIgnoreError("DROP USER " + username, -4003);
    }

    private void execute(String sql) throws SQLException {
        System.out.println();
        System.out.println(sql);
        this.m_stmt.execute(sql);
    }

    private void executeIgnoreError(String sql, int ignoreErrorCode) throws SQLException {
        try {
            this.execute(sql);
        }
        catch (SQLException ex) {
            if (ex.getErrorCode() != ignoreErrorCode) {
                throw ex;
            }
            System.out.println("   --> " + ex.getMessage());
        }
    }

    private void grantTable(String tableName, String paramUser) throws SQLException {
        if (this.m_databaseType != 1) {
            return;
        }
        this.execute(GRANT_TABLE + tableName + " TO " + this.m_param.getString(paramUser));
    }

    private void handleUsers() throws SQLException {
        if (this.m_handleMaster) {
            this.connect(this.m_urlMaster, this.m_param.getString(PARAM_MASTER_USER), this.m_param.getString(PARAM_MASTER_PASSWORD));
            if (this.m_createSyncuser) {
                this.createUser(SYNCUSER, SYNCUSER_PASSWORD, CREATE_SYNCUSER_OPTIONS);
            } else {
                try {
                    this.dropSchema(SCHEMA_MSGSERVER);
                    this.dropSchema(SCHEMA_SYNCSERVICE);
                }
                catch (SQLException ex) {
                    System.out.println("   --> " + ex.getMessage());
                }
                this.dropUser(EXAMPLE_MASTER_USER);
                if (!this.m_clear) {
                    this.createUser(EXAMPLE_MASTER_USER, EXAMPLE_MASTER_PASSWORD, CREATE_EXAMPLE_USER_OPTIONS);
                }
            }
            this.commitRelease();
        }
        if (this.m_handleClient) {
            this.connect(this.m_urlClient, this.m_param.getString(PARAM_CLIENT_USER), this.m_param.getString(PARAM_CLIENT_PASSWORD));
            if (this.m_createSyncuser) {
                this.createUser(SYNCUSER, SYNCUSER_PASSWORD, CREATE_SYNCUSER_OPTIONS);
            } else {
                try {
                    this.dropSchema(SCHEMA_SYNCSERVICE);
                }
                catch (SQLException ex) {
                    System.out.println("   --> " + ex.getMessage());
                }
                this.dropUser(EXAMPLE_CLIENT1_USER);
                this.dropUser(EXAMPLE_CLIENT2_USER);
                if (!this.m_clear) {
                    this.createUser(EXAMPLE_CLIENT1_USER, "CLIENT", CREATE_EXAMPLE_USER_OPTIONS);
                    this.createUser(EXAMPLE_CLIENT2_USER, "CLIENT", CREATE_EXAMPLE_USER_OPTIONS);
                }
            }
            this.commitRelease();
        }
    }

    private void insertCustomer(int cno, String title, String firstname, String name, String zip, String city, String state, String address) throws SQLException {
        if (this.m_insertCustomer == null) {
            this.m_insertCustomer = this.m_connection.prepareStatement("INSERT INTO customer (cno, title, firstname, name, zip, city, state, address) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
            System.out.println();
        }
        this.m_insertCustomer.setInt(1, cno);
        if (title == null) {
            this.m_insertCustomer.setNull(2, 1);
        } else {
            this.m_insertCustomer.setString(2, title);
        }
        this.m_insertCustomer.setString(3, firstname);
        this.m_insertCustomer.setString(4, name);
        this.m_insertCustomer.setString(5, zip);
        this.m_insertCustomer.setString(6, city);
        this.m_insertCustomer.setString(7, state);
        this.m_insertCustomer.setString(8, address);
        System.out.println("INSERT customer " + name);
        this.m_insertCustomer.execute();
    }

    private void insertReservation(int rno, int cno, String type, String arrival, String departure) throws SQLException {
        if (this.m_insertReservation == null) {
            this.m_insertReservation = this.m_connection.prepareStatement("INSERT INTO reservation (rno, cno, type, arrival, departure) VALUES (?, ?, ?, ?, ?)");
            System.out.println();
        }
        this.m_insertReservation.setInt(1, rno);
        this.m_insertReservation.setInt(2, cno);
        this.m_insertReservation.setString(3, type);
        this.m_insertReservation.setString(4, arrival);
        this.m_insertReservation.setString(5, departure);
        System.out.println("INSERT reservation " + rno);
        this.m_insertReservation.execute();
    }

    void printDatabaseConnection() throws SQLException {
        DatabaseMetaData metaData = this.m_connection.getMetaData();
        String user = metaData.getUserName();
        System.out.println();
        System.out.println("Database URL : " + metaData.getURL());
        System.out.println("Database user: " + user);
        if (user.equals(this.m_param.getString(PARAM_MASTER_USER)) || user.equals(this.m_param.getString(PARAM_CLIENT_USER))) {
            System.out.println("Product name : " + metaData.getDatabaseProductName());
            System.out.println("Product vers : " + metaData.getDatabaseProductVersion());
            System.out.println("JDBC driver  : " + metaData.getDriverVersion());
        }
    }

    private void printException(Exception ex) {
        if (ex instanceof SQLException) {
            SQLException e = (SQLException)ex;
            String msg = e.getMessage();
            if (e.getMessage() == null) {
                msg = e.toString();
            }
            String msgOutput = "SQLException " + e.getErrorCode() + ": " + msg;
            if (e.getSQLState() == null) {
                System.out.println(msgOutput);
            } else {
                System.out.println(msgOutput + ": " + e.getSQLState());
            }
        } else {
            System.out.println(ex.toString());
        }
    }
}

