/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.test;

import com.sap.sapdb.testframe.testcase.ColumnDescriptor;
import com.sap.sapdb.testframe.testcase.VerificationDataSorted;
import com.sap.sdb.syncMan.test.TestConfig;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class CompareTables {
    private Connection mSourceCon = null;
    private Connection mTargetCon = null;
    TestConfig aTestConfig = null;
    private static String s_cmd_source_url = null;
    private static String s_cmd_target_url = null;

    private CompareTables(String file, boolean withException) throws Exception {
        if (withException) {
            this.aTestConfig = new TestConfig(file, null);
        } else {
            try {
                this.aTestConfig = new TestConfig(file, null);
            }
            catch (IOException ex) {
                System.out.println(ex.toString());
            }
            catch (ParserConfigurationException pex) {
                System.out.println(pex.toString());
            }
            catch (SAXException sax) {
                System.out.println(sax.toString());
            }
        }
        this.compare(withException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void compare(boolean withException) throws Exception {
        block21: {
            boolean mSourceMinDB = this.aTestConfig.getSourceJDBCDriver().startsWith("com.sap.sdb.minDB");
            boolean mTargetMinDB = this.aTestConfig.getTargetJDBCDriver().startsWith("com.sap.sdb.minDB");
            String user = this.aTestConfig.getSourceUser();
            String password = this.aTestConfig.getSourcePassword();
            if (!mSourceMinDB) {
                user = "\"" + CompareTables.buildLogonQualifier(user) + "\"";
                password = "\"" + CompareTables.buildLogonQualifier(password) + "\"";
            }
            this.mSourceCon = this.connectInternal(this.aTestConfig.getSourceJDBCDriver(), s_cmd_source_url == null ? this.aTestConfig.getSourceDatabaseURL() : s_cmd_source_url, user, password);
            user = this.aTestConfig.getTargetUser();
            password = this.aTestConfig.getTargetPassword();
            if (!mTargetMinDB) {
                user = "\"" + CompareTables.buildLogonQualifier(user) + "\"";
                password = "\"" + CompareTables.buildLogonQualifier(password) + "\"";
            }
            this.mTargetCon = this.connectInternal(this.aTestConfig.getTargetJDBCDriver(), s_cmd_target_url == null ? this.aTestConfig.getTargetDatabaseURL() : s_cmd_target_url, user, password);
            String targetSQL = this.aTestConfig.getFirstTargetSQL();
            String sourceSQL = this.aTestConfig.getFirstSourceSQL();
            while (targetSQL != null && targetSQL.length() > 0 && sourceSQL != null && sourceSQL.length() > 0) {
                Statement targetStmt = null;
                Statement sourceStmt = null;
                targetStmt = mTargetMinDB ? this.mTargetCon.createStatement() : this.mTargetCon.createStatement(1005, 1007);
                sourceStmt = mSourceMinDB ? this.mSourceCon.createStatement() : this.mSourceCon.createStatement(1005, 1007);
                targetStmt.execute(targetSQL);
                sourceStmt.execute(sourceSQL);
                ResultSet targetResult = targetStmt.getResultSet();
                ResultSet sourceResult = sourceStmt.getResultSet();
                VerificationDataSorted sourceVeriC = new VerificationDataSorted(sourceResult){

                    protected boolean checkMetaData(ResultSet Set2) throws Exception {
                        ResultSetMetaData MetaData = Set2.getMetaData();
                        int ColumnNumber = MetaData.getColumnCount();
                        if (ColumnNumber != this.mColumnNumber) {
                            throw new RuntimeException("Wrong number of columns: Expecting <" + this.mColumnNumber + ">, but found <" + ColumnNumber + "> columns.");
                        }
                        return true;
                    }

                    public boolean equalsSubstString(ResultSet Set2, String expr) {
                        int j = 0;
                        try {
                            if (Set2 == null) {
                                throw new RuntimeException("ResultSet is NULL.");
                            }
                            this.checkResultCounter(Set2);
                            this.checkMetaData(Set2);
                            ResultSetMetaData MetaData = Set2.getMetaData();
                            Set2.beforeFirst();
                            Iterator ValueIter = this.mValues.iterator();
                            while (Set2.next() && ValueIter.hasNext()) {
                                ++j;
                                ArrayList DataRow = (ArrayList)ValueIter.next();
                                for (int i = 0; i < this.mColumnNumber; ++i) {
                                    if (ColumnDescriptor.isNumeric((int)MetaData.getColumnType(i + 1))) {
                                        this.compareNumber(Set2, i + 1, j, DataRow.get(i));
                                        continue;
                                    }
                                    if (CompareTables.isString(MetaData.getColumnType(i + 1))) {
                                        if (MetaData.getColumnType(i + 1) == 93) {
                                            String strv = (String)DataRow.get(i);
                                            String strr = Set2.getString(i + 1);
                                            if (strr == null) {
                                                strr = "";
                                            }
                                            if (strv == null) {
                                                strv = "";
                                            }
                                            if (CompareTables.this.compareTimestamps(strr, strv)) continue;
                                            throw new RuntimeException("Wrong value in row <" + j + ">, column <" + (i + 1) + ">: Expecting <" + strr + ">, but found <" + strv + ">.");
                                        }
                                        if (expr != null) {
                                            this.compareString(Set2, i + 1, j, (String)DataRow.get(i), expr);
                                            continue;
                                        }
                                        this.compareString(Set2, i + 1, j, (String)DataRow.get(i));
                                        continue;
                                    }
                                    if (CompareTables.isBinary(MetaData.getColumnType(i + 1))) {
                                        this.compareBinary(Set2, i + 1, j, (String)DataRow.get(i));
                                        continue;
                                    }
                                    throw new RuntimeException("Unsupported data type: <" + ColumnDescriptor.getTypeName((int)MetaData.getColumnType(i + 1)) + ">.");
                                }
                            }
                            if (Set2.next()) {
                                throw new RuntimeException("Too many results: Expecting only <" + this.mRowNumber + "> rows");
                            }
                            if (ValueIter.hasNext()) {
                                throw new RuntimeException("Too few results: Expecting <" + this.mRowNumber + "> rows, but found only <" + j + ">.");
                            }
                        }
                        catch (RuntimeException e) {
                            this.mErrorMessage = e.getLocalizedMessage();
                            if (e.toString().indexOf("IndexOutOfBoundsException") != -1) {
                                this.mErrorMessage = e.toString() + "\npossible reason: too few values in a verification data row ";
                            }
                            if (e.toString().indexOf("ClassCastException") != -1) {
                                this.mErrorMessage = e.toString() + "\npossible reason: different datatypes between database result and verificationdata object ";
                                System.out.println("Error: " + this.mErrorMessage);
                                e.printStackTrace();
                            }
                            return false;
                        }
                        catch (Exception e) {
                            this.mErrorMessage = "General error: " + e.getMessage();
                            return false;
                        }
                        this.mErrorMessage = "No errors";
                        return true;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    protected void compareNumber(ResultSet Set2, int Column, int Row, Object Value) throws RuntimeException {
                        try {
                            if (Value != null && Value.getClass().getName().indexOf("String") != -1 && ((String)Value).equalsIgnoreCase("IGNORE")) {
                                return;
                            }
                            BigDecimal RefVal = Set2.getString(Column) == null ? null : new BigDecimal(Set2.getString(Column));
                            if (Value != null && Value instanceof String && ((String)Value).equalsIgnoreCase("NaN")) {
                                throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting 'NaN' value, but found <" + RefVal + ">.");
                            }
                            if (Value == null || Set2.wasNull()) {
                                if (Value == null && !Set2.wasNull()) {
                                    throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting NULL value, but found <" + RefVal + ">.");
                                }
                                if (Value == null || !Set2.wasNull()) return;
                                throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">:  Expecting <" + Value + ">, but found NULL value.");
                            } else if (Value != null && Value instanceof String && ((String)Value).startsWith("RANGE:")) {
                                String m_Value = ((String)Value).replace(' ', ' ').substring(6);
                                if (m_Value.charAt(0) == '<') {
                                    if (m_Value.charAt(1) == '=') {
                                        if (RefVal.compareTo(new BigDecimal(m_Value.substring(2))) <= 0) return;
                                        throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting <  <=" + m_Value.substring(2) + ">, but found <" + RefVal + ">.");
                                    } else {
                                        if (RefVal.compareTo(new BigDecimal(m_Value.substring(1))) < 0) return;
                                        throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting <  <" + m_Value.substring(1) + ">, but found <" + RefVal + ">.");
                                    }
                                } else if (m_Value.charAt(0) == '>') {
                                    if (m_Value.charAt(1) == '=') {
                                        if (RefVal.compareTo(new BigDecimal(m_Value.substring(2))) >= 0) return;
                                        throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting <  >=" + m_Value.substring(2) + ">, but found <" + RefVal + ">.");
                                    } else {
                                        if (RefVal.compareTo(new BigDecimal(m_Value.substring(1))) > 0) return;
                                        throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting <  >" + m_Value.substring(1) + ">, but found <" + RefVal + ">.");
                                    }
                                } else {
                                    if (m_Value.indexOf("/") == -1) throw new RuntimeException("Wrong syntax. Found a range but it didn't start with '<' or '>' or have a '/' inside.");
                                    String[] valueArray = m_Value.split("/");
                                    if (valueArray[1].indexOf("%") != -1) {
                                        valueArray[1] = valueArray[1].substring(0, valueArray[1].indexOf("%"));
                                        BigDecimal bd1 = new BigDecimal(valueArray[0]);
                                        BigDecimal bd2 = new BigDecimal(valueArray[1]);
                                        BigDecimal bd3 = null;
                                        bd3 = bd1.multiply(bd2).divide(BigDecimal.valueOf(100L), 4, 6);
                                        if (RefVal.compareTo(bd1.subtract(bd3)) >= 0 && RefVal.compareTo(bd1.add(bd3)) <= 0) return;
                                        throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting < " + bd1.subtract(bd3).toString() + " <= x <= " + bd1.add(bd3).toString() + " >, but found <" + RefVal + ">.");
                                    } else {
                                        if (RefVal.compareTo(new BigDecimal(valueArray[0])) >= 0 && RefVal.compareTo(new BigDecimal(valueArray[1])) <= 0) return;
                                        throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting < " + valueArray[0] + " <= x <= " + valueArray[1] + " >, but found <" + RefVal + ">.");
                                    }
                                }
                            } else if (Value != null && Value instanceof String) {
                                String str = (String)Value;
                                if (str.equalsIgnoreCase("true")) {
                                    if (RefVal.compareTo(new BigDecimal(1.0)) == 0) return;
                                    throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting <" + Value + ">, but found <" + RefVal + ">.");
                                } else {
                                    if (!str.equalsIgnoreCase("false")) throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting <" + Value + ">, but found <" + RefVal + ">.");
                                    if (RefVal.compareTo(new BigDecimal(0.0)) == 0) return;
                                    throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting <" + Value + ">, but found <" + RefVal + ">.");
                                }
                            } else {
                                if (Value instanceof Integer) {
                                    Value = new BigDecimal(((Integer)Value).doubleValue());
                                }
                                if (RefVal.compareTo((BigDecimal)Value) == 0) return;
                                throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting <" + Value + ">, but found <" + RefVal + ">.");
                            }
                        }
                        catch (SQLException e) {
                            if (e.getErrorCode() != -10811) throw new RuntimeException("Illegal ResultSet. " + e.getLocalizedMessage());
                            if (((String)Value).equalsIgnoreCase("NaN")) return;
                            throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting <" + Value + ">, but found 'NaN' value.");
                        }
                    }
                };
                if (!sourceVeriC.equals(targetResult)) {
                    String text = "Difference between source and target results >" + targetSQL + "< and >" + sourceSQL + "< : " + sourceVeriC.getErrorMessage();
                    if (withException) {
                        throw new Exception(text);
                    }
                    System.out.println(text);
                } else {
                    System.out.println("OK: >" + targetSQL + "< and >" + sourceSQL + "<");
                }
                targetSQL = this.aTestConfig.getNextTargetSQL();
                sourceSQL = this.aTestConfig.getNextSourceSQL();
            }
            Object var15_15 = null;
            try {
                if (this.mSourceCon != null) {
                    this.mSourceCon.close();
                }
                if (this.mTargetCon != null) {
                    this.mTargetCon.close();
                }
                break block21;
            }
            catch (SQLException ex2) {}
            break block21;
            {
                catch (Exception ex) {
                    if (withException) {
                        throw new Exception("Compare :" + ex.toString());
                    }
                    System.out.println("Compare :" + ex.toString());
                    Object var15_16 = null;
                    try {
                        if (this.mSourceCon != null) {
                            this.mSourceCon.close();
                        }
                        if (this.mTargetCon != null) {
                            this.mTargetCon.close();
                        }
                        break block21;
                    }
                    catch (SQLException ex2) {}
                }
            }
            catch (Throwable throwable) {
                Object var15_17 = null;
                try {
                    if (this.mSourceCon != null) {
                        this.mSourceCon.close();
                    }
                    if (this.mTargetCon != null) {
                        this.mTargetCon.close();
                    }
                }
                catch (SQLException ex2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public static void main(String[] args) {
        String file = null;
        try {
            int i = 0;
            while (i < args.length) {
                if (args[i].equals("-f")) {
                    file = args[i + 1];
                    i += 2;
                    continue;
                }
                System.out.println("Unknown argument in command line at position " + (i + 1) + ": " + args[i]);
                System.exit(1);
            }
            new CompareTables(file, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void mainWithException(String[] args) throws Exception {
        String file = null;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-f")) {
                file = args[i + 1];
                i += 2;
                continue;
            }
            if (args[i].equals("-sourceURL")) {
                s_cmd_source_url = args[i + 1];
                i += 2;
                continue;
            }
            if (args[i].equals("-targetURL")) {
                s_cmd_target_url = args[i + 1];
                i += 2;
                continue;
            }
            throw new Exception("unknown argument in command line at position " + (i + 1) + ": " + args[i]);
        }
        new CompareTables(file, true);
    }

    private Connection connectInternal(String jdbcDriver, String databaseURL, String user, String password) throws SQLException {
        Connection connection = null;
        try {
            Class.forName(jdbcDriver);
            connection = DriverManager.getConnection(databaseURL, user, password);
            connection.setAutoCommit(false);
            connection.setTransactionIsolation(2);
        }
        catch (ClassNotFoundException ex) {
            throw new SQLException(ex.toString());
        }
        return connection;
    }

    private static String buildLogonQualifier(String name) {
        if (name == null || name.length() < 1) {
            return name;
        }
        if (name.charAt(0) == '\"') {
            return name.substring(1, name.length() - 1);
        }
        return name.toUpperCase();
    }

    private boolean compareTimestamps(String t1, String t2) {
        boolean retval = true;
        char[] a1 = t1.toCharArray();
        char[] a2 = t2.toCharArray();
        int p1 = 0;
        int p2 = 0;
        while (p1 < a1.length && p2 < a2.length) {
            while (!Character.isDigit(a1[p1]) && p1 < a1.length) {
                ++p1;
            }
            while (!Character.isDigit(a2[p2]) && p2 < a2.length) {
                ++p2;
            }
            if (p1 >= a1.length || p2 >= a2.length) continue;
            if (a1[p1] != a2[p2]) {
                retval = false;
                break;
            }
            ++p1;
            ++p2;
        }
        return retval;
    }

    private static boolean isBinary(int SQLType2) {
        return SQLType2 == -2 || SQLType2 == -3 || SQLType2 == -4 || SQLType2 == 2004;
    }

    public static boolean isString(int SQLType2) {
        return SQLType2 == 1 || SQLType2 == -1 || SQLType2 == 12 || SQLType2 == 91 || SQLType2 == 92 || SQLType2 == 93 || SQLType2 == -7 || SQLType2 == 2005;
    }
}

