/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.test;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;

public class TransactionTopicSubscriber
implements MessageListener,
ExceptionListener {
    private TopicSession mySubSession;
    private TopicConnection myConnection;
    private int myMessagesReceived = 0;
    private boolean myCommit = true;

    public TransactionTopicSubscriber(String topicName, String username, String password) throws Exception {
        InitialContext jndi = null;
        try {
            jndi = new InitialContext();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        TopicConnectionFactory conFactory = (TopicConnectionFactory)jndi.lookup("jms.TopicConnectionFactory");
        this.myConnection = conFactory.createTopicConnection(username, password);
        this.mySubSession = this.myConnection.createTopicSession(true, 1);
        Topic chatTopic = (Topic)jndi.lookup("jms.topic." + topicName);
        TopicSubscriber subscriber = this.mySubSession.createSubscriber(chatTopic);
        subscriber.setMessageListener((MessageListener)this);
        this.myConnection.setExceptionListener((ExceptionListener)this);
        try {
            this.myConnection.start();
        }
        catch (Exception ex) {
            this.myConnection.close();
            throw ex;
        }
    }

    public void onException(JMSException jsme) {
        this.exit();
    }

    public void onMessage(Message message) {
        ++this.myMessagesReceived;
        try {
            TextMessage textMessage = (TextMessage)message;
            String text = textMessage.getText();
            String out = "Received ";
            if (textMessage.getJMSRedelivered()) {
                out = out + "and redelivered: ";
            }
            if (this.myCommit) {
                if (this.myMessagesReceived % 10 == 0) {
                    try {
                        this.mySubSession.commit();
                    }
                    catch (JMSException jmse) {
                        jmse.printStackTrace();
                    }
                    this.myCommit = false;
                }
            } else if (this.myMessagesReceived % 10 == 0) {
                try {
                    this.mySubSession.rollback();
                }
                catch (JMSException jmse) {
                    jmse.printStackTrace();
                }
                this.myCommit = true;
            }
            if (text.length() > 64) {
                System.out.println(out + text.substring(0, 64));
            } else {
                System.out.println(out + text);
            }
        }
        catch (Exception rte) {
            rte.printStackTrace();
        }
    }

    public void close() throws JMSException {
        this.myConnection.close();
    }

    private void exit() {
        try {
            this.myConnection.close();
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
        }
        System.exit(0);
    }

    public static void main(String[] args) {
        TransactionTopicSubscriber aBS = null;
        try {
            if (args.length != 3) {
                System.out.println("Topic or password or username missing");
            }
            aBS = new TransactionTopicSubscriber(args[0], args[1], args[2]);
            BufferedReader commandLine = new BufferedReader(new InputStreamReader(System.in));
            boolean doLoop = true;
            while (doLoop) {
                String s = commandLine.readLine();
                if (!s.equalsIgnoreCase("exit")) continue;
                doLoop = false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        catch (Error e) {
            System.out.println("Attention!!! Unhandled Error!");
            e.printStackTrace();
        }
        try {
            if (aBS != null) {
                aBS.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

