/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.test;

import java.util.Date;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class TransactionQueueSender
extends Thread
implements ExceptionListener {
    private QueueConnection qConnect = null;
    private QueueSession qSession = null;
    private QueueSender qSender = null;
    private Queue aQueue = null;
    private int myMessagesToSend = 0;
    private int mySentMessages = 0;
    private int myPriority = 0;
    TextMessage myTextMsg;

    public TransactionQueueSender(String queueName, String priority, String messagesToSend) {
        try {
            this.myPriority = Integer.parseInt(priority);
            this.myMessagesToSend = Integer.parseInt(messagesToSend);
            QueueConnectionFactory qFactory = null;
            InitialContext jndi = null;
            jndi = new InitialContext();
            qFactory = (QueueConnectionFactory)jndi.lookup("jms.QueueConnectionFactory");
            this.qConnect = qFactory.createQueueConnection("", "");
            this.qSession = this.qConnect.createQueueSession(true, 1);
            this.aQueue = (Queue)jndi.lookup("jms.queue." + queueName);
            this.qSender = this.qSession.createSender(this.aQueue);
            this.qConnect.setExceptionListener((ExceptionListener)this);
            this.myTextMsg = this.qSession.createTextMessage();
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
            System.exit(1);
        }
        catch (NamingException jne) {
            jne.printStackTrace();
            System.exit(1);
        }
    }

    public void onException(JMSException jsme) {
        System.out.println("Exit Sender due to: " + jsme.toString());
        this.exit();
    }

    private void sendAMessage(int iMessageNumber, int priority) {
        try {
            String prefix = iMessageNumber + " with Priority(" + priority + ")" + " ";
            this.myTextMsg.setText(prefix);
            System.out.println("Send Message: " + this.myTextMsg.getText());
            this.myTextMsg.setLongProperty("TIMESTAMP", System.currentTimeMillis());
            this.qSender.send((Message)this.myTextMsg, 2, priority, 0L);
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
        }
    }

    public void run() {
        Date start = new Date();
        boolean commit = true;
        while (this.mySentMessages <= this.myMessagesToSend) {
            try {
                this.sendAMessage(this.mySentMessages, this.myPriority);
                ++this.mySentMessages;
                if (commit) {
                    if (this.mySentMessages % 10 != 0) continue;
                    try {
                        this.qSession.commit();
                        System.out.println("Commit: " + this.mySentMessages);
                    }
                    catch (JMSException jmse) {
                        jmse.printStackTrace();
                    }
                    commit = false;
                    continue;
                }
                if (this.mySentMessages % 10 != 0) continue;
                try {
                    this.qSession.rollback();
                    System.out.println("Rollback: " + this.mySentMessages);
                }
                catch (JMSException jmse) {
                    jmse.printStackTrace();
                }
                commit = true;
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
            }
        }
        Date end = new Date();
        System.out.println(start.toString());
        System.out.println(end.toString());
        try {
            this.qConnect.close();
        }
        catch (JMSException ex) {
            // empty catch block
        }
    }

    private void exit() {
        System.exit(0);
    }

    public static void main(String[] argv) {
        if (argv.length != 3) {
            System.out.println("QueueName or Priority or Messagenumber missing");
        }
        TransactionQueueSender qs = new TransactionQueueSender(argv[0], argv[1], argv[2]);
        System.out.println("TransactionQueueSender application started");
        qs.start();
    }
}

