/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.test;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;

public class TopicPubSub
implements MessageListener,
ExceptionListener {
    private TopicSession myPubSession;
    private TopicSession mySubSession;
    private TopicPublisher myPublisher;
    private TopicConnection myConnection;
    private String myUserName;

    public TopicPubSub(String topicName, String username, String password) throws Exception {
        this.myUserName = username;
        InitialContext jndi = null;
        try {
            jndi = new InitialContext();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        TopicConnectionFactory conFactory = (TopicConnectionFactory)jndi.lookup("jms.TopicConnectionFactory");
        this.myConnection = conFactory.createTopicConnection(username, password);
        this.myPubSession = this.myConnection.createTopicSession(false, 1);
        this.mySubSession = this.myConnection.createTopicSession(false, 1);
        Topic chatTopic = (Topic)jndi.lookup("jms.topic." + topicName);
        this.myPublisher = this.myPubSession.createPublisher(chatTopic);
        TopicSubscriber subscriber = this.mySubSession.createSubscriber(chatTopic, "", false);
        subscriber.setMessageListener((MessageListener)this);
        this.myConnection.setExceptionListener((ExceptionListener)this);
        try {
            this.myConnection.start();
        }
        catch (Exception ex) {
            this.myConnection.close();
            throw ex;
        }
    }

    public void onException(JMSException jsme) {
        this.exit();
    }

    public void onMessage(Message message) {
        try {
            TextMessage textMessage = (TextMessage)message;
            String text = textMessage.getText();
            System.out.println(text);
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
        }
    }

    protected void writeMessage(String text) throws JMSException {
        TextMessage message = this.myPubSession.createTextMessage();
        message.setText(this.myUserName + " : " + text);
        this.myPublisher.publish((Message)message);
        System.out.println(message);
    }

    public void close() throws JMSException {
        this.myConnection.close();
    }

    private void exit() {
        try {
            this.myConnection.close();
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
        }
        System.exit(0);
    }

    public static void main(String[] args) {
        TopicPubSub aBS = null;
        try {
            if (args.length != 3) {
                System.out.println("Topic or username missing");
            }
            aBS = new TopicPubSub(args[0], args[1], args[2]);
            for (int i = 0; i < 100; ++i) {
                aBS.writeMessage(Integer.toString(i));
                System.out.println(i);
            }
            BufferedReader commandLine = new BufferedReader(new InputStreamReader(System.in));
            boolean doLoop = true;
            while (doLoop) {
                String s = commandLine.readLine();
                if (!s.equalsIgnoreCase("exit")) continue;
                doLoop = false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        catch (Error e) {
            System.out.println("Attention!!! Unhandled Error!");
            e.printStackTrace();
        }
        try {
            if (aBS != null) {
                aBS.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

