/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import javax.jms.ConnectionMetaData;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;

public class SyncTopicReceiver
implements ExceptionListener,
MessageListener {
    private TopicSession mySyncSession;
    private TopicSession myAsyncSession;
    private TopicConnection myConnection;
    private TopicSubscriber mySyncSubscriber;
    private TopicSubscriber myAsyncSubscriber;
    private int myTimeToWait;
    private int myMessagesReceived;
    private int myMessagesToReceive;
    private static boolean bEnd;

    public SyncTopicReceiver(String topicName, String timeToWait, String messagesToReceive) throws Exception {
        bEnd = false;
        this.myMessagesReceived = 0;
        this.myTimeToWait = new Integer(timeToWait);
        this.myMessagesToReceive = Integer.parseInt(messagesToReceive);
        InitialContext jndi = null;
        try {
            jndi = new InitialContext();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        TopicConnectionFactory conFactory = (TopicConnectionFactory)jndi.lookup("jms.TopicConnectionFactory");
        this.myConnection = conFactory.createTopicConnection("", "");
        this.mySyncSession = this.myConnection.createTopicSession(false, 1);
        this.myAsyncSession = this.myConnection.createTopicSession(false, 1);
        Topic chatTopic = (Topic)jndi.lookup("jms.topic." + topicName);
        this.mySyncSubscriber = this.mySyncSession.createSubscriber(chatTopic);
        this.myAsyncSubscriber = this.myAsyncSession.createSubscriber(chatTopic);
        this.myConnection.setExceptionListener((ExceptionListener)this);
        try {
            this.myConnection.start();
            ConnectionMetaData meta = this.myConnection.getMetaData();
            System.out.println("Started connection: Provider: " + meta.getJMSProviderName() + ", Version: " + meta.getProviderVersion());
            System.out.println("Waiting for " + this.myMessagesToReceive + " messages to receive.");
        }
        catch (Exception ex) {
            this.myConnection.close();
            throw ex;
        }
    }

    private void receiveMessages() {
        if (this.myMessagesReceived > this.myMessagesToReceive) {
            return;
        }
        try {
            this.myAsyncSubscriber.setMessageListener((MessageListener)this);
            System.out.println("receiving messages...");
            boolean bToggle = true;
            while (this.myMessagesReceived < this.myMessagesToReceive) {
                TextMessage textMessage = bToggle ? (TextMessage)this.mySyncSubscriber.receive((long)this.myTimeToWait) : (TextMessage)this.mySyncSubscriber.receive();
                boolean bl = bToggle = !bToggle;
                if (textMessage != null) {
                    String text = textMessage.getText();
                    ++this.myMessagesReceived;
                    System.out.println(this.toString() + ":Syncronous Receiving: Count:" + this.myMessagesReceived + ",Text:" + text + ",msgID:" + textMessage.getJMSMessageID());
                    continue;
                }
                System.out.println("No Message received.");
            }
        }
        catch (JMSException jsme) {
            jsme.printStackTrace();
        }
        catch (Error ex) {
            ex.printStackTrace();
        }
        System.out.println("Messages received: " + this.myMessagesReceived);
    }

    public void onException(JMSException jsme) {
        this.exit();
    }

    public void onMessage(Message message) {
        if (this.myMessagesReceived > this.myMessagesToReceive) {
            return;
        }
        try {
            TextMessage textMessage = (TextMessage)message;
            if (textMessage != null) {
                String text = textMessage.getText();
                ++this.myMessagesReceived;
                System.out.println(this.toString() + ":Asyncronous Receiving: Count:" + this.myMessagesReceived + ",Text:" + text + ",msgID:" + textMessage.getJMSMessageID());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.myMessagesReceived == this.myMessagesToReceive) {
            this.exit();
        }
    }

    private void exit() {
        bEnd = true;
    }

    public void close() throws JMSException {
        this.myAsyncSubscriber.close();
        this.mySyncSubscriber.close();
        this.myConnection.close();
        System.out.println(new Date().toString() + ":Connection closed");
    }

    public static void main(String[] args) {
        SyncTopicReceiver aSTR = null;
        try {
            if (args.length != 3) {
                System.out.println("Topic,TimeToWait or MessageToReceive missing");
            }
            aSTR = new SyncTopicReceiver(args[0], args[1], args[2]);
            System.out.println("Type 'start' to start connection ...");
            while (!bEnd) {
                try {
                    BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
                    String s = stdin.readLine();
                    if (!s.equalsIgnoreCase("start")) continue;
                    stdin.close();
                    aSTR.receiveMessages();
                }
                catch (IOException ioe) {}
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        catch (Error e) {
            System.out.println("Unhandled Error!");
            e.printStackTrace();
        }
        try {
            while (!bEnd) {
                Thread.sleep(100L);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            if (aSTR != null) {
                aSTR.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

