/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.test;

import java.io.PrintStream;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class SyncMultiTopicSubscriber
implements ExceptionListener {
    private static PrintStream out = System.out;
    private static Topic a_topic = null;
    private static int subscribers_numb = 0;
    private static int torecv = 0;
    private static int rcvd = 0;
    private TopicSession tSession = null;
    private TopicSubscriber[] tSubscribers = null;

    public SyncMultiTopicSubscriber(TopicConnection t_conn) {
        try {
            this.tSession = t_conn.createTopicSession(false, 1);
            this.tSubscribers = new TopicSubscriber[subscribers_numb];
            for (int i = 0; i < subscribers_numb; ++i) {
                this.tSubscribers[i] = this.tSession.createSubscriber(a_topic);
                t_conn.setExceptionListener((ExceptionListener)this);
            }
            t_conn.start();
        }
        catch (JMSException jmse) {
            jmse.printStackTrace(out);
            System.exit(1);
        }
    }

    public void onException(JMSException jsme) {
        out.println("subscriber exit : " + jsme.toString());
        jsme.printStackTrace(out);
        System.exit(1);
    }

    private void sync_receive() {
        for (int i = 0; i < subscribers_numb && rcvd < torecv; ++i) {
            try {
                TextMessage textMessage = (TextMessage)this.tSubscribers[i].receive();
                textMessage.getText();
                ++rcvd;
                continue;
            }
            catch (JMSException jex) {
                this.onException(jex);
            }
        }
    }

    public static void main(String[] argv) {
        long lapse = System.currentTimeMillis();
        long endmillis = 0L;
        TopicConnectionFactory tFactory = null;
        InitialContext jndi = null;
        String topicname = argv[0];
        int conn_numb = Integer.parseInt(argv[1]);
        int sessions_numb = Integer.parseInt(argv[2]);
        int i = 0;
        int cidx = 0;
        SyncMultiTopicSubscriber[][] i_list = new SyncMultiTopicSubscriber[conn_numb][sessions_numb];
        TopicConnection[] t_conn_list = new TopicConnection[conn_numb];
        torecv = Integer.parseInt(argv[4]);
        subscribers_numb = Integer.parseInt(argv[3]);
        out.println("_____________________________________________________");
        out.println("begin of main() at " + lapse);
        out.println("cmdl pars : \n   topicname                  : \"" + topicname + "\"\n" + "   number of connections      : " + conn_numb + "\n" + "   sessions per connection    : " + sessions_numb + "\n" + "   subscribers per session    : " + subscribers_numb + "\n" + "   msgs to receive (total)    : " + torecv);
        try {
            jndi = new InitialContext();
            a_topic = (Topic)jndi.lookup("jms.topic." + topicname);
            tFactory = (TopicConnectionFactory)jndi.lookup("jms.TopicConnectionFactory");
        }
        catch (NamingException jne) {
            jne.printStackTrace(out);
            System.exit(1);
        }
        out.println("_____________________________________________________\nbeginning to create " + conn_numb + " connection(s) at " + System.currentTimeMillis());
        for (cidx = 0; cidx < conn_numb; ++cidx) {
            try {
                t_conn_list[cidx] = tFactory.createTopicConnection("", "");
            }
            catch (JMSException jmse) {
                jmse.printStackTrace(out);
                System.exit(1);
            }
            out.println("beginning to create " + sessions_numb + " session(s) at      " + System.currentTimeMillis());
            for (i = 0; i < sessions_numb; ++i) {
                i_list[cidx][i] = new SyncMultiTopicSubscriber(t_conn_list[cidx]);
            }
        }
        while (rcvd < torecv) {
            for (cidx = 0; cidx < conn_numb && rcvd < torecv; ++cidx) {
                for (i = 0; i < sessions_numb && rcvd < torecv; ++i) {
                    i_list[cidx][i].sync_receive();
                }
            }
        }
        for (cidx = 0; cidx < conn_numb; ++cidx) {
            try {
                t_conn_list[cidx].close();
                continue;
            }
            catch (JMSException jmse) {
                jmse.printStackTrace(out);
                System.exit(1);
            }
        }
        out.println("_____________________________________________________");
        endmillis = System.currentTimeMillis();
        out.println("end of main() at " + endmillis + " , duration : " + (endmillis - lapse));
        out.println("_____________________________________________________");
    }
}

