/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import javax.jms.ConnectionMetaData;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class OneTopicSubscriber
implements MessageListener,
ExceptionListener {
    private TopicSession mySubSession;
    private TopicConnection myConnection;
    private int myMessagesReceived = 0;
    private int myMessagesToReceive = 0;
    private static boolean end;

    public OneTopicSubscriber(String topicName, String messagesToReceive) {
        end = false;
        this.myMessagesToReceive = Integer.parseInt(messagesToReceive);
        InitialContext jndi = null;
        try {
            jndi = new InitialContext();
            TopicConnectionFactory conFactory = (TopicConnectionFactory)jndi.lookup("jms.TopicConnectionFactory");
            this.myConnection = conFactory.createTopicConnection("", "");
            this.mySubSession = this.myConnection.createTopicSession(false, 1);
            Topic topic1 = (Topic)jndi.lookup("jms.topic." + topicName + "_1");
            Topic topic2 = (Topic)jndi.lookup("jms.topic." + topicName + "_2");
            TopicSubscriber subscriber1a = this.mySubSession.createSubscriber(topic1);
            TopicSubscriber subscriber1b = this.mySubSession.createSubscriber(topic1);
            TopicSubscriber subscriber2a = this.mySubSession.createSubscriber(topic2);
            TopicSubscriber subscriber2b = this.mySubSession.createSubscriber(topic2);
            subscriber1a.setMessageListener((MessageListener)this);
            subscriber1b.setMessageListener((MessageListener)this);
            subscriber2a.setMessageListener((MessageListener)this);
            subscriber2b.setMessageListener((MessageListener)this);
            this.myConnection.setExceptionListener((ExceptionListener)this);
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
            System.exit(1);
        }
        catch (NamingException jne) {
            jne.printStackTrace();
            System.exit(1);
        }
    }

    public void onException(JMSException jsme) {
        this.exit();
    }

    public void onMessage(Message message) {
        if (this.myMessagesReceived > this.myMessagesToReceive) {
            return;
        }
        try {
            TextMessage textMessage = (TextMessage)message;
            ++this.myMessagesReceived;
            String text = textMessage.getText();
            String out = "Received ";
            if (textMessage.getJMSRedelivered()) {
                out = out + "and redelivered: ";
            }
            if (text.length() > 64) {
                System.out.println(out + text.substring(0, 64));
            } else {
                System.out.println(out + text);
            }
            if (text.equals("end")) {
                this.notify();
            }
            if (this.myMessagesReceived == this.myMessagesToReceive) {
                Date end = new Date();
                System.out.println("Last Message received: " + text + " at " + end.toString());
                this.exit();
            }
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
        }
    }

    public void close() throws JMSException {
        this.myConnection.close();
    }

    public void start() {
        try {
            this.myConnection.start();
            ConnectionMetaData meta = this.myConnection.getMetaData();
            System.out.println("Started connection: Provider: " + meta.getJMSProviderName() + ", Version: " + meta.getProviderVersion());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void exit() {
        end = true;
    }

    public static void main(String[] args) {
        OneTopicSubscriber aTS = null;
        try {
            if (args.length != 2) {
                System.out.println("Topic or Messagenumber missing");
            }
            System.out.println("Type 'start' to start connection ...");
            aTS = new OneTopicSubscriber(args[0], args[1]);
            String s = "";
            BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
            while (!end) {
                s = stdin.readLine();
                if (!s.equalsIgnoreCase("start")) continue;
                stdin.close();
                aTS.start();
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            while (!end) {
                Thread.sleep(100L);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            if (aTS != null) {
                aTS.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

