/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import javax.jms.ConnectionMetaData;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class OneQueueReceiver
implements MessageListener,
ExceptionListener {
    private QueueConnection myConnection = null;
    private QueueSession qSession = null;
    private Queue receiveQueue = null;
    private QueueReceiver qReceiver = null;
    private int myMessagesReceived = 0;
    private int myMessagesToReceive = 0;
    private static boolean end;
    private int mySeqNumber = 0;

    public OneQueueReceiver(String queueName, String messagesToReceive, String password) {
        try {
            end = false;
            this.myMessagesToReceive = Integer.parseInt(messagesToReceive);
            QueueConnectionFactory qFactory = null;
            InitialContext jndi = null;
            jndi = new InitialContext();
            qFactory = (QueueConnectionFactory)jndi.lookup("jms.QueueConnectionFactory");
            this.myConnection = qFactory.createQueueConnection("", password);
            this.qSession = this.myConnection.createQueueSession(false, 1);
            this.receiveQueue = (Queue)jndi.lookup("jms.queue." + queueName);
            this.qReceiver = this.qSession.createReceiver(this.receiveQueue);
            this.qReceiver.setMessageListener((MessageListener)this);
            this.myConnection.setExceptionListener((ExceptionListener)this);
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
            System.exit(1);
        }
        catch (NamingException jne) {
            jne.printStackTrace();
            System.exit(1);
        }
    }

    public void onException(JMSException jsme) {
        System.out.println("Exit Receiver due to: " + jsme.toString());
        this.exit();
    }

    public void onMessage(Message message) {
        try {
            if (this.myMessagesReceived > this.myMessagesToReceive) {
                return;
            }
            TextMessage textMessage = (TextMessage)message;
            ++this.myMessagesReceived;
            String text = textMessage.getText();
            String out = "Received ";
            if (textMessage.getJMSRedelivered()) {
                out = out + "and redelivered: ";
            }
            if (text.length() > 64) {
                System.out.println(out + text.substring(0, 64));
            } else {
                System.out.println(out + text);
            }
            int seq = textMessage.getIntProperty("MsgNumber");
            this.mySeqNumber = this.myMessagesReceived == 1 ? seq : ++this.mySeqNumber;
            if (this.mySeqNumber != seq) {
                System.out.println("Sequence Error: Expected:" + this.mySeqNumber + " , Received: " + seq);
                this.exit();
            }
            if (this.myMessagesReceived == this.myMessagesToReceive) {
                Date end = new Date();
                System.out.println("Last Message received: " + text + " at " + end.toString());
                this.exit();
            }
        }
        catch (Exception rte) {
            rte.printStackTrace();
        }
    }

    public void exit() {
        end = true;
    }

    public void close() throws JMSException {
        this.myConnection.close();
    }

    public void start() {
        try {
            this.myConnection.start();
            ConnectionMetaData meta = this.myConnection.getMetaData();
            System.out.println("Started connection: Provider: " + meta.getJMSProviderName() + ", Version: " + meta.getProviderVersion());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] argv) {
        if (argv.length != 3) {
            System.out.println("QueueName or Messagenumber missing");
        }
        OneQueueReceiver aQR = new OneQueueReceiver(argv[0], argv[1], argv[2]);
        System.out.println("Type 'start' to start connection.");
        try {
            String s = "";
            BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
            while (!end) {
                s = stdin.readLine();
                if (!s.equalsIgnoreCase("start")) continue;
                stdin.close();
                aQR.start();
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            while (!end) {
                Thread.sleep(100L);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            aQR.close();
        }
        catch (JMSException ex) {
            ex.printStackTrace();
        }
    }
}

