/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import javax.jms.ConnectionMetaData;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class OneDurableTopicSubscriber
implements MessageListener,
ExceptionListener {
    private TopicSession mySubSession1A;
    private TopicSession mySubSession1B;
    private TopicSession mySubSession2A;
    private TopicSession mySubSession2B;
    private TopicConnection myConnection1;
    private TopicConnection myConnection2;
    private TopicSubscriber mySubscriberA;
    private TopicSubscriber mySubscriberB;
    private TopicSubscriber mySubscriberC;
    private TopicSubscriber mySubscriberD;
    private TopicSubscriber mySubscriber2A;
    private TopicSubscriber mySubscriber2B;
    private TopicSubscriber mySubscriber2C;
    private TopicSubscriber mySubscriber2D;
    private int myMessagesToReceive = 0;
    private int myMessagesReceived = 0;
    private String myDurableTopicNameA = "Durable Sub Test_1A";
    private String myDurableTopicNameB = "Durable Sub Test_1B";
    private String myDurableTopicNameC = "Durable Sub Test_1C";
    private String myDurableTopicNameD = "Durable Sub Test_1D";
    private String myDurableTopicName2A = "Durable Sub Test_2A";
    private String myDurableTopicName2B = "Durable Sub Test_2B";
    private String myDurableTopicName2C = "Durable Sub Test_2C";
    private String myDurableTopicName2D = "Durable Sub Test_2D";
    static boolean doLoop;

    public OneDurableTopicSubscriber(String topicName, String messagesToReceive) throws JMSException, NamingException {
        doLoop = true;
        this.myMessagesToReceive = Integer.parseInt(messagesToReceive);
        InitialContext jndi = null;
        try {
            jndi = new InitialContext();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        TopicConnectionFactory conFactory = (TopicConnectionFactory)jndi.lookup("jms.TopicConnectionFactory");
        this.myConnection1 = conFactory.createTopicConnection("", "");
        this.myConnection2 = conFactory.createTopicConnection("", "");
        this.mySubSession1A = this.myConnection1.createTopicSession(false, 1);
        this.mySubSession1B = this.myConnection1.createTopicSession(false, 1);
        this.mySubSession2A = this.myConnection2.createTopicSession(false, 1);
        this.mySubSession2B = this.myConnection2.createTopicSession(false, 1);
        Topic aTopic = (Topic)jndi.lookup("jms.topic." + topicName + "_1");
        Topic aTopic2 = (Topic)jndi.lookup("jms.topic." + topicName + "_2");
        this.mySubscriberA = this.mySubSession1A.createDurableSubscriber(aTopic, this.myDurableTopicNameA);
        this.mySubscriberB = this.mySubSession1A.createDurableSubscriber(aTopic, this.myDurableTopicNameB);
        this.mySubscriberC = this.mySubSession1B.createDurableSubscriber(aTopic, this.myDurableTopicNameC);
        this.mySubscriberD = this.mySubSession1B.createDurableSubscriber(aTopic, this.myDurableTopicNameD);
        this.mySubscriber2A = this.mySubSession2A.createDurableSubscriber(aTopic2, this.myDurableTopicName2A);
        this.mySubscriber2B = this.mySubSession2A.createDurableSubscriber(aTopic2, this.myDurableTopicName2B);
        this.mySubscriber2C = this.mySubSession2B.createDurableSubscriber(aTopic2, this.myDurableTopicName2C);
        this.mySubscriber2D = this.mySubSession2B.createDurableSubscriber(aTopic2, this.myDurableTopicName2D);
        this.mySubscriberA.setMessageListener((MessageListener)this);
        this.mySubscriberB.setMessageListener((MessageListener)this);
        this.mySubscriberC.setMessageListener((MessageListener)this);
        this.mySubscriberD.setMessageListener((MessageListener)this);
        this.mySubscriber2A.setMessageListener((MessageListener)this);
        this.mySubscriber2B.setMessageListener((MessageListener)this);
        this.mySubscriber2C.setMessageListener((MessageListener)this);
        this.mySubscriber2D.setMessageListener((MessageListener)this);
        this.myConnection1.setExceptionListener((ExceptionListener)this);
        this.myConnection2.setExceptionListener((ExceptionListener)this);
        if (this.myMessagesToReceive < 1) {
            this.myConnection1.start();
            this.myConnection2.start();
            this.myConnection1.close();
            this.myConnection2.close();
            System.exit(0);
        }
    }

    public void onException(JMSException jsme) {
        System.out.println(jsme.toString());
        this.exit();
    }

    public void onMessage(Message message) {
        try {
            if (this.myMessagesReceived > this.myMessagesToReceive) {
                return;
            }
            TextMessage textMessage = (TextMessage)message;
            ++this.myMessagesReceived;
            String text = textMessage.getText();
            String out = "Received ";
            if (textMessage.getJMSRedelivered()) {
                out = out + "and redelivered: ";
            }
            if (text.length() > 64) {
                System.out.println(out + text.substring(0, 64));
            } else {
                System.out.println(out + text);
            }
            if (text.equals("end")) {
                this.notify();
            }
            if (this.myMessagesReceived == this.myMessagesToReceive) {
                Date end = new Date();
                System.out.println("Last Message received: " + text + " at " + end.toString());
                doLoop = false;
            }
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
        }
    }

    public void close() throws JMSException {
        this.mySubscriberA.close();
        this.mySubscriberB.close();
        this.mySubscriberC.close();
        this.mySubscriberD.close();
        this.mySubscriber2A.close();
        this.mySubscriber2B.close();
        this.mySubscriber2C.close();
        this.mySubscriber2D.close();
        this.mySubSession1A.unsubscribe(this.myDurableTopicNameA);
        this.mySubSession1A.unsubscribe(this.myDurableTopicNameB);
        this.mySubSession1B.unsubscribe(this.myDurableTopicNameC);
        this.mySubSession1B.unsubscribe(this.myDurableTopicNameD);
        this.mySubSession2A.unsubscribe(this.myDurableTopicName2A);
        this.mySubSession2A.unsubscribe(this.myDurableTopicName2B);
        this.mySubSession2B.unsubscribe(this.myDurableTopicName2C);
        this.mySubSession2B.unsubscribe(this.myDurableTopicName2D);
        this.myConnection1.close();
        this.myConnection2.close();
    }

    public void start() {
        try {
            this.myConnection1.start();
            this.myConnection2.start();
            ConnectionMetaData meta = this.myConnection1.getMetaData();
            System.out.println("Started connection: Provider: " + meta.getJMSProviderName() + ", Version: " + meta.getProviderVersion());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void exit() {
        try {
            this.close();
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
        }
        System.exit(0);
    }

    public static void main(String[] args) {
        OneDurableTopicSubscriber aDTS = null;
        try {
            if (args.length != 2) {
                System.out.println("Topic or messageToReceive missing");
            }
            System.out.println("Type 'start' to start connection ...");
            aDTS = new OneDurableTopicSubscriber(args[0], args[1]);
            BufferedReader commandLine = new BufferedReader(new InputStreamReader(System.in));
            while (doLoop) {
                String s = commandLine.readLine();
                if (s == null || !s.equalsIgnoreCase("start")) continue;
                commandLine.close();
                aDTS.start();
            }
            aDTS.exit();
        }
        catch (IOException ex) {
        }
        catch (JMSException ex) {
            doLoop = false;
            ex.printStackTrace();
        }
        catch (NamingException ex) {
            doLoop = false;
            ex.printStackTrace();
        }
        try {
            while (doLoop) {
                Thread.sleep(100L);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            if (aDTS != null) {
                aDTS.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

