/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.test;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class MultiQueueReceiver
implements MessageListener,
ExceptionListener {
    private static PrintStream out = System.out;
    private static Queue a_dest = null;
    private static int consumers_numb = 0;
    private static int torecv = 0;
    private static int rcvd = 0;
    private static long lastmsgmillis = 0L;
    private static boolean stopme = false;
    private static boolean timedout = false;
    private static long brcvd = 0L;
    private static String outstr = null;
    private QueueSession m_session = null;
    private QueueReceiver[] m_consumers = null;

    public MultiQueueReceiver(QueueConnection conn) {
        try {
            this.m_session = conn.createQueueSession(false, 1);
            this.m_consumers = new QueueReceiver[consumers_numb];
            for (int i = 0; i < consumers_numb; ++i) {
                this.m_consumers[i] = this.m_session.createReceiver(a_dest);
                this.m_consumers[i].setMessageListener((MessageListener)this);
                conn.setExceptionListener((ExceptionListener)this);
            }
        }
        catch (JMSException jmse) {
            jmse.printStackTrace(out);
            System.exit(1);
        }
    }

    public void onException(JMSException jsme) {
        out.println("consumer exit : " + jsme.toString());
        jsme.printStackTrace(out);
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        try {
            TextMessage textMessage = (TextMessage)message;
            String text = textMessage.getText();
            long msgbytes = text.length();
            long currtime = System.currentTimeMillis();
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                brcvd += msgbytes;
                timedout = (timedout || currtime - lastmsgmillis > 30000L) && ++rcvd != 0;
                stopme = rcvd >= torecv || timedout;
                lastmsgmillis = System.currentTimeMillis();
            }
        }
        catch (Exception rte) {
            rte.printStackTrace(out);
            out.flush();
        }
    }

    public static void main(String[] argv) throws FileNotFoundException {
        long startmillis = 0L;
        long endmillis = 0L;
        QueueConnectionFactory ConnFactory = null;
        InitialContext jndi = null;
        String destname = argv[0];
        int conn_numb = Integer.parseInt(argv[2]);
        int sessions_numb = Integer.parseInt(argv[3]);
        int i = 0;
        int cidx = 0;
        MultiQueueReceiver[][] i_list = new MultiQueueReceiver[conn_numb][sessions_numb];
        QueueConnection[] conn_list = new QueueConnection[conn_numb];
        if (!argv[1].equals("-")) {
            out = new PrintStream(new FileOutputStream(argv[1], true));
        }
        consumers_numb = Integer.parseInt(argv[4]);
        torecv = Integer.parseInt(argv[5]) * conn_numb * sessions_numb * consumers_numb;
        outstr = "persistent , asynchronous , queue , consumer , nondurable , " + conn_numb + " , " + sessions_numb + " , " + consumers_numb + " , " + torecv + " , ";
        try {
            jndi = new InitialContext();
            a_dest = (Queue)jndi.lookup("jms.queue." + destname);
            ConnFactory = (QueueConnectionFactory)jndi.lookup("jms.QueueConnectionFactory");
        }
        catch (NamingException jne) {
            jne.printStackTrace(out);
            System.exit(1);
        }
        for (cidx = 0; cidx < conn_numb; ++cidx) {
            try {
                conn_list[cidx] = ConnFactory.createQueueConnection("", "");
            }
            catch (JMSException jmse) {
                jmse.printStackTrace(out);
                out.flush();
                System.exit(1);
            }
            for (i = 0; i < sessions_numb; ++i) {
                i_list[cidx][i] = new MultiQueueReceiver(conn_list[cidx]);
            }
        }
        lastmsgmillis = System.currentTimeMillis();
        startmillis = System.currentTimeMillis();
        try {
            for (cidx = 0; cidx < conn_numb; ++cidx) {
                conn_list[cidx].start();
            }
        }
        catch (JMSException jmse) {
            jmse.printStackTrace(out);
            out.flush();
            System.exit(1);
        }
        try {
            while (!stopme) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        endmillis = System.currentTimeMillis();
        for (cidx = 0; cidx < conn_numb; ++cidx) {
            try {
                conn_list[cidx].close();
                continue;
            }
            catch (JMSException jmse) {
                jmse.printStackTrace(out);
                System.exit(1);
            }
        }
        outstr = outstr + (timedout ? "########TIMEDOUT###### , " : "                       , ");
        outstr = outstr + rcvd + " ," + brcvd + " ," + startmillis + " , " + endmillis;
        out.println(outstr);
        out.flush();
        out.close();
        System.exit(0);
    }
}

