/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.test;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.StreamMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class MassQueueStreamSender
extends Thread
implements ExceptionListener {
    private int m_threadId;
    private int m_sendCount;
    private int m_priority;
    private int m_deliveryMode;
    private int m_displayInterval;
    private Queue m_queue;
    private QueueConnection m_connect;
    private QueueSession m_session;
    private QueueSender m_sender;
    private StreamMessage m_streamMsg;
    private byte[] m_byteArray;
    private Object[] m_numberObjectArray;
    private String[] m_numberStringArray;
    private static int sm_maxMsgPerClient = 0;
    private static int sm_clientsCount = 0;
    private static int sm_sumSendCount = 0;
    private static long sm_startTime = 0L;
    private static String sm_startDate = null;
    private static final int MAX_WRITE_BOOLEAN = 300;
    private static final int MAX_WRITE_BYTE = 300;
    private static final int MAX_WRITE_BYTE_ARRAY = 20;
    private static final int MAX_WRITE_CHAR = 200;
    private static final int MAX_WRITE_DOUBLE = 100;
    private static final int MAX_WRITE_FLOAT = 200;
    private static final int MAX_WRITE_INT = 200;
    private static final int MAX_WRITE_LONG = 100;
    private static final int MAX_WRITE_SHORT = 300;
    private static final int MAX_WRITE_STRING = 20;
    private static final int MAX_WRITE_NUM_STRING = 2;
    private static final int MAX_WRITE_NUM_OBJECT = 20;
    private static final int MAX_NUMBER_FORMATS = 6;

    public MassQueueStreamSender(int threadId, String queueName, String priority, int modeDelivery) {
        try {
            this.m_sendCount = 0;
            this.m_threadId = threadId;
            this.m_priority = Integer.parseInt(priority);
            this.m_deliveryMode = modeDelivery;
            this.m_displayInterval = modeDelivery == 2 ? 100 : 200;
            InitialContext jndi = new InitialContext();
            QueueConnectionFactory qFactory = (QueueConnectionFactory)jndi.lookup("jms.QueueConnectionFactory");
            this.m_connect = qFactory.createQueueConnection("", "");
            this.m_session = this.m_connect.createQueueSession(false, 1);
            this.m_queue = (Queue)jndi.lookup("jms.queue." + queueName);
            this.m_sender = this.m_session.createSender(this.m_queue);
            this.m_connect.setExceptionListener((ExceptionListener)this);
            this.m_byteArray = new byte[]{1, -1, 2, -2, 3, -3, 4, -4, 5, -5};
            this.m_streamMsg = this.m_session.createStreamMessage();
            this.m_streamMsg.setIntProperty("booleanCount", 300);
            this.m_streamMsg.setIntProperty("byteCount", 300);
            this.m_streamMsg.setIntProperty("ByteArrayCount", 20);
            this.m_streamMsg.setIntProperty("ByteArrayLength", this.m_byteArray.length);
            this.m_streamMsg.setIntProperty("charCount", 200);
            this.m_streamMsg.setIntProperty("doubleCount", 100);
            this.m_streamMsg.setIntProperty("floatCount", 200);
            this.m_streamMsg.setIntProperty("intCount", 200);
            this.m_streamMsg.setIntProperty("longCount", 100);
            this.m_streamMsg.setIntProperty("numObjectCount", 20);
            this.m_streamMsg.setIntProperty("numStringCount", 2);
            this.m_streamMsg.setIntProperty("shortCount", 300);
            this.m_streamMsg.setIntProperty("StringCount", 20);
            this.m_numberStringArray = new String[6];
            this.m_numberStringArray[0] = String.valueOf(-128);
            this.m_numberStringArray[1] = String.valueOf(Double.MIN_VALUE);
            this.m_numberStringArray[2] = String.valueOf(Float.MIN_VALUE);
            this.m_numberStringArray[3] = String.valueOf(Integer.MIN_VALUE);
            this.m_numberStringArray[4] = String.valueOf(Long.MIN_VALUE);
            this.m_numberStringArray[5] = String.valueOf(Short.MIN_VALUE);
            this.m_numberObjectArray = new Object[6];
            this.m_numberObjectArray[0] = new Byte(127);
            this.m_numberObjectArray[1] = new Double(Double.MAX_VALUE);
            this.m_numberObjectArray[2] = new Float(Float.MAX_VALUE);
            this.m_numberObjectArray[3] = new Integer(Integer.MAX_VALUE);
            this.m_numberObjectArray[4] = new Long(Long.MAX_VALUE);
            this.m_numberObjectArray[5] = new Short(Short.MAX_VALUE);
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
            System.exit(1);
        }
        catch (NamingException jne) {
            jne.printStackTrace();
            System.exit(1);
        }
    }

    public static void main(String[] argv) {
        if (argv.length <= 5) {
            System.out.println("Parameter required: <QueueName1> <QueueName2> <Priority> <maxMessages> <maxClientPairs> [TRANSIENT]");
        }
        int maxClients = sm_clientsCount = 2 * Integer.parseInt(argv[4]);
        int msgsWanted = Integer.parseInt(argv[3]);
        if (msgsWanted < 2) {
            sm_maxMsgPerClient = 1;
            maxClients = 1;
        } else {
            sm_maxMsgPerClient = msgsWanted / maxClients;
        }
        int modeDelivery = 2;
        if (argv.length > 5 && argv[5].equalsIgnoreCase("transient")) {
            modeDelivery = 1;
            System.out.println("Send transient stream messages");
        }
        SimpleDateFormat currDateTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sm_startDate = currDateTime.format(new Date());
        sm_startTime = System.currentTimeMillis();
        for (int i = 0; i < maxClients; ++i) {
            MassQueueStreamSender currSender = i % 2 == 0 ? new MassQueueStreamSender(i, argv[0], argv[2], modeDelivery) : new MassQueueStreamSender(i, argv[1], argv[2], modeDelivery);
            System.out.println("StreamSender T" + i + " started");
            currSender.start();
        }
    }

    private synchronized void exitClient() {
        sm_sumSendCount += this.m_sendCount;
        if (--sm_clientsCount <= 0) {
            long duration = System.currentTimeMillis() - sm_startTime;
            System.out.println(sm_sumSendCount + " messages sent: " + duration + " msec");
            if (duration > 0L) {
                System.out.println((long)(sm_sumSendCount * 1000) / duration + " messages/sec");
            }
            System.exit(0);
        }
    }

    public void onException(JMSException jsme) {
        System.out.println("Exit Sender due to: " + jsme.toString());
        System.exit(1);
    }

    private void println(String msg) {
        System.out.println("T" + this.m_threadId + ": " + msg);
    }

    public void run() {
        long startTime = System.currentTimeMillis();
        while (this.m_sendCount < sm_maxMsgPerClient) {
            try {
                this.sendMessage(this.m_sendCount + 1, this.m_priority);
                ++this.m_sendCount;
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
            }
        }
        long duration = System.currentTimeMillis() - startTime;
        this.println(this.m_sendCount + " messages sent: " + duration + " msec");
        this.println((long)(this.m_sendCount * 1000) / duration + " messages/sec");
        try {
            this.m_connect.close();
        }
        catch (JMSException ex) {
            // empty catch block
        }
        this.exitClient();
    }

    private void sendMessage(int iMessageNumber, int priority) {
        try {
            int k;
            int i;
            int i2;
            this.m_streamMsg.clearBody();
            boolean display = sm_maxMsgPerClient == 1;
            String msgInfo = this.m_threadId + "." + iMessageNumber + "(" + sm_startDate + ")";
            this.m_streamMsg.writeString(msgInfo);
            if (display) {
                this.println(msgInfo);
            }
            for (int i3 = 1; i3 <= 300; ++i3) {
                this.m_streamMsg.writeBoolean(i3 % 2 == 0);
                if (!display || i3 > 2 && i3 != 300) continue;
                this.println("writeBoolean: " + (i3 % 2 == 0));
            }
            int b = -128;
            for (i2 = 1; i2 <= 300; ++i2) {
                this.m_streamMsg.writeByte((byte)b);
                if (display && (i2 <= 5 || i2 == 300)) {
                    this.println("writeByte: " + b);
                }
                b = b < 127 ? (int)((byte)(b + 1)) : -128;
            }
            for (i2 = 1; i2 <= 20; ++i2) {
                this.m_streamMsg.writeBytes(this.m_byteArray);
                if (!display || i2 != 1 && i2 != 20) continue;
                this.println("writeBytes(" + this.m_byteArray.length + "): " + this.m_byteArray[0] + " " + this.m_byteArray[this.m_byteArray.length - 1]);
            }
            for (i2 = 1; i2 <= 200; ++i2) {
                this.m_streamMsg.writeChar('x');
                if (!display || i2 > 3) continue;
                this.println("writeChar: x");
            }
            for (i2 = 1; i2 <= 100; ++i2) {
                this.m_streamMsg.writeDouble((double)i2);
                if (!display || i2 > 2 && i2 != 100) continue;
                this.println("writeDouble: " + i2 + ".0");
            }
            for (i2 = 1; i2 <= 200; ++i2) {
                this.m_streamMsg.writeFloat((float)i2);
                if (!display || i2 > 3 && i2 != 200) continue;
                this.println("writeFloat: " + i2 + ".0");
            }
            for (i2 = 1; i2 <= 200; ++i2) {
                this.m_streamMsg.writeInt(i2);
                if (!display || i2 > 3 && i2 != 200) continue;
                this.println("writeInt: " + i2);
            }
            for (long i4 = 1L; i4 <= 100L; ++i4) {
                this.m_streamMsg.writeLong(i4);
                if (!display || i4 > 2L && i4 != 100L) continue;
                this.println("writeLong: " + i4);
            }
            for (i = 1; i <= 20; ++i) {
                for (k = 0; k < 6; ++k) {
                    this.m_streamMsg.writeObject(this.m_numberObjectArray[k]);
                    if (!display || i != 20) continue;
                    this.println("writeObject: " + this.m_numberObjectArray[k].toString());
                }
            }
            for (i = 1; i <= 2; ++i) {
                for (k = 0; k < 6; ++k) {
                    this.m_streamMsg.writeString(this.m_numberStringArray[k]);
                    if (!display || i != 2) continue;
                    this.println("writeString: " + this.m_numberStringArray[k]);
                }
            }
            for (i = 1; i <= 300; i = (short)(i + 1)) {
                this.m_streamMsg.writeShort((short)i);
                if (!display || i > 4 && i != 300) continue;
                this.println("writeShort: " + i);
            }
            for (i = 1; i <= 20; ++i) {
                this.m_streamMsg.writeString("Pipifax");
                if (!display || i > 2) continue;
                this.println("writeString: Pipifax");
            }
            if (iMessageNumber % this.m_displayInterval == 0) {
                this.println("send: " + msgInfo);
            }
            this.m_sender.send((Message)this.m_streamMsg, this.m_deliveryMode, priority, 0L);
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
        }
    }
}

