/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.test;

import com.sap.sdb.msgServer.test.ReceiveStatisticHandler;
import com.sap.sdb.msgServer.test.ReceiverClient;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class MassQueueReceiver
implements MessageListener,
ExceptionListener,
ReceiverClient {
    private QueueConnection m_queueConnect = null;
    private QueueSession m_queueSession = null;
    private Queue m_receiveQueue = null;
    private int m_ownThreadId;
    private long m_msgCount = 0L;
    private long m_rollbackTrigger = 0L;
    private long m_errorCount = 0L;
    private String[] m_lastMsgID;
    private String[] m_lastMsgText;
    private static int m_clientsCount = 0;
    private static int m_acknowledgeMode = 1;
    private static boolean m_noCheck = false;
    private static boolean m_transacted = false;
    private static boolean m_syncReceive = false;
    private static boolean m_properties = false;
    private static ReceiveStatisticHandler m_receiveStat = null;
    private static final int ROLLBACK_MSG_COUNT = 10;
    private static final int DISPLAY_MSG_COUNT = 200;
    private static final int MAX_PRIORITY = 9;
    private static final int PERSISTENT = 0;
    private static final int TRANSIENT = 1;
    private static final int PRIO_PERSISTENT = 2;
    private static final int PRIO_TRANSIENT = 3;

    public static void main(String[] argv) {
        int ArgIndex = 0;
        if (argv.length == 1) {
            m_clientsCount = 1;
        } else {
            if (argv.length < 3) {
                System.out.println("Parameter required: <QueueName1> <QueueName2> <maxClientPairs> [NOCHECK] [CLIENT_ACK | TRANSACTED] [SYNC] [PROPERTIES]");
                return;
            }
            m_clientsCount = 2 * Integer.parseInt(argv[2]);
            if (m_clientsCount < 2) {
                m_clientsCount = 1;
            }
            ArgIndex = 2;
        }
        if (argv.length > ArgIndex + 1) {
            if (argv[ArgIndex + 1].equalsIgnoreCase("client_ack")) {
                ++ArgIndex;
                m_acknowledgeMode = 2;
                System.out.println("session mode: client acknowledge");
            } else if (argv[ArgIndex + 1].equalsIgnoreCase("transacted")) {
                ++ArgIndex;
                m_transacted = true;
                System.out.println("transacted sessions");
            }
        }
        if (argv.length > ArgIndex + 1 && argv[ArgIndex + 1].equalsIgnoreCase("nocheck")) {
            ++ArgIndex;
            m_noCheck = true;
            System.out.println("without message order check");
        }
        if (argv.length > ArgIndex + 1 && argv[ArgIndex + 1].equalsIgnoreCase("sync")) {
            ++ArgIndex;
            m_syncReceive = true;
            System.out.println("synchronous receive");
        }
        if (argv.length > ArgIndex + 1 && argv[ArgIndex + 1].equalsIgnoreCase("properties")) {
            ++ArgIndex;
            m_properties = true;
            System.out.println("select properties");
        }
        m_receiveStat = new ReceiveStatisticHandler(m_clientsCount);
        m_receiveStat.start();
        int maxClients = m_clientsCount;
        for (int i = 0; i < maxClients; ++i) {
            System.out.println("initializing QueueReceiver T" + i);
            if (i % 2 == 0) {
                new MassQueueReceiver(i, argv[0]);
                continue;
            }
            new MassQueueReceiver(i, argv[1]);
        }
    }

    private MassQueueReceiver(int threadId, String queueName) {
        try {
            this.m_ownThreadId = threadId;
            this.m_lastMsgID = new String[4];
            this.m_lastMsgText = new String[4];
            for (int i = 0; i < this.m_lastMsgID.length; ++i) {
                this.m_lastMsgID[i] = "";
                this.m_lastMsgText[i] = "";
            }
            QueueConnectionFactory qFactory = null;
            InitialContext jndi = null;
            jndi = new InitialContext();
            qFactory = (QueueConnectionFactory)jndi.lookup("jms.QueueConnectionFactory");
            this.m_queueConnect = qFactory.createQueueConnection("", "");
            this.m_queueSession = this.m_queueConnect.createQueueSession(m_transacted, m_acknowledgeMode);
            this.m_receiveQueue = (Queue)jndi.lookup("jms.queue." + queueName);
            QueueReceiver qReceiver = m_properties ? this.m_queueSession.createReceiver(this.m_receiveQueue, "StringProperty = 'Hallo'") : this.m_queueSession.createReceiver(this.m_receiveQueue);
            this.m_queueConnect.setExceptionListener((ExceptionListener)this);
            if (!m_syncReceive) {
                qReceiver.setMessageListener((MessageListener)this);
            }
            this.m_queueConnect.start();
            if (m_syncReceive) {
                SyncClient clientThread = new SyncClient(this, qReceiver);
                clientThread.start();
            }
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
            System.exit(1);
        }
        catch (NamingException jne) {
            jne.printStackTrace();
            System.exit(1);
        }
    }

    public void emptySynchronousMessageReceived() {
        if (this.m_msgCount == 0L) {
            m_receiveStat.clientStarted(this);
        }
    }

    private void exit() {
        try {
            this.m_queueConnect.close();
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
        }
        System.exit(0);
    }

    public long getErrorCount() {
        return this.m_errorCount;
    }

    public long getMessageCount() {
        return this.m_msgCount;
    }

    public int getThreadId() {
        return this.m_ownThreadId;
    }

    public void onException(JMSException jsme) {
        this.println("*** Exit Receiver due to:");
        this.println("*** " + jsme.toString());
        this.exit();
    }

    public void onMessage(Message message) {
        ++this.m_msgCount;
        try {
            int msgType;
            boolean isTransient;
            if (this.m_msgCount == this.m_rollbackTrigger) {
                this.m_queueSession.rollback();
            }
            TextMessage textMessage = (TextMessage)message;
            String text = textMessage.getText();
            String msgID = message.getJMSMessageID();
            int msgPrio = message.getJMSPriority();
            boolean wrongMsgOrder = false;
            boolean bl = isTransient = textMessage.getJMSDeliveryMode() == 1;
            int n = msgPrio == 9 ? (isTransient ? 3 : 2) : (msgType = isTransient ? 1 : 0);
            if (!(m_noCheck || this.m_lastMsgText[msgType].compareTo(text) < 0 && this.m_lastMsgID[msgType].compareTo(msgID) < 0)) {
                wrongMsgOrder = true;
                ++this.m_errorCount;
            }
            if (this.m_msgCount <= 3L || this.m_msgCount % 200L == 0L || msgPrio == 9 || wrongMsgOrder) {
                String prioMsg;
                if (this.m_msgCount > 3L) {
                    if (m_transacted) {
                        this.m_queueSession.commit();
                        m_receiveStat.addCommits(190L);
                        this.m_rollbackTrigger = this.m_msgCount + 10L;
                    } else if (m_acknowledgeMode == 2) {
                        message.acknowledge();
                    }
                }
                boolean isRedelivered = textMessage.getJMSRedelivered();
                String out = null;
                String id = " [msgID: " + msgID + "]";
                String string = prioMsg = message.getJMSPriority() > 0 ? " prio " + message.getJMSPriority() : "";
                out = isTransient ? (isRedelivered ? this.m_msgCount + prioMsg + " (transient, redelivered): " : this.m_msgCount + prioMsg + " (transient): ") : (isRedelivered ? this.m_msgCount + prioMsg + " (redelivered): " : this.m_msgCount + prioMsg + ": ");
                out = text.length() > 64 ? out + text.substring(0, 64) : out + text;
                if (wrongMsgOrder) {
                    out = "*** " + out + " [last: " + this.m_lastMsgText[msgType] + " lastID: " + this.m_lastMsgID[msgType] + "]";
                }
                if (textMessage.propertyExists("IntProperty")) {
                    String propText = null;
                    try {
                        propText = " (intProp: " + textMessage.getIntProperty("IntProperty") + ", strProp: '" + textMessage.getStringProperty("StringProperty") + "') ";
                    }
                    catch (Exception rte) {
                        propText = "(***Properties: " + rte.toString() + ")";
                    }
                    this.println(out + propText + id);
                } else {
                    this.println(out + id);
                }
                if (this.m_msgCount == 1L) {
                    m_receiveStat.clientStarted(this);
                }
            }
            this.m_lastMsgID[msgType] = msgID;
            this.m_lastMsgText[msgType] = text;
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
            System.exit(0);
        }
        m_receiveStat.incrSumMessages();
    }

    private void println(String msg) {
        System.out.println("T" + this.m_ownThreadId + ": " + msg);
    }

    private class SyncClient
    extends Thread {
        MassQueueReceiver m_client;
        QueueReceiver m_receiver;

        SyncClient(MassQueueReceiver client, QueueReceiver receiver) {
            this.m_client = client;
            this.m_receiver = receiver;
        }

        public void run() {
            boolean msgReceived;
            this.m_client.println("synchronous receiver started");
            do {
                msgReceived = false;
                try {
                    Message msg = this.m_receiver.receiveNoWait();
                    if (msg == null) {
                        this.m_client.println("null message received");
                        this.m_client.emptySynchronousMessageReceived();
                        break;
                    }
                    this.m_client.onMessage(msg);
                    msgReceived = true;
                }
                catch (JMSException e) {
                    e.printStackTrace();
                    this.m_client.onException(e);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.m_client.exit();
                }
            } while (msgReceived);
            this.m_client.println("synchronous receiver stopped");
        }
    }
}

