/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.ptest;

import com.sap.sdb.msgServer.ptest.PTest;
import com.sap.sdb.msgServer.ptest.PTestCase;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.Random;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class PProducer
extends Thread
implements ExceptionListener {
    private static PrintStream s_out = System.out;
    private static PrintStream s_vout = System.out;
    private static boolean s_haveQueue = true;
    private static boolean s_havePersistent = true;
    private static boolean s_runMsgSel = false;
    private static int s_delivery_mode = 2;
    private static int s_msg_numb = 0;
    private static int s_producers_numb = 0;
    private static int s_destinations_numb = 0;
    private static int s_subscriptions_numb = 0;
    private static String s_payload = "";
    private static StringBuffer s_payload_buf = null;
    private Destination m_dest = null;
    private MessageProducer[][] m_producer_list = null;
    private Session m_session = null;
    private Random m_rnd = new Random();
    private byte[] m_bt = new byte[1];
    private long msg_count = 0L;
    private static long s_msg_count = 0L;

    public PProducer(Destination dest, Connection conny) {
        this.m_dest = dest;
        this.m_producer_list = new MessageProducer[s_producers_numb][s_subscriptions_numb];
        try {
            this.m_session = s_haveQueue ? ((QueueConnection)conny).createQueueSession(false, 1) : ((TopicConnection)conny).createTopicSession(false, 1);
            for (int i = 0; i < s_producers_numb; ++i) {
                for (int j = 0; j < s_subscriptions_numb; ++j) {
                    this.m_producer_list[i][j] = s_haveQueue ? ((QueueSession)this.m_session).createSender((Queue)this.m_dest) : ((TopicSession)this.m_session).createPublisher((Topic)this.m_dest);
                }
            }
            conny.setExceptionListener((ExceptionListener)this);
        }
        catch (Exception e) {
            e.printStackTrace(s_out);
            PProducer.closeoutput();
            System.exit(1);
        }
    }

    public void onException(JMSException jsme) {
        s_out.println("sender exit : " + jsme.toString());
        s_vout.println("sender exit : " + jsme.toString());
        jsme.printStackTrace(s_out);
        PProducer.closeoutput();
        System.exit(1);
    }

    public void run() {
        this.msg_count = 0L;
        try {
            TextMessage textMsg = this.m_session.createTextMessage();
            textMsg.setText(s_payload);
            if (s_runMsgSel) {
                textMsg.setStringProperty("propStringA", "lala");
                textMsg.setBooleanProperty("propBooleanA", this.m_rnd.nextBoolean());
                this.m_rnd.nextBytes(this.m_bt);
                textMsg.setByteProperty("propByteA", this.m_bt[0]);
                textMsg.setShortProperty("propShortA", (short)this.m_rnd.nextInt(100));
                textMsg.setIntProperty("propIntA", this.m_rnd.nextInt());
                textMsg.setLongProperty("propLongA", this.m_rnd.nextLong());
                textMsg.setFloatProperty("propFloatA", this.m_rnd.nextFloat());
                textMsg.setDoubleProperty("propDoubleA", this.m_rnd.nextDouble());
            }
            for (int i = 0; i < s_msg_numb; ++i) {
                for (int j = 0; j < s_producers_numb; ++j) {
                    for (int k = 0; k < s_subscriptions_numb; ++k) {
                        ++this.msg_count;
                        if (s_haveQueue) {
                            ((QueueSender)this.m_producer_list[j][k]).send((Message)textMsg, s_delivery_mode, 1, 0L);
                            continue;
                        }
                        ((TopicPublisher)this.m_producer_list[j][k]).publish((Message)textMsg, s_delivery_mode, 1, 0L);
                    }
                }
            }
            s_vout.println(new Date().toString() + " End: " + this.getName() + "- Messages Sent:" + this.msg_count);
            s_vout.flush();
        }
        catch (Exception jmse) {
            jmse.printStackTrace(s_out);
            PProducer.closeoutput();
            System.exit(1);
        }
    }

    public static void main(String[] argv) throws FileNotFoundException {
        PProducer.main_internal(argv[0], !argv[1].equalsIgnoreCase("transient"), !argv[2].equalsIgnoreCase("topic"), argv[3], Integer.parseInt(argv[4]), Integer.parseInt(argv[5]), Integer.parseInt(argv[6]), Integer.parseInt(argv[7]), Integer.parseInt(argv[8]), !argv[9].equalsIgnoreCase("noselector"), Integer.parseInt(argv[10]), Integer.parseInt(argv[11]));
    }

    public static void main_internal(String output_prefix, boolean have_persistent, boolean haveQueue, String outputfilename, int conn_numb, int sessions_numb, int producers_numb, int msg_numb, int payload_size, boolean runMsgSel, int destinations_numb, int subscriptions_numb) throws FileNotFoundException {
        long startmillis = 0L;
        long endmillis = 0L;
        long total_msgs = 0L;
        long total_bytes = 0L;
        String outstr = null;
        String current_destname = null;
        Destination current_dest = null;
        ConnectionFactory connFactory = null;
        InitialContext jndi = null;
        int i = 0;
        int cidx = 0;
        PProducer[][][] p_list = null;
        Connection[][] conn_list = null;
        try {
            int dest_idx;
            if (!outputfilename.equals("-")) {
                s_out = new PrintStream(new FileOutputStream(outputfilename, true));
                s_vout = new PrintStream(new FileOutputStream(outputfilename + ".v.txt", true));
            }
            s_havePersistent = have_persistent;
            s_runMsgSel = runMsgSel;
            s_delivery_mode = s_havePersistent ? 2 : 1;
            s_haveQueue = haveQueue;
            s_destinations_numb = destinations_numb;
            s_subscriptions_numb = subscriptions_numb;
            s_producers_numb = producers_numb;
            s_msg_numb = msg_numb;
            try {
                Thread.sleep(20000L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace(s_out);
                s_out.flush();
            }
            total_msgs = s_subscriptions_numb * s_msg_numb * s_producers_numb * sessions_numb * conn_numb * s_destinations_numb;
            total_bytes = total_msgs * (long)payload_size;
            p_list = new PProducer[s_destinations_numb][conn_numb][sessions_numb];
            conn_list = new Connection[s_destinations_numb][conn_numb];
            s_payload_buf = new StringBuffer("");
            for (i = 0; i < payload_size; ++i) {
                s_payload_buf.append("a");
            }
            s_payload = s_payload_buf.toString();
            outstr = output_prefix + "producer," + PTest.format(conn_numb, 2, 0) + "," + PTest.format(sessions_numb, 2, 0) + "," + PTest.format(producers_numb, 2, 0) + "," + PTest.format(total_msgs, 9, 0) + "," + "----------------------," + PTest.format(total_msgs, 9, 0) + ",";
            for (dest_idx = 0; dest_idx < s_destinations_numb; ++dest_idx) {
                try {
                    jndi = new InitialContext();
                    current_destname = PTestCase.makeDestname(dest_idx, haveQueue);
                    current_dest = s_haveQueue ? (Destination)jndi.lookup("jms.queue." + current_destname) : (Destination)jndi.lookup("jms.topic." + current_destname);
                    connFactory = s_haveQueue ? (ConnectionFactory)jndi.lookup("jms.QueueConnectionFactory") : (ConnectionFactory)jndi.lookup("jms.TopicConnectionFactory");
                }
                catch (NamingException jne) {
                    jne.printStackTrace(s_out);
                    PProducer.closeoutput();
                    System.exit(1);
                }
                for (cidx = 0; cidx < conn_numb; ++cidx) {
                    try {
                        conn_list[dest_idx][cidx] = s_haveQueue ? ((QueueConnectionFactory)connFactory).createQueueConnection("", "") : ((TopicConnectionFactory)connFactory).createTopicConnection("", "");
                    }
                    catch (JMSException jmse) {
                        jmse.printStackTrace(s_out);
                        PProducer.closeoutput();
                        System.exit(1);
                    }
                    startmillis = System.currentTimeMillis();
                    for (i = 0; i < sessions_numb; ++i) {
                        p_list[dest_idx][cidx][i] = new PProducer(current_dest, conn_list[dest_idx][cidx]);
                        p_list[dest_idx][cidx][i].start();
                    }
                }
            }
            for (dest_idx = 0; dest_idx < s_destinations_numb; ++dest_idx) {
                for (cidx = 0; cidx < conn_numb; ++cidx) {
                    for (i = 0; i < sessions_numb; ++i) {
                        if (p_list[dest_idx][cidx][i] == null) continue;
                        try {
                            p_list[dest_idx][cidx][i].join();
                            continue;
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace(s_out);
                            s_out.flush();
                        }
                    }
                }
            }
            for (dest_idx = 0; dest_idx < s_destinations_numb; ++dest_idx) {
                for (cidx = 0; cidx < conn_numb; ++cidx) {
                    for (i = 0; i < sessions_numb; ++i) {
                        if (p_list[dest_idx][cidx][i] == null) continue;
                        s_msg_count += p_list[dest_idx][cidx][i].getMsgCount();
                    }
                }
            }
            s_vout.println(new Date().toString() + " Over All Messages Sent:" + s_msg_count + "/" + total_msgs);
            s_vout.flush();
            endmillis = System.currentTimeMillis();
            for (dest_idx = 0; dest_idx < destinations_numb; ++dest_idx) {
                for (cidx = 0; cidx < conn_numb; ++cidx) {
                    try {
                        conn_list[dest_idx][cidx].close();
                        continue;
                    }
                    catch (JMSException jmse) {
                        jmse.printStackTrace(s_out);
                        PProducer.closeoutput();
                        System.exit(1);
                    }
                }
            }
            outstr = outstr + PTest.format(total_bytes, 9, 0) + "," + PTest.format(startmillis, 13, 0) + "," + PTest.format(endmillis, 13, 0) + "," + PTest.format(endmillis - startmillis, 8, 0) + "," + PTest.format(1000.0 * (double)total_msgs / (double)(endmillis - startmillis), 4, 4) + "," + PTest.format(1000.0 * (double)total_bytes / (double)(endmillis - startmillis), 9, 6) + ",,,,,,";
            s_out.println(outstr);
            s_vout.println(outstr);
            PProducer.closeoutput();
        }
        catch (Exception e) {
            e.printStackTrace(s_out);
            PProducer.closeoutput();
            System.exit(1);
        }
        System.exit(0);
    }

    private long getMsgCount() {
        return this.msg_count;
    }

    private static void closeoutput() {
        s_out.flush();
        s_out.close();
        s_vout.flush();
        s_vout.close();
    }
}

