/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.ptest;

import com.sap.sdb.msgServer.ptest.AdminMessageServer;
import com.sap.sdb.msgServer.ptest.PTest;
import com.sap.sdb.msgServer.ptest.PTestCase;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class PConsumer
implements MessageListener,
ExceptionListener {
    private static PrintStream s_out = System.out;
    private static PrintStream s_vout = System.out;
    private static String s_output_prefix = null;
    private static String s_outputfilename = null;
    private static int s_conn_numb = 0;
    private static int s_sessions_numb = 0;
    private static int s_msg_numb = 0;
    private static int s_subscriptions_numb = 0;
    private static int s_consumers_numb = 0;
    private static int s_destinations_numb = 0;
    private static int s_torecv = 0;
    private static int s_rcvd = 0;
    private static long s_lastmsgmillis = 0L;
    private static boolean s_stopme = false;
    private static boolean s_timedout = false;
    private static boolean s_abend = false;
    private static long s_timeout = 0L;
    private static long s_startmillis = 0L;
    private static long s_endmillis = 0L;
    private static long s_brcvd = 0L;
    private static boolean s_haveQueue = true;
    private static boolean s_haveAsync = true;
    private static boolean s_haveNondurable = true;
    private static boolean s_runMsgSel = false;
    private static String s_msgsel = null;
    private static String s_outstr1 = null;
    private static String s_outstr2 = null;
    private int m_rcvd = 0;
    private long m_lastmsgmillis = 0L;
    private long m_brcvd = 0L;
    private Session m_session = null;
    private MessageConsumer[][] m_consumers = null;
    private Destination m_dest = null;
    private Thread sync_receive_thread = null;

    public void start_sync_receive_thread() {
        this.sync_receive_thread.start();
    }

    public PConsumer(int didx, int cidx, int sidx, Destination dest, Connection conny) {
        try {
            this.m_dest = dest;
            this.m_session = s_haveQueue ? ((QueueConnection)conny).createQueueSession(false, 1) : ((TopicConnection)conny).createTopicSession(false, 1);
            this.m_consumers = new MessageConsumer[s_consumers_numb][s_subscriptions_numb];
            for (int i = 0; i < s_consumers_numb; ++i) {
                for (int j = 0; j < s_subscriptions_numb; ++j) {
                    String subscription = PTestCase.makeSubscriptionname(didx, s_haveQueue, cidx, sidx, i, j);
                    if (s_haveNondurable) {
                        this.m_consumers[i][j] = s_runMsgSel ? (s_haveQueue ? ((QueueSession)this.m_session).createReceiver((Queue)this.m_dest, s_msgsel) : ((TopicSession)this.m_session).createSubscriber((Topic)this.m_dest, s_msgsel, false)) : (s_haveQueue ? ((QueueSession)this.m_session).createReceiver((Queue)this.m_dest) : ((TopicSession)this.m_session).createSubscriber((Topic)this.m_dest));
                    } else if (s_runMsgSel) {
                        this.m_consumers[i][j] = s_haveQueue ? ((QueueSession)this.m_session).createReceiver((Queue)this.m_dest, s_msgsel) : ((TopicSession)this.m_session).createDurableSubscriber((Topic)this.m_dest, subscription, s_msgsel, false);
                    } else {
                        Object object = this.m_consumers[i][j] = s_haveQueue ? ((QueueSession)this.m_session).createReceiver((Queue)this.m_dest) : ((TopicSession)this.m_session).createDurableSubscriber((Topic)this.m_dest, subscription);
                    }
                    if (!s_haveAsync) continue;
                    this.m_consumers[i][j].setMessageListener((MessageListener)this);
                }
            }
            conny.setExceptionListener((ExceptionListener)this);
            if (!s_haveAsync) {
                this.sync_receive_thread = new Thread(){

                    public void run() {
                        block2: while (true) {
                            int i = 0;
                            while (true) {
                                if (i >= s_consumers_numb) continue block2;
                                for (int j = 0; j < s_subscriptions_numb; ++j) {
                                    try {
                                        TextMessage textMessage = (TextMessage)PConsumer.this.m_consumers[i][j].receive(s_timeout);
                                        if (textMessage == null) continue;
                                        String text = textMessage.getText();
                                        long msgbytes = text.length();
                                        s_brcvd += msgbytes;
                                        s_rcvd++;
                                        s_stopme = s_rcvd >= s_torecv;
                                        continue;
                                    }
                                    catch (Exception ex) {
                                        PConsumer.end(ex);
                                    }
                                }
                                ++i;
                            }
                            break;
                        }
                    }
                };
                this.sync_receive_thread.setDaemon(true);
            }
        }
        catch (Exception jmse) {
            PConsumer.end(jmse);
        }
    }

    public void onException(JMSException jmse) {
        s_vout.println("consumer exit (onException) : " + jmse.toString());
        PConsumer.end((Exception)jmse);
    }

    public void onMessage(Message message) {
        try {
            TextMessage textMessage = (TextMessage)message;
            String text = textMessage.getText();
            long msgbytes = text.length();
            this.m_brcvd += msgbytes;
            ++this.m_rcvd;
            this.m_lastmsgmillis = System.currentTimeMillis();
        }
        catch (Throwable rte) {
            rte.printStackTrace(s_vout);
            s_vout.flush();
        }
    }

    private int getRcvd() {
        return this.m_rcvd;
    }

    private long getBrcvd() {
        return this.m_brcvd;
    }

    private long getLastmsgmillis() {
        return this.m_lastmsgmillis;
    }

    public static void main(String[] argv) throws FileNotFoundException {
        s_output_prefix = argv[0];
        s_haveQueue = !argv[2].equalsIgnoreCase("topic");
        s_haveNondurable = !argv[3].equalsIgnoreCase("durable");
        s_outputfilename = argv[4];
        s_conn_numb = Integer.parseInt(argv[5]);
        s_sessions_numb = Integer.parseInt(argv[6]);
        s_consumers_numb = Integer.parseInt(argv[7]);
        s_msg_numb = Integer.parseInt(argv[8]);
        s_timeout = Long.parseLong(argv[9]);
        s_runMsgSel = !argv[10].equalsIgnoreCase("noselector");
        s_destinations_numb = Integer.parseInt(argv[12]);
        s_subscriptions_numb = Integer.parseInt(argv[13]);
        PConsumer.main_internal();
    }

    public static void main_internal() throws FileNotFoundException {
        ConnectionFactory ConnFactory = null;
        InitialContext jndi = null;
        String current_destname = null;
        Destination current_dest = null;
        int i = 0;
        int cidx = 0;
        PConsumer[][][] i_list = new PConsumer[s_destinations_numb][s_conn_numb][s_sessions_numb];
        Connection[][] conn_list = new Connection[s_destinations_numb][s_conn_numb];
        if (!s_outputfilename.equals("-")) {
            s_out = new PrintStream(new FileOutputStream(s_outputfilename, true));
            s_vout = new PrintStream(new FileOutputStream(s_outputfilename + ".v.txt", true));
        }
        try {
            int dest_idx;
            s_torecv = s_msg_numb * s_destinations_numb * s_conn_numb * s_sessions_numb * s_consumers_numb * s_subscriptions_numb * (s_haveQueue ? 1 : s_conn_numb * s_sessions_numb * s_consumers_numb * s_subscriptions_numb);
            s_outstr1 = s_output_prefix + "consumer," + PTest.format(s_conn_numb, 2, 0) + "," + PTest.format(s_sessions_numb, 2, 0) + "," + PTest.format(s_consumers_numb, 2, 0) + "," + PTest.format(s_torecv, 9, 0) + ",";
            s_vout.println();
            s_vout.println(s_outstr1);
            for (dest_idx = 0; dest_idx < s_destinations_numb; ++dest_idx) {
                try {
                    jndi = new InitialContext();
                    current_destname = PTestCase.makeDestname(dest_idx, s_haveQueue);
                    current_dest = s_haveQueue ? (Destination)jndi.lookup("jms.queue." + current_destname) : (Destination)jndi.lookup("jms.topic." + current_destname);
                    ConnFactory = s_haveQueue ? (ConnectionFactory)jndi.lookup("jms.QueueConnectionFactory") : (ConnectionFactory)jndi.lookup("jms.TopicConnectionFactory");
                }
                catch (NamingException jne) {
                    PConsumer.end(jne);
                }
                for (cidx = 0; cidx < s_conn_numb; ++cidx) {
                    try {
                        conn_list[dest_idx][cidx] = s_haveQueue ? ((QueueConnectionFactory)ConnFactory).createQueueConnection("", "") : ((TopicConnectionFactory)ConnFactory).createTopicConnection("", "");
                    }
                    catch (JMSException jmse) {
                        PConsumer.end((Exception)((Object)jmse));
                    }
                    for (i = 0; i < s_sessions_numb; ++i) {
                        i_list[dest_idx][cidx][i] = new PConsumer(dest_idx, cidx, i, current_dest, conn_list[dest_idx][cidx]);
                    }
                }
            }
            s_lastmsgmillis = System.currentTimeMillis();
            s_startmillis = System.currentTimeMillis();
            try {
                for (dest_idx = 0; dest_idx < s_destinations_numb; ++dest_idx) {
                    for (cidx = 0; cidx < s_conn_numb; ++cidx) {
                        conn_list[dest_idx][cidx].start();
                        if (s_haveAsync) continue;
                        for (i = 0; i < s_sessions_numb; ++i) {
                            i_list[dest_idx][cidx][i].start_sync_receive_thread();
                        }
                    }
                }
            }
            catch (JMSException jmse) {
                PConsumer.end((Exception)((Object)jmse));
            }
            if (s_msg_numb > 0) {
                try {
                    int pollcount = 0;
                    while (!s_stopme) {
                        Thread.sleep(500L);
                        long currtime = System.currentTimeMillis();
                        s_lastmsgmillis = 0L;
                        s_rcvd = 0;
                        s_brcvd = 0L;
                        for (int dest_idx2 = 0; dest_idx2 < s_destinations_numb; ++dest_idx2) {
                            for (cidx = 0; cidx < s_conn_numb; ++cidx) {
                                for (i = 0; i < s_sessions_numb; ++i) {
                                    long c_lastmsgmillis = i_list[dest_idx2][cidx][i].getLastmsgmillis();
                                    s_lastmsgmillis = s_lastmsgmillis < c_lastmsgmillis ? c_lastmsgmillis : s_lastmsgmillis;
                                    s_brcvd += i_list[dest_idx2][cidx][i].getBrcvd();
                                    s_rcvd += i_list[dest_idx2][cidx][i].getRcvd();
                                }
                            }
                        }
                        if (pollcount == 20) {
                            s_vout.println("messages received : " + s_rcvd + "/" + s_torecv);
                            pollcount = 0;
                        }
                        ++pollcount;
                        if (s_timeout != 0L) {
                            s_timedout = (s_timedout || currtime - s_lastmsgmillis > s_timeout) && s_rcvd != 0;
                            s_stopme = s_rcvd >= s_torecv || s_timedout;
                            continue;
                        }
                        s_stopme = s_rcvd >= s_torecv;
                    }
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace(s_vout);
                    s_vout.flush();
                }
            }
            s_endmillis = System.currentTimeMillis();
            for (int dest_idx3 = 0; dest_idx3 < s_destinations_numb; ++dest_idx3) {
                for (cidx = 0; cidx < s_conn_numb; ++cidx) {
                    try {
                        conn_list[dest_idx3][cidx].close();
                        continue;
                    }
                    catch (JMSException jmse) {
                        PConsumer.end((Exception)((Object)jmse));
                    }
                }
            }
        }
        catch (Exception e) {
            PConsumer.end(e);
        }
        PConsumer.end(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static synchronized void end(Exception e) {
        String outstr;
        block13: {
            s_vout.println("end: messages received : " + s_rcvd + "/" + s_torecv);
            outstr = null;
            boolean bl = s_abend = s_abend || e != null;
            s_outstr2 = s_abend ? "######## ERROR #######," : (s_timedout ? "####### TIMEDOUT #####," : "----------------------,");
            outstr = s_outstr1 + s_outstr2 + PTest.format(s_rcvd, 9, 0) + "," + PTest.format(s_brcvd, 9, 0) + "," + PTest.format(s_startmillis, 13, 0) + "," + PTest.format(s_endmillis, 13, 0) + "," + (s_abend ? "#" : PTest.format(s_endmillis - s_startmillis, 8, 0)) + "," + (s_abend ? "#" : PTest.format(1000.0 * (double)s_rcvd / (double)(s_endmillis - s_startmillis), 4, 4)) + "," + (s_abend ? "#" : PTest.format(1000.0 * (double)s_brcvd / (double)(s_endmillis - s_startmillis), 9, 6)) + ",,,,,,";
            if (s_timedout || s_abend) {
                AdminMessageServer con;
                block12: {
                    s_vout.flush();
                    con = null;
                    try {
                        con = new AdminMessageServer();
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                        s_vout.println("ConMessageServer:" + ex.toString());
                    }
                    con.connect("127.0.0.1", 7220, "SYNCOMAT", false);
                    if (!con.isConnected()) break block12;
                    String ret = con.send("status debug", false);
                    s_vout.println(ret);
                    s_vout.flush();
                }
                Object var5_6 = null;
                try {
                    con.disconnect();
                }
                catch (IOException e1) {
                    s_vout.println(e1.toString());
                    e1.printStackTrace();
                }
                break block13;
                {
                    catch (Exception ex) {
                        s_vout.println(ex.toString());
                        ex.printStackTrace();
                        Object var5_7 = null;
                        try {
                            con.disconnect();
                        }
                        catch (IOException e1) {
                            s_vout.println(e1.toString());
                            e1.printStackTrace();
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    try {
                        con.disconnect();
                    }
                    catch (IOException e1) {
                        s_vout.println(e1.toString());
                        e1.printStackTrace();
                    }
                    throw throwable;
                }
            }
        }
        s_out.println(outstr);
        s_out.flush();
        s_out.close();
        if (e != null) {
            e.printStackTrace(s_vout);
        }
        s_vout.println(outstr);
        s_vout.println();
        s_vout.println("###############################################################################");
        s_vout.println();
        s_vout.flush();
        s_vout.close();
        System.exit(s_abend ? 1 : 0);
    }
}

