/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVWRpretest;

import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WebDAVWRpretest {
    Vector myFileVector = new Vector();

    public static void main(String[] args) {
        WebDAVWRpretest myPretest = null;
        myPretest = new WebDAVWRpretest();
        myPretest.run();
    }

    public void run() {
        Vector myFiles = this.getAllFiles();
        Enumeration en = myFiles.elements();
        while (en.hasMoreElements()) {
            URL tempURL = (URL)en.nextElement();
            String file = tempURL.getFile();
            WDVUpload myUploadThread = null;
            myUploadThread = new WDVUpload(tempURL, file);
            Thread myThread = new Thread(myUploadThread);
            myThread.start();
        }
    }

    public Vector getAllFiles() {
        WDVTestJ_WebDAVCore myFileRessource = new WDVTestJ_WebDAVCore().createResource("pts", 1080, "/webdav", "/tests/WebDAVTests");
        Document xmlDocument = null;
        Vector<URL> myFilesVector = new Vector<URL>();
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?> \n<D:propfind xmlns:D=\"DAV:\"> \n<D:prop> \n<D:href/> \n</D:prop> \n</D:propfind> \n";
        try {
            xmlDocument = myFileRessource.PROPFIND(body);
        }
        catch (WDVTestJ_WdvException exc) {
            System.err.println("Trying to receive all file names from the WebDAV collection: PROPFIND\nAn error occured: " + exc.getMessage());
        }
        catch (SAXException saxex) {
            System.err.println("Trying to receive all file names from the WebDAV collection: PROPFIND\nAn error occured in the SAX parser: " + saxex.getMessage());
        }
        catch (IOException exc) {
            System.err.println(exc.getMessage());
            exc.printStackTrace();
        }
        NodeList myHREFnl = xmlDocument.getElementsByTagName("D:href");
        for (int i = 1; i < myHREFnl.getLength(); ++i) {
            String myFileStr = new String(myHREFnl.item(i).getFirstChild().getNodeValue());
            try {
                URL myFileURL = new URL("http", "pts", 1080, myFileStr);
                myFilesVector.add(myFileURL);
                continue;
            }
            catch (MalformedURLException mfuex) {
                System.err.println("Trying to receive all file names from the WebDAV collection\nAn error occured: " + mfuex.getMessage());
            }
        }
        return myFilesVector;
    }

    public class WDVUpload
    implements Runnable {
        WDVTestJ_WebDAVCore collection = new WDVTestJ_WebDAVCore().createResource(this.host, this.port, this.baseUrl, "");
        WDVTestJ_WebDAVCore resource = null;
        String host = "localhost";
        int port = 85;
        String baseUrl = "/webdav/WebDAVTests/";
        String fileName = "4711";
        URL myUploadFileURL = null;
        String myContentType = "4711";

        public WDVUpload(URL uploadFileURL, String myFileName) {
            this.fileName = myFileName;
            this.resource = new WDVTestJ_WebDAVCore().createResource(this.host, this.port, this.baseUrl, this.fileName);
            this.myUploadFileURL = uploadFileURL;
        }

        public void run() {
            boolean col_exists = false;
            try {
                col_exists = this.collection.exists();
            }
            catch (NullPointerException e) {
                System.err.println(e);
            }
            if (col_exists) {
                try {
                    this.resource.PUT(this.myUploadFileURL, "application/octet-stream", null);
                }
                catch (WDVTestJ_WdvException exc) {
                    System.err.println("UPLOAD the file '" + this.host + ":" + this.port + this.baseUrl + this.fileName + "' from '" + this.myUploadFileURL.toString() + "'\n" + "An error occured: " + exc.getMessage());
                }
                catch (IOException exc) {
                    System.err.println("An error occured: " + exc.getLocalizedMessage());
                    exc.printStackTrace();
                }
            } else {
                try {
                    this.collection.MKCOL(null);
                }
                catch (WDVTestJ_WdvException exc) {
                    System.err.println("CREATE the collection '" + this.host + this.port + this.baseUrl + "'\nAn error occured: " + exc);
                }
                catch (IOException exc) {
                    System.err.println(exc.getMessage());
                    exc.printStackTrace();
                }
                try {
                    this.resource.PUT(this.myUploadFileURL, "application/octet-stream", null);
                }
                catch (WDVTestJ_WdvException exc) {
                    System.err.println("UPLOAD the file '" + this.host + this.port + this.baseUrl + this.fileName + "' from '" + this.myUploadFileURL.toString() + "'" + "An error occured: " + exc);
                }
                catch (IOException exc) {
                    System.err.println("An error occured: " + exc.getLocalizedMessage());
                    exc.printStackTrace();
                }
            }
        }
    }
}

