/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.kmtest;

import com.sap.hcm.ls.shared.repository.access.Repository;
import com.sap.hcm.ls.shared.repository.access.wdslide.WDRepFactory;
import com.sap.hcm.ls.shared.repository.tools.FunctionTest;
import com.sap.hcm.ls.shared.repository.tools.OutputChannel;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.Hashtable;

public class KMWebDavTest
extends TestCase {
    private File redirectFile = new File("KMTestOut.txt");

    public static void prepare() throws TestCaseException {
    }

    public void run() {
        String methodName = "Method run";
        String machineName = KMWebDavTest.getParameterString((String)"machineName", (String)"");
        String port = KMWebDavTest.getParameterString((String)"port", (String)"");
        if (port.length() == 0 && (port = System.getProperty("env.TOMCAT_PORT")) != null && !port.equals("")) {
            try {
                int port_int = Integer.parseInt(port);
                this.addMessage("Method run", 'I', "Valid TOMCAT_PORT found. Overwrite parameter file provided port with " + port_int);
            }
            catch (NumberFormatException e) {
                this.addMessage("Method run", 'E', "No valid TOMCAT_PORT found. Use the parameter file provided port " + port);
            }
        }
        String webDavName = KMWebDavTest.getParameterString((String)"webDavName", (String)"");
        String webDavURL = "http://" + machineName + ":" + port + "/" + webDavName + "/";
        this.addMessage("Method run", 'I', "WebDavURL: " + webDavURL);
        int logLevel = KMWebDavTest.getParameterInt((String)"logLevel", (int)1);
        if (KMWebDavTest.getParameterString((String)"redirect", (String)"no").equals("yes")) {
            try {
                PrintStream ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.redirectFile)), true);
                System.setOut(ps);
                System.setErr(ps);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        Hashtable<String, String> htab = new Hashtable<String, String>();
        htab.put("com.sap.hcm.ls.shared.repository.access.RepEnvironment.ServerURL", webDavURL);
        WDRepFactory rfac = new WDRepFactory();
        Repository rep = rfac.createRepository(htab);
        FunctionTest test = new FunctionTest(rep, new OutputChannel(){

            public void print(String s) {
                if (s.startsWith("###:(") || s.indexOf("Test aborted due to error") != -1) {
                    KMWebDavTest.this.addMessage("Method run", 'E', s);
                } else {
                    KMWebDavTest.this.addMessage("Method run", 'I', s);
                }
                System.out.print(s);
                System.out.flush();
            }
        }, logLevel);
        try {
            test.run();
        }
        catch (Exception e) {
            this.addMessage("Method run", 'E', e.getMessage());
        }
    }

    public String getLogFile() {
        return this.redirectFile.getAbsolutePath();
    }
}

