/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.puttests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;

public class TestPut014
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestPut014.createWebDAVSchema();
        TestPut014.addGlobalMessage((String)("prepare test " + TestPut014.getTestClassId()), (char)'I', (String)"try to put a file using a content type that contains restricted characters\nThe server must reply with '400 Bad Request'");
        host = new String(TestPut014.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestPut014.getPort();
        baseUrl = TestPut014.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestPut014.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestPut014.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestPut014.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestPut014.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestPut014.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestPut014.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on WDV_PORT " + WDV_PORT);
        }
        urlStr = new String("/TestPut014.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPut014.addGlobalMessage((String)"1. DELETE the resource /TestPut014.txt at baseUrl", (char)'E', (String)"Preparation failed due to some Java feature.");
        }
        TestPut014.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public void run() {
        Vector<String> restrictedSigns = new Vector<String>();
        restrictedSigns.add(new Character('(').toString());
        restrictedSigns.add(new Character(')').toString());
        restrictedSigns.add(new Character(',').toString());
        restrictedSigns.add(new Character('/').toString());
        restrictedSigns.add(new Character(':').toString());
        restrictedSigns.add(new Character(';').toString());
        restrictedSigns.add(new Character('=').toString());
        restrictedSigns.add(new Character('@').toString());
        restrictedSigns.add(new Character('[').toString());
        restrictedSigns.add(new Character('\\').toString());
        restrictedSigns.add(new Character(']').toString());
        restrictedSigns.add(new Character('{').toString());
        restrictedSigns.add(new Character('}').toString());
        Vector<String> typeVector = new Vector<String>(10, 5);
        Vector<String> subtypeVector = new Vector<String>(10, 5);
        Enumeration e = restrictedSigns.elements();
        while (e.hasMoreElements()) {
            String sign = (String)e.nextElement();
            typeVector.add(sign + "text/");
            typeVector.add("te" + sign + "xt/");
            typeVector.add("text" + sign + "/");
            subtypeVector.add(sign + "plain");
            subtypeVector.add("pl" + sign + "ain");
            subtypeVector.add("plain" + sign + "");
        }
        typeVector.add("text/");
        typeVector.add("text /");
        subtypeVector.add(" plain");
        Enumeration enum1 = typeVector.elements();
        while (enum1.hasMoreElements()) {
            String typeString = (String)enum1.nextElement();
            Enumeration enum2 = subtypeVector.elements();
            while (enum2.hasMoreElements()) {
                String subtypeString = (String)enum2.nextElement();
                content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
                contentType = typeString + subtypeString;
                contentLength = content.length();
                try {
                    TestPut014.addGlobalMessage((String)"2. create the resource /TestPut014.txt several times at baseUrl with wrong content-types", (char)'I', (String)"starting...");
                    resource.PUT(content, contentType, locktoken);
                    if (resource.getStatus().getStatusCode() != 400) {
                        TestPut014.addGlobalMessage((String)("the server accepted the following content-type: " + contentType), (char)'E', (String)"Test was not successful and will be aborted.");
                        return;
                    }
                }
                catch (WDVTestJ_WdvException exc) {
                    if (exc.getStatusCode() == 400) {
                        try {
                            if (resource.exists()) {
                                TestPut014.addGlobalMessage((String)"2.1. check if the file was not created", (char)'E', (String)"The file was created instead. Test Failed!");
                            }
                        }
                        catch (NullPointerException e2) {
                            this.handleExceptions(e2);
                        }
                    } else {
                        TestPut014.addGlobalMessage((String)"2. create the resource /TestPut014.txt at baseUrl", (char)'E', (String)("The Server accepted the wrong content-type within the PUT-request.The test failed. server replied '" + exc.getStatusCode() + " " + exc.getMessage()));
                    }
                    return;
                }
                catch (Exception e3) {
                    this.handleExceptions(e3);
                }
                TestPut014.addGlobalMessage((String)"2. create the resource /TestPut014.txt several times at baseUrl with wrong content-types", (char)'I', (String)"the server declined all requests...test was successful!");
                try {
                    if (!resource.exists()) continue;
                    try {
                        resource.DELETE(locktoken);
                    }
                    catch (WDVTestJ_WdvException exc) {
                        TestPut014.addGlobalMessage((String)("2.2. DELETE of " + host + ":" + WDV_PORT + baseUrl + urlStr + " failed"), (char)'E', (String)"Test cannot be finished!");
                        return;
                    }
                }
                catch (NullPointerException e4) {
                    this.handleExceptions(e4);
                }
                catch (IOException exc) {
                    this.handleExceptions(exc);
                }
            }
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestPut014.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPut014.addGlobalMessage((String)"3. clean up and DELETE the resource /TestPut014.txt at baseUrl", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        TestPut014.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

