/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.puttests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestPut008
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestPut008.createWebDAVSchema();
        TestPut008.addGlobalMessage((String)("prepare test " + TestPut008.getTestClassId()), (char)'I', (String)"put on a not existing resource with a wrong MIME type format for 'content type'");
        host = new String(TestPut008.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestPut008.getPort();
        baseUrl = TestPut008.getParameterString((String)"baseUrl", (String)"webdav");
        start_server = TestPut008.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestPut008.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestPut008.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestPut008.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestPut008.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on WDV_PORT " + WDV_PORT);
        }
        urlStr = "/TestPut008.txt";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPut008.addGlobalMessage((String)"1. DELETE the resource /TestPut008.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestPut008.doDelete(resource, locktoken, host + ":" + WDV_PORT + "/" + baseUrl + urlStr);
    }

    public void run() {
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "Herr Meier";
        contentLength = content.length();
        try {
            resource.PUT(content, contentType, locktoken);
            if (resource.getStatus().getStatusCode() != 400) {
                TestPut008.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + "/" + baseUrl + urlStr), (char)'E', (String)("server returned: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
                TestPut008.addGlobalMessage((String)"PUT failed due to some WebDAV feature", (char)'I', (String)"Expected result: 400 Bad Request");
                return;
            }
        }
        catch (WDVTestJ_WdvException exc) {
            if (resource.getStatus().getStatusCode() != 400) {
                TestPut008.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + "/" + baseUrl + urlStr), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
                TestPut008.addGlobalMessage((String)"PUT failed due to some WebDAV feature", (char)'I', (String)"Expected result: 400 Bad Request");
                return;
            }
            TestPut008.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + "/" + baseUrl + urlStr), (char)'I', (String)"Test was successful");
        }
        catch (Exception exc) {
            TestPut008.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + "/" + baseUrl + urlStr), (char)'E', (String)("  Java exception: " + exc));
            TestPut008.addGlobalMessage((String)"PUT failed due to some Java feature", (char)'I', (String)("Skipping test " + TestPut008.getTestClassId()));
            return;
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = "/TestPut008.txt";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPut008.addGlobalMessage((String)"4. starting cleaning up - DELETE TestPut008.txt", (char)'E', (String)"Cleaning Up failed due to some Java feature.");
        }
        TestPut008.doDelete(resource, locktoken, host + ":" + WDV_PORT + "/" + baseUrl + urlStr);
    }
}

