/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.puttests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestPut004
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestPut004.createWebDAVSchema();
        TestPut004.addGlobalMessage((String)("prepare test " + TestPut004.getTestClassId()), (char)'I', (String)"put on a not existing resource  with content of length 0");
        host = new String(TestPut004.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestPut004.getPort();
        baseUrl = TestPut004.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestPut004.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestPut004.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestPut004.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestPut004.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestPut004.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestPut004.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on WDV_PORT " + WDV_PORT);
        }
        urlStr = "/TestPut004.txt";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPut004.addGlobalMessage((String)"1. DELETE the resource /TestPut004.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestPut004.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public void run() {
        content = "";
        contentType = "text/plain";
        contentLength = 0L;
        if (!TestPut004.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            return;
        }
        TestPut004.compareContent(resource, content, contentType, contentLength, host + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public static void cleanUp() throws TestCaseException {
        TestPut004.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

