/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.proppatchtests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public class TestProppatch013
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static Document xmlDocument = null;
    static Node newcontenttype_node = null;

    public static void prepare() throws TestCaseException {
        TestProppatch013.createWebDAVSchema();
        TestProppatch013.addGlobalMessage((String)("prepare test " + TestProppatch013.getTestClassId()), (char)'I', (String)"create a new dead property on a resource and check if the received value equals the posted value");
        host = new String(TestProppatch013.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestProppatch013.getPort();
        baseUrl = TestProppatch013.getParameterString((String)"baseUrl", (String)"/webdav");
        start_server = TestProppatch013.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestProppatch013.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestProppatch013.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestProppatch013.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestProppatch013.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestProppatch013.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestProppatch013.addGlobalMessage((String)"1. DELETE the resource /TestProppatch013.txt at baseUrl", (char)'E', (String)"Preparation failed due to some Java feature.");
        }
        TestProppatch013.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        if (!TestProppatch013.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
        body = body + "\n<D:propertyupdate xmlns:D=\"DAV:\"";
        body = body + "\nxmlns:Z=\"http://www.some.place.com\">";
        body = body + "\n<D:set>";
        body = body + "\n <D:prop>";
        body = body + "\n  <Z:newcontenttype>text/plain</Z:newcontenttype>";
        body = body + "\n </D:prop>";
        body = body + "\n</D:set>";
        body = body + "\n</D:propertyupdate>";
        try {
            xmlDocument = resource.PROPPATCH(body, null);
        }
        catch (WDVTestJ_WdvException exc) {
            TestProppatch013.addGlobalMessage((String)"PROPPATCH 'newcontenttype'", (char)'E', (String)("status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
            TestProppatch013.addGlobalMessage((String)"PROPPATCH 'newcontenttype'", (char)'I', (String)"test failed due to some WebDAV feature");
        }
        catch (SAXParseException exc) {
            TestProppatch013.addGlobalMessage((String)"PROPPATCH 'newcontenttype'", (char)'E', (String)("parser says: " + exc.getMessage()));
            TestProppatch013.addGlobalMessage((String)"PROPPATCH 'newcontenttype'", (char)'I', (String)("request body: " + body));
        }
        catch (Exception exc) {
            TestProppatch013.addGlobalMessage((String)"PROPPATCH 'newcontenttype'", (char)'E', (String)("Java exception: " + exc));
            exc.printStackTrace();
            TestProppatch013.addGlobalMessage((String)"PROPPATCH 'newcontenttype'", (char)'I', (String)"Test failed due to some Java feature");
        }
        if (resource.getStatus().getStatusCode() == 207) {
            try {
                NodeList nl = xmlDocument.getElementsByTagName("newcontenttype");
                newcontenttype_node = nl.item(0);
            }
            catch (NullPointerException exc) {
                TestProppatch013.addGlobalMessage((String)"5. check if the property status of 'newcontenttype' is \"HTTP/1.1 200 OK\"", (char)'E', (String)"the 'newcontenttype'-element for the resource could not be retrieved");
            }
            if (xmlDocument.getElementsByTagName("D:status").item(0).getFirstChild().getNodeValue().equalsIgnoreCase("HTTP/1.1 200 OK")) {
                TestProppatch013.addGlobalMessage((String)"5. check if the property status of 'newcontenttype' is \"HTTP/1.1 200 OK\"", (char)'I', (String)"successful");
                String newcontentTypeR = TestProppatch013.doPropfindByTagName(resource, "http://www.some.place.com", "newcontenttype", host + ":" + WDV_PORT + baseUrl + urlStr);
                if (newcontentTypeR.equalsIgnoreCase("text/plain")) {
                    TestProppatch013.addGlobalMessage((String)"6. check if 'newcontenttype' was set correctly", (char)'I', (String)"test was successfull");
                } else {
                    TestProppatch013.addGlobalMessage((String)"6. check if 'newcontenttype' was set correctly", (char)'E', (String)"test was not successfull");
                    TestProppatch013.addGlobalMessage((String)"6. check if 'newcontenttype' was set correctly", (char)'I', (String)("posted: \"text/plain\", received: " + newcontentTypeR));
                }
            } else {
                TestProppatch013.addGlobalMessage((String)"5. check if the property status of 'newcontenttype' is \"HTTP/1.1 200 OK\"", (char)'E', (String)"test failed due to some WebDAV features");
            }
        } else {
            TestProppatch013.addGlobalMessage((String)"PROPPATCH 'newcontenttype'", (char)'E', (String)("status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
            TestProppatch013.addGlobalMessage((String)"PROPPATCH 'newcontenttype'", (char)'I', (String)"expected result: 207 Multi-Status");
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestProppatch013.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestProppatch013.addGlobalMessage((String)"7. clean up and DELETE the resource /TestProppatch013.txt at baseUrl", (char)'E', (String)"clean up failed due to some Java feature.");
        }
        TestProppatch013.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

