/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.proppatchtests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public class TestProppatch009
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static Document xmlDocument = null;
    static Node getcontenttype_node = null;

    public static void prepare() throws TestCaseException {
        TestProppatch009.createWebDAVSchema();
        TestProppatch009.addGlobalMessage((String)("prepare test " + TestProppatch009.getTestClassId()), (char)'I', (String)"patch the live property 'getcontenttype'");
        host = new String(TestProppatch009.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestProppatch009.getPort();
        baseUrl = TestProppatch009.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestProppatch009.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestProppatch009.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestProppatch009.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestProppatch009.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestProppatch009.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestProppatch009.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestProppatch009.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestProppatch009.addGlobalMessage((String)"1. DELETE the resource /TestProppatch009.txt at baseUrl", (char)'E', (String)"Preparation failed due to some Java feature.");
        }
        TestProppatch009.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        if (!TestProppatch009.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
        body = body + "\n<D:propertyupdate xmlns:D=\"DAV:\"";
        body = body + "\nxmlns:Z=\"DAV:\">";
        body = body + "\n<D:set>";
        body = body + "\n<D:prop>";
        body = body + "\n<Z:getcontenttype>text/html</Z:getcontenttype>";
        body = body + "\n</D:prop>";
        body = body + "\n</D:set>";
        body = body + "\n</D:propertyupdate>";
        try {
            xmlDocument = resource.PROPPATCH(body, null);
        }
        catch (WDVTestJ_WdvException exc) {
            TestProppatch009.addGlobalMessage((String)"PROPPATCH (set) the write-enabled live prop 'getcontenttype'", (char)'E', (String)("status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
            TestProppatch009.addGlobalMessage((String)"PROPPATCH (set) the write-enabled live prop 'getcontenttype'", (char)'I', (String)"test failed due to some WebDAV feature");
        }
        catch (SAXParseException exc) {
            TestProppatch009.addGlobalMessage((String)"PROPPATCH (set) the write-enabled live prop 'getcontenttype'", (char)'E', (String)("parser says: " + exc.getMessage()));
            TestProppatch009.addGlobalMessage((String)"PROPPATCH (set) the write-enabled live prop 'getcontenttype'", (char)'I', (String)("request body: " + body));
        }
        catch (Exception exc) {
            TestProppatch009.addGlobalMessage((String)"PROPPATCH (set) the write-enabled live prop 'getcontenttype'", (char)'E', (String)("Java exception: " + exc));
            exc.printStackTrace();
            TestProppatch009.addGlobalMessage((String)"PROPPATCH (set) the write-enabled live prop 'getcontenttype'", (char)'I', (String)"Test failed due to some Java feature");
        }
        if (resource.getStatus().getStatusCode() == 207) {
            try {
                NodeList nl = xmlDocument.getElementsByTagName("s1:getcontenttype");
                if (nl.getLength() == 0) {
                    nl = xmlDocument.getElementsByTagName("N:getcontenttype");
                }
                if (nl.getLength() < 1) {
                    TestProppatch009.addGlobalMessage((String)"5. check if the property status of 'getcontenttype' is \"HTTP/1.1 200 OK\"", (char)'E', (String)"There is NO 'getcontenttype'-node!");
                    return;
                }
                if (nl.getLength() > 1) {
                    TestProppatch009.addGlobalMessage((String)"5. check if the property status of 'getcontenttype' is \"HTTP/1.1 200 OK\"", (char)'E', (String)"There are more than one 'getcontenttype'-nodes!");
                    return;
                }
                getcontenttype_node = nl.item(0);
            }
            catch (NullPointerException exc) {
                TestProppatch009.addGlobalMessage((String)"5. check if the property status of 'getcontenttype' is \"HTTP/1.1 200 OK\"", (char)'E', (String)"the 'getcontenttype'-element for the resource could not be retrieved");
            }
            String status = null;
            if (TestProppatch009.getParameterString((String)"use_servlet", (String)"F").equalsIgnoreCase("T")) {
                if (getcontenttype_node == null || getcontenttype_node.getParentNode() == null || getcontenttype_node.getParentNode().getNextSibling() == null || getcontenttype_node.getParentNode().getNextSibling().getNextSibling() == null || getcontenttype_node.getParentNode().getNextSibling().getNextSibling().getFirstChild() == null || getcontenttype_node.getParentNode().getNextSibling().getNextSibling().getFirstChild().getNodeValue() == null) {
                    TestProppatch009.addGlobalMessage((String)"4. check if the property status of 'displayname' is \"HTTP/1.1 200 OK\"", (char)'E', (String)"test failed. Could not find the status tag.");
                    return;
                }
            } else if (getcontenttype_node == null || getcontenttype_node.getParentNode() == null || getcontenttype_node.getParentNode().getNextSibling() == null || getcontenttype_node.getParentNode().getNextSibling().getFirstChild() == null || getcontenttype_node.getParentNode().getNextSibling().getFirstChild().getNodeValue() == null) {
                TestProppatch009.addGlobalMessage((String)"4. check if the property status of 'displayname' is \"HTTP/1.1 200 OK\"", (char)'E', (String)"test failed. Could not find the status tag.");
                return;
            }
            if (TestProppatch009.getParameterString((String)"use_servlet", (String)"F").equalsIgnoreCase("F")) {
                status = getcontenttype_node.getParentNode().getNextSibling().getFirstChild().getNodeValue();
                if (status.equalsIgnoreCase("HTTP/1.1 200 OK")) {
                    TestProppatch009.addGlobalMessage((String)"5. check if the property status of 'getcontenttype' is \"HTTP/1.1 200 OK\"", (char)'I', (String)"test succeeded!");
                } else {
                    TestProppatch009.addGlobalMessage((String)"5. check if the property status of 'getcontenttype' is \"HTTP/1.1 200 OK\"", (char)'E', (String)("Status is: " + status + ". Test failed due to some WebDAV feature."));
                }
            } else {
                status = getcontenttype_node.getParentNode().getNextSibling().getNextSibling().getFirstChild().getNodeValue();
                if (status.startsWith("HTTP/1.1 409")) {
                    TestProppatch009.addGlobalMessage((String)"5. check if the property status of 'getcontenttype' is \"HTTP/1.1 409\"", (char)'I', (String)"test succeeded!");
                } else {
                    TestProppatch009.addGlobalMessage((String)"5. check if the property status of 'getcontenttype' is \"HTTP/1.1 409\"", (char)'E', (String)("Status is: " + status + ". Test failed due to some WebDAV feature."));
                }
            }
        } else {
            TestProppatch009.addGlobalMessage((String)"PROPPATCH (set) the write-enabled live prop 'getcontenttype'", (char)'E', (String)("status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
            TestProppatch009.addGlobalMessage((String)"PROPPATCH (set) the write-enabled live prop 'getcontenttype'", (char)'I', (String)"expected result: 207 Multi-Status");
        }
        String contentTypeR = TestProppatch009.doPropfindByTagName(resource, "getcontenttype", host + ":" + WDV_PORT + baseUrl + urlStr);
        if (contentType.equalsIgnoreCase(contentTypeR)) {
            TestProppatch009.addGlobalMessage((String)"6. check if the content type was overwritten correctly", (char)'I', (String)"test was successfull");
        } else {
            TestProppatch009.addGlobalMessage((String)"6. check if the content type was overwritten correctly", (char)'E', (String)"test was not successfull");
            TestProppatch009.addGlobalMessage((String)"6. check if the content type was overwritten correctly", (char)'I', (String)("posted: " + contentType + ", received: " + contentTypeR));
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestProppatch009.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestProppatch009.addGlobalMessage((String)"7. clean up and DELETE the resource /TestProppatch009.txt at baseUrl", (char)'E', (String)"clean up failed due to some Java feature.");
        }
        TestProppatch009.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

