/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.proppatchtests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public class TestProppatch007
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static Document xmlDocument = null;
    static Node displayname_node = null;

    public static void prepare() throws TestCaseException {
        TestProppatch007.createWebDAVSchema();
        TestProppatch007.addGlobalMessage((String)("prepare test " + TestProppatch007.getTestClassId()), (char)'I', (String)"patch the live property 'displayname', the property must be changed correctly (no multi-value)");
        host = new String(TestProppatch007.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestProppatch007.getPort();
        baseUrl = TestProppatch007.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestProppatch007.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestProppatch007.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestProppatch007.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestProppatch007.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestProppatch007.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestProppatch007.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestProppatch007.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestProppatch007.addGlobalMessage((String)"1. DELETE the resource /TestProppatch007.txt at baseUrl", (char)'E', (String)"Preparation failed due to some Java feature.");
        }
        TestProppatch007.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        if (!TestProppatch007.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
        body = body + "\n<D:propertyupdate xmlns:D=\"DAV:\"";
        body = body + "\nxmlns:Z=\"DAV:\">";
        body = body + "\n<D:set>";
        body = body + "\n<D:prop>";
        body = body + "\n<Z:displayname>today</Z:displayname>";
        body = body + "\n</D:prop>";
        body = body + "\n</D:set>";
        body = body + "\n</D:propertyupdate>";
        try {
            xmlDocument = resource.PROPPATCH(body, null);
        }
        catch (WDVTestJ_WdvException exc) {
            TestProppatch007.addGlobalMessage((String)"PROPPATCH (set) the read-only live prop 'displayname'", (char)'E', (String)("status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
            TestProppatch007.addGlobalMessage((String)"PROPPATCH (set) the read-only live prop 'displayname'", (char)'I', (String)"test failed due to some WebDAV feature");
        }
        catch (SAXParseException exc) {
            TestProppatch007.addGlobalMessage((String)"PROPPATCH (set) the read-only live prop 'displayname'", (char)'E', (String)("parser says: " + exc.getMessage()));
            TestProppatch007.addGlobalMessage((String)"PROPPATCH (set) the read-only live prop 'displayname'", (char)'I', (String)("request body: " + body));
        }
        catch (Exception exc) {
            TestProppatch007.addGlobalMessage((String)"PROPPATCH (set) the read-only live prop 'displayname'", (char)'E', (String)("Java exception: " + exc));
            exc.printStackTrace();
            TestProppatch007.addGlobalMessage((String)"PROPPATCH (set) the read-only live prop 'displayname'", (char)'I', (String)"Test failed due to some Java feature");
        }
        if (resource.getStatus().getStatusCode() == 207) {
            try {
                NodeList nl = xmlDocument.getElementsByTagName("s1:displayname");
                if (nl.getLength() == 0) {
                    nl = xmlDocument.getElementsByTagName("N:displayname");
                }
                if (nl.getLength() > 1) {
                    TestProppatch007.addGlobalMessage((String)"4. check if the property status of 'displayname' is \"HTTP/1.1 200 OK\"", (char)'E', (String)"There are more than one 'displayname'-nodes!");
                    return;
                }
                if (nl.getLength() < 1) {
                    TestProppatch007.addGlobalMessage((String)"4. check if the property status of 'displayname' is \"HTTP/1.1 200 OK\"", (char)'E', (String)"There NO 'displayname'-node!");
                    return;
                }
                displayname_node = nl.item(0);
            }
            catch (NullPointerException exc) {
                TestProppatch007.addGlobalMessage((String)"4. check if the property status of 'displayname' is \"HTTP/1.1 200 OK\"", (char)'E', (String)"the 'displayname'-element for the resource could not be retrieved");
            }
            String status = null;
            if (TestProppatch007.getParameterString((String)"use_servlet", (String)"F").equalsIgnoreCase("T")) {
                if (displayname_node == null || displayname_node.getParentNode() == null || displayname_node.getParentNode().getNextSibling() == null || displayname_node.getParentNode().getNextSibling().getNextSibling() == null || displayname_node.getParentNode().getNextSibling().getNextSibling().getFirstChild() == null || displayname_node.getParentNode().getNextSibling().getNextSibling().getFirstChild().getNodeValue() == null) {
                    TestProppatch007.addGlobalMessage((String)"4. check if the property status of 'displayname' is \"HTTP/1.1 200 OK\"", (char)'E', (String)"test failed. Could not find the status tag.");
                    return;
                }
            } else if (displayname_node == null || displayname_node.getParentNode() == null || displayname_node.getParentNode().getNextSibling() == null || displayname_node.getParentNode().getNextSibling().getFirstChild() == null || displayname_node.getParentNode().getNextSibling().getFirstChild().getNodeValue() == null) {
                TestProppatch007.addGlobalMessage((String)"4. check if the property status of 'displayname' is \"HTTP/1.1 200 OK\"", (char)'E', (String)"test failed. Could not find the status tag.");
                return;
            }
            if (TestProppatch007.getParameterString((String)"use_servlet", (String)"F").equalsIgnoreCase("F")) {
                status = displayname_node.getParentNode().getNextSibling().getFirstChild().getNodeValue().toString();
                if (status.equals("HTTP/1.1 200 OK")) {
                    TestProppatch007.addGlobalMessage((String)"4. check if the property status of 'displayname' is \"HTTP/1.1 200 OK\"", (char)'I', (String)"test succeeded!");
                } else {
                    TestProppatch007.addGlobalMessage((String)"4. check if the property status of 'displayname' is \"HTTP/1.1 200 OK\"", (char)'E', (String)("test failed due to some WebDAV features. \n Status is: " + status));
                }
            } else {
                status = displayname_node.getParentNode().getNextSibling().getNextSibling().getFirstChild().getNodeValue().toString();
                if (status.startsWith("HTTP/1.1 409")) {
                    TestProppatch007.addGlobalMessage((String)"4. check if the property status of 'displayname' is \"HTTP/1.1 409\"", (char)'I', (String)"test succeeded!");
                } else {
                    TestProppatch007.addGlobalMessage((String)"4. check if the property status of 'displayname' is \"HTTP/1.1 409 OK\"", (char)'E', (String)("test failed due to some WebDAV features. \n Status is: " + status));
                }
            }
        } else {
            TestProppatch007.addGlobalMessage((String)"PROPPATCH (set) the read-only live prop 'displayname'", (char)'E', (String)("status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
            TestProppatch007.addGlobalMessage((String)"PROPPATCH (set) the read-only live prop 'displayname'", (char)'I', (String)"expected result: 207 Multi-Status");
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestProppatch007.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestProppatch007.addGlobalMessage((String)"5. clean up and DELETE the resource /TestProppatch007.txt at baseUrl", (char)'E', (String)"Preparation failed due to some Java feature.");
        }
        TestProppatch007.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

