/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.movetests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;

public class TestMove010
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static String dest_Url = null;

    public static void prepare() throws TestCaseException {
        TestMove010.createWebDAVSchema();
        TestMove010.addGlobalMessage((String)("prepare test " + TestMove010.getTestClassId()), (char)'I', (String)"********************************************\n* Move a resource on a existing collection *\n********************************************");
        host = new String(TestMove010.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestMove010.getPort();
        baseUrl = TestMove010.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestMove010.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestMove010.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestMove010.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestMove010.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestMove010.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestMove010.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestMove010");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove010.addGlobalMessage((String)"1. DELETE /TestMove010 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestMove010.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/TestMove010.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove010.addGlobalMessage((String)"1. DELETE /TestMove010.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestMove010.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/TestMove010");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove010.addGlobalMessage((String)"2. create the folder /TestMove010 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestMove010.doMkCol(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestMove010.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove010.addGlobalMessage((String)"2. create resource /TestMove010.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        TestMove010.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public void run() {
        urlStr = new String("/TestMove010");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove010.addGlobalMessage((String)"3. MOVE /TestMove010 on /TestMove010.txt", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        dest_Url = null;
        String body = null;
        locktoken = null;
        try {
            dest_Url = new URL("http", host, WDV_PORT, baseUrl + "/TestMove010.txt").toString();
        }
        catch (MalformedURLException exc) {
            TestMove010.addGlobalMessage((String)"3. MOVE /TestMove010 on /TestMove010.txt", (char)'E', (String)"Test failed due to some Java-URL feature");
        }
        try {
            resource.MOVE(dest_Url, "T", body, locktoken);
            if (resource.getStatus().getStatusCode() == 204) {
                TestMove010.addGlobalMessage((String)"3. MOVE /TestMove010 on /TestMove010.txt", (char)'I', (String)"Test was successful!");
            } else {
                TestMove010.addGlobalMessage((String)"3. MOVE /TestMove010 on /TestMove010.txt", (char)'E', (String)("unexpected status code: " + resource.getStatus().getStatusCode()));
                TestMove010.addGlobalMessage((String)"3. MOVE /TestMove010 on /TestMove010.txt", (char)'I', (String)"expected: 204 No Content");
            }
        }
        catch (WDVTestJ_WdvException exc) {
            TestMove010.addGlobalMessage((String)("MOVE TO http://" + dest_Url), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
            TestMove010.addGlobalMessage((String)"MOVE failed due to some WebDAV feature", (char)'I', (String)"Expected result: 204 No Content");
        }
        catch (Exception exc) {
            TestMove010.addGlobalMessage((String)("MOVE TO http://" + dest_Url), (char)'E', (String)("Java exception: " + exc));
            exc.printStackTrace();
            TestMove010.addGlobalMessage((String)"MOVE failed due to some Java feature", (char)'I', (String)("Skipping test " + TestMove010.getTestClassId()));
        }
        urlStr = new String("/TestMove010");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove010.addGlobalMessage((String)"4. check, whether the source was deleted correctly", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        try {
            resource.HEAD(null);
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() == 404) {
                TestMove010.addGlobalMessage((String)"4. check, whether the source was deleted correctly", (char)'I', (String)"Test was successful!!");
            } else {
                TestMove010.addGlobalMessage((String)"4. check, whether the source was deleted correctly", (char)'E', (String)("WebDAV said: " + exc.getStatusCode() + " " + exc.getMessage()));
            }
        }
        catch (Exception exc) {
            this.handleExceptions(exc);
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestMove010");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove010.addGlobalMessage((String)"5. clean up and DELETE /TestMove010 as well as /TestMove010.txt", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        TestMove010.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/TestMove010.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove010.addGlobalMessage((String)"5. clean up and DELETE /TestMove010 as well as /TestMove010.txt", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        TestMove010.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

