/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.movetests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.net.URL;
import java.sql.SQLException;

public class TestMove004
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestMove004.createWebDAVSchema();
        TestMove004.addGlobalMessage((String)("prepare test " + TestMove004.getTestClassId()), (char)'I', (String)"************************\n* Moving a collection. *\n************************");
        host = new String(TestMove004.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestMove004.getPort();
        baseUrl = TestMove004.getParameterString((String)"baseUrl", (String)"webdav");
        var_overwrite = TestMove004.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestMove004.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestMove004.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestMove004.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestMove004.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestMove004.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = "/TestMove004";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove004.addGlobalMessage((String)"1. DELETE folder /TestMove004 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature");
        }
        TestMove004.doDelete(resource, locktoken, host + ":" + WDV_PORT + "/" + baseUrl + urlStr);
        urlStr = "/temp004";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove004.addGlobalMessage((String)"1. DELETE folder /temp004 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature");
        }
        TestMove004.doDelete(resource, locktoken, host + ":" + WDV_PORT + "/" + baseUrl + urlStr);
        urlStr = "/TestMove004";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove004.addGlobalMessage((String)"1. MkCol for folder /TestMove004 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature");
        }
        if (!TestMove004.doMkCol(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr = urlStr + "/sub1");
        if (resource == null) {
            TestMove004.addGlobalMessage((String)"3. MkCol to create folder /TestMove004/sub1 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature");
        }
        TestMove004.doMkCol(resource, locktoken, host + ":" + WDV_PORT + "/" + baseUrl + urlStr);
        urlStr = urlStr + "/sub2";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove004.addGlobalMessage((String)"4. MkCol to create folder /TestMove004/sub1/sub2 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature");
        }
        TestMove004.doMkCol(resource, locktoken, host + ":" + WDV_PORT + "/" + baseUrl + urlStr);
        urlStr = "/temp004";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove004.addGlobalMessage((String)"5. MkCol to create folder /temp004 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature");
        }
        TestMove004.doMkCol(resource, locktoken, host + ":" + WDV_PORT + "/" + baseUrl + urlStr);
        urlStr = urlStr + "/TestMove004";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove004.addGlobalMessage((String)"6. MkCol to create folder /temp004/TestMove004 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature");
        }
        TestMove004.doMkCol(resource, locktoken, host + ":" + WDV_PORT + "/" + baseUrl + urlStr);
        urlStr = "/TestMove004/sub1/sub2/Wanze.txt";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove004.addGlobalMessage((String)"7. create a ressource (file 'Wanze.txt') in the folder /TestMove004/sub1/sub2 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature");
        }
        content = "Auf der Mauer, auf der Lauer sitzt 'ne kleine Wanze.";
        contentType = "text/plain";
        contentLength = content.length();
        locktoken = null;
        TestMove004.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public void run() {
        urlStr = "/temp004/TestMove004";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove004.addGlobalMessage((String)"8. overwrite the folder /TestMove004 by moving /temp004/TestMove004 to baseUrl", (char)'E', (String)"Preparations failed due to some Java feature");
        }
        String dest_Url = null;
        String overwrite = var_overwrite;
        String body = null;
        try {
            dest_Url = new URL("http", host, WDV_PORT, baseUrl).toString();
            resource.MOVE(dest_Url, overwrite, body, locktoken, null);
        }
        catch (WDVTestJ_WdvException e) {
            if (overwrite == "T" && e.getStatusCode() != 201) {
                TestMove004.addGlobalMessage((String)("8. overwrite the folder /TestMove004 by moving /temp004/TestMove004 to baseUrl " + dest_Url), (char)'E', (String)("WebDAV exception: " + e.getStatusCode() + " " + e.getMessage() + "\n" + "Expected result: 201 Created"));
            }
            if (overwrite == "F" && e.getStatusCode() != 412) {
                TestMove004.addGlobalMessage((String)("8. overwrite the folder /TestMove004 by moving /temp004/TestMove004 to baseUrl " + dest_Url), (char)'E', (String)("WebDAV exception: " + e.getStatusCode() + " " + e.getMessage() + "\n" + "Expected result: 412 Precondition failed"));
            }
        }
        catch (Exception exc) {
            this.handleExceptions(exc);
        }
        if (var_overwrite == "T") {
            urlStr = "/temp004/TestMove004";
            resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
            if (resource == null) {
                TestMove004.addGlobalMessage((String)"9. when overwrite = 'T', check if the source collection was deleted", (char)'E', (String)"Preparations failed due to some Java feature");
            }
            try {
                if (resource.GET() != null) {
                    TestMove004.addGlobalMessage((String)"Check for deleted source", (char)'E', (String)"The source has not been deleted during moving.");
                    return;
                }
            }
            catch (WDVTestJ_WdvException exc) {
                TestMove004.addGlobalMessage((String)("GET http://" + host + ":" + WDV_PORT + "/" + baseUrl + urlStr), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
                TestMove004.addGlobalMessage((String)"GET failed due to some WebDAV feature", (char)'I', (String)"Expected result: 200 OK");
            }
            catch (Exception exc) {
                TestMove004.addGlobalMessage((String)("GET http://" + host + ":" + WDV_PORT + "/" + baseUrl + urlStr), (char)'E', (String)("Java exception: " + exc));
                exc.printStackTrace();
                TestMove004.addGlobalMessage((String)"Test failed due to some Java feature", (char)'I', (String)"Skipping test...");
            }
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = "/TestMove004";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove004.addGlobalMessage((String)"10. cleaning up test", (char)'E', (String)"Preparations for cleaning up failed due to some Java feature.");
        }
        TestMove004.doDelete(resource, locktoken, host + ":" + WDV_PORT + "/" + baseUrl + urlStr);
        urlStr = "/temp004";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove004.addGlobalMessage((String)"11. cleaning up test", (char)'E', (String)"Preparations for cleaning up failed due to some Java feature.");
        }
        TestMove004.doDelete(resource, locktoken, host + ":" + WDV_PORT + "/" + baseUrl + urlStr);
    }
}

