/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.mkcoltests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestMkcol006
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String var_overwrite = null;
    static String baseUrl = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestMkcol006.createWebDAVSchema();
        TestMkcol006.addGlobalMessage((String)("prepare test " + TestMkcol006.getTestClassId()), (char)'I', (String)"***************************************************************************************\n* put a file and try to use this file as parent resource for a collection (must fail) *\n***************************************************************************************");
        host = new String(TestMkcol006.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestMkcol006.getPort();
        baseUrl = TestMkcol006.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestMkcol006.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestMkcol006.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestMkcol006.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestMkcol006.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestMkcol006.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestMkcol006.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = "/TestMkcol006.txt";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMkcol006.addGlobalMessage((String)"1. DELETE resource /TestMkcol006.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestMkcol006.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = "/TestMkcol006.txt";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMkcol006.addGlobalMessage((String)"2. PUT the file  /TestMkcol006.txt at baseUrl", (char)'E', (String)"Test failed due to some Java feature.");
        }
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        locktoken = null;
        if (!TestMkcol006.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        urlStr = "/TestMkcol006.txt/newCollection";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMkcol006.addGlobalMessage((String)"3. Try to use the file /TestMkcol006.txt as parent resource of a new collection", (char)'E', (String)"Test failed due to some Java feature.");
        }
        try {
            resource.MKCOL(locktoken);
            if (resource.getStatus().getStatusCode() != 403) {
                TestMkcol006.addGlobalMessage((String)"3. Try to use the file /TestMkcol006.txt as parent resource of a new collection", (char)'E', (String)("WebDAV says: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
                TestMkcol006.addGlobalMessage((String)"MkCol failed due to some WebDAV feature. Expected '403 Forbidden'", (char)'I', (String)("Skipping test " + TestMkcol006.getTestClassId()));
                return;
            }
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() == 403) {
                TestMkcol006.addGlobalMessage((String)"3. Try to use the file /TestMkcol006.txt as parent resource of a new collection", (char)'I', (String)(exc.getStatusCode() + " " + exc.getMessage()));
                TestMkcol006.addGlobalMessage((String)"3. Try to use the file /TestMkcol006.txt as parent resource of a new collection", (char)'I', (String)"Expected: 403 Forbidden. Test was successful!");
            } else {
                TestMkcol006.addGlobalMessage((String)"3. Try to use the file /TestMkcol006.txt as parent resource of a new collection", (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
                TestMkcol006.addGlobalMessage((String)"MkCol failed due to some WebDAV feature", (char)'I', (String)("Skipping test " + TestMkcol006.getTestClassId()));
            }
        }
        catch (Exception exc) {
            TestMkcol006.addGlobalMessage((String)"3. Try to use the file /TestMkcol006.txt as parent resource of a new collection", (char)'E', (String)("Java exception: " + exc));
            TestMkcol006.addGlobalMessage((String)"MkCol failed due to some Java feature", (char)'I', (String)exc.getMessage());
            return;
        }
    }

    public static void cleanUp() throws TestCaseException {
        TestMkcol006.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = "/TestMkcol006.txt";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMkcol006.addGlobalMessage((String)"5. DELETE resource /TestMkcol006.txt at baseUrl", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        TestMkcol006.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

