/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.mkcoltests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestMkcol003
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestMkcol003.createWebDAVSchema();
        TestMkcol003.addGlobalMessage((String)("prepare test " + TestMkcol003.getTestClassId()), (char)'I', (String)"****************************\n* MKCOL on existing folder *\n****************************");
        host = new String(TestMkcol003.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestMkcol003.getPort();
        baseUrl = TestMkcol003.getParameterString((String)"baseUrl", (String)"webdav");
        var_overwrite = TestMkcol003.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestMkcol003.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestMkcol003.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestMkcol003.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestMkcol003.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestMkcol003.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = "/TestMkcol003";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMkcol003.addGlobalMessage((String)"1. DELETE resource /TestMkcol003 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestMkcol003.doDelete(resource, locktoken, host + ":" + WDV_PORT + "/" + baseUrl + urlStr);
        if (!TestMkcol003.doMkCol(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        try {
            resource.MKCOL(null);
            if (resource.getStatus().getStatusCode() != 405) {
                TestMkcol003.addGlobalMessage((String)("MKCOL http://" + host + ":" + WDV_PORT + baseUrl + "/TestMkcol003"), (char)'E', (String)("WebDAV exception: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + "    Expected result: 405 Method not allowed"));
            }
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() != 405) {
                TestMkcol003.addGlobalMessage((String)("MKCOL http://" + host + ":" + WDV_PORT + baseUrl + "/TestMkcol003"), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + "    Expected result: 405 Method not allowed"));
            } else {
                TestMkcol003.addGlobalMessage((String)TestMkcol003.getTestClassId(), (char)'I', (String)"Test..................ok");
            }
        }
        catch (Exception exc) {
            TestMkcol003.addGlobalMessage((String)("MKCOL http://" + host + ":" + WDV_PORT + baseUrl + "/TestMkcol003"), (char)'E', (String)("Java exception: " + exc));
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = "/TestMkcol003";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMkcol003.addGlobalMessage((String)"4. DELETE folder /TestMkcol003 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestMkcol003.doDelete(resource, locktoken, host + ":" + WDV_PORT + "/" + baseUrl + urlStr);
    }
}

