/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.locktests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public class TestLock013
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestLock013.createWebDAVSchema();
        TestLock013.addGlobalMessage((String)("prepare test " + TestLock013.getTestClassId()), (char)'I', (String)"create a null resource and do a PROPPATCH on it (must fail)");
        host = new String(TestLock013.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestLock013.getPort();
        baseUrl = TestLock013.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestLock013.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestLock013.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestLock013.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestLock013.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestLock013.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestLock013.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestLock013.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestLock013.addGlobalMessage((String)"1. create the null resource", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (resource.exists() && (locktoken = TestLock013.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr)) != null) {
            TestLock013.doUnlock(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        }
        if (resource.exists() && !TestLock013.doDelete(resource, locktoken = TestLock013.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr), host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n";
        body = body + "<D:lockinfo xmlns:D=\"DAV:\">\n";
        body = body + "<D:locktype>\n";
        body = body + "<D:write/>\n";
        body = body + "</D:locktype>\n";
        body = body + "<D:lockscope>\n";
        body = body + "<D:exclusive/>\n";
        body = body + "</D:lockscope>\n";
        body = body + "<D:owner>D041249</D:owner>\n";
        body = body + "</D:lockinfo>\n";
        try {
            resource.LOCK(body, null);
            if (resource.getStatus().getStatusCode() == 200) {
                TestLock013.addGlobalMessage((String)"3. LOCK the null-resource /TestLock013.txt", (char)'I', (String)"LOCK was successful!");
            }
        }
        catch (WDVTestJ_WdvException exc) {
            TestLock013.addGlobalMessage((String)"3. LOCK the null-resource /TestLock013.txt", (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
            TestLock013.addGlobalMessage((String)"3. LOCK the null-resource /TestLock013.txt", (char)'I', (String)"Test failed due to some WebDAV feature. Expected: 200 OK");
            throw new TestCaseException(exc.getMessage());
        }
        catch (Exception exc) {
            TestLock013.addGlobalMessage((String)"3. LOCK the null-resource /TestLock013.txt", (char)'E', (String)("Java exception: " + exc.getMessage()));
            TestLock013.addGlobalMessage((String)"3. LOCK the null-resource /TestLock013.txt", (char)'I', (String)"Test failed due to some Java feature.");
            throw new TestCaseException(exc.getMessage());
        }
    }

    public void run() {
        String pp_body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
        pp_body = pp_body + "\n<D:propertyupdate xmlns:D=\"DAV:\"";
        pp_body = pp_body + "\nxmlns:Z=\"DAV:\">";
        pp_body = pp_body + "\n<D:set>";
        pp_body = pp_body + "\n<D:prop>";
        pp_body = pp_body + "\n<Z:test/>";
        pp_body = pp_body + "\n</D:prop>";
        pp_body = pp_body + "\n</D:set>";
        pp_body = pp_body + "\n</D:propertyupdate>";
        try {
            locktoken = TestLock013.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr);
            resource.PROPPATCH(pp_body, locktoken);
            if (resource.getStatus().getStatusCode() != 405) {
                TestLock013.addGlobalMessage((String)"2. do the PROPPATCH on the null resource", (char)'W', (String)("PROPPATCH could be executed!Response: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + "\n" + "Test failed due to some WebDAV feature. Expected: 405 Method Not Allowed.\n" + "PTS message: \n" + "http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1127814"));
                return;
            }
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() == 405) {
                TestLock013.addGlobalMessage((String)"2. do the PROPPATCH on the null resource", (char)'I', (String)("Test was successful! Response: " + exc.getStatusCode() + " " + exc.getMessage()));
            } else {
                TestLock013.addGlobalMessage((String)"2. do the PROPPATCH on the null resource", (char)'E', (String)("status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + "\n" + "Test failed due to some WebDAV feature. Expected: 405 Method Not Allowed."));
            }
        }
        catch (SAXParseException exc) {
            TestLock013.addGlobalMessage((String)"2. do the PROPPATCH on the null resource", (char)'E', (String)("parser says: " + exc.getMessage() + "\n" + "request body: " + pp_body));
        }
        catch (Exception exc) {
            TestLock013.addGlobalMessage((String)"2. do the PROPPATCH on the null resource", (char)'E', (String)("Java exception: " + exc + "\n" + "Test failed due to some Java feature"));
        }
        Document xmlbody = null;
        String body = new String("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
        body = body + "<D:propfind xmlns:D=\"DAV:\">\n";
        body = body + "<D:prop>\n";
        body = body + "<D:test/>\n";
        body = body + "</D:prop>\n";
        body = body + "</D:propfind>\n";
        try {
            TestLock013.addGlobalMessage((String)"3. check whether the new property was not set", (char)'I', (String)"setting up PROPFIND method...");
            xmlbody = resource.PROPFIND(body);
        }
        catch (WDVTestJ_WdvException exc) {
            TestLock013.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
            TestLock013.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Method failed due to some WebDAV feature");
            return;
        }
        catch (Exception exc) {
            TestLock013.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("Java exception: " + exc));
            TestLock013.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)" Method failed due to some Java feature");
            return;
        }
        if (resource.getStatus().getStatusCode() == 207) {
            try {
                NodeList nl = xmlbody.getElementsByTagName("s1:test");
                nl.item(0);
            }
            catch (NullPointerException exc) {
                TestLock013.addGlobalMessage((String)"retrieving the 's1:test'-element", (char)'E', (String)"the 'test'-property for the resource could not be retrieved");
                return;
            }
            String status = null;
            status = xmlbody.getElementsByTagName("D:status").item(0).getFirstChild().getNodeValue();
            if (status.equalsIgnoreCase("HTTP/1.1 404 Not Found")) {
                TestLock013.addGlobalMessage((String)"3. check whether the new property was not set", (char)'I', (String)("element was not found in XML response. Status: " + status));
                TestLock013.addGlobalMessage((String)"3. check whether the new property was not set", (char)'I', (String)"Test was successful!");
            } else {
                TestLock013.addGlobalMessage((String)"3. check whether the new property was not set", (char)'E', (String)("element was found in XML response. Status: " + status));
                TestLock013.addGlobalMessage((String)"3. check whether the new property was not set", (char)'I', (String)"Test failed due to some WebDAV feature.");
                return;
            }
        }
    }

    public static void cleanUp() throws TestCaseException {
        locktoken = TestLock013.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr);
        if (locktoken != null) {
            TestLock013.doUnlock(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        }
    }
}

