/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.locktests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestLock011
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestLock011.createWebDAVSchema();
        TestLock011.addGlobalMessage((String)("prepare test " + TestLock011.getTestClassId()), (char)'I', (String)"try to create a null resource whose parent does not exist");
        host = new String(TestLock011.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestLock011.getPort();
        baseUrl = TestLock011.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestLock011.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestLock011.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestLock011.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestLock011.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestLock011.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestLock011.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestLock011");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestLock011.addGlobalMessage((String)"1. DELETE resource /TestLock011 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (resource.exists() && !TestLock011.doDelete(resource, locktoken = TestLock011.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr), host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        urlStr = new String("/TestLock011/TestLock011.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestLock011.addGlobalMessage((String)"3. LOCK the null-resource /TestLock011/TestLock011.txt", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n";
        body = body + "<D:lockinfo xmlns:D=\"DAV:\">\n";
        body = body + "<D:locktype>\n";
        body = body + "<D:write/>\n";
        body = body + "</D:locktype>\n";
        body = body + "<D:lockscope>\n";
        body = body + "<D:exclusive/>\n";
        body = body + "</D:lockscope>\n";
        body = body + "<D:owner>D041249</D:owner>\n";
        body = body + "</D:lockinfo>\n";
        try {
            resource.LOCK(body, null);
            if (resource.getStatus().getStatusCode() == 200) {
                TestLock011.addGlobalMessage((String)"3. LOCK the null-resource /TestLock011/TestLock011.txt", (char)'E', (String)("WebDAV says: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
                TestLock011.addGlobalMessage((String)"3. LOCK the null-resource /TestLock011/TestLock011.txt", (char)'I', (String)"Test failed due to some WebDAV feature. Expected: 409 Conflict.");
            }
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() == 409) {
                TestLock011.addGlobalMessage((String)"3. LOCK the null-resource /TestLock011/TestLock011.txt", (char)'I', (String)("Test was successful! WebDAV returned: " + exc.getStatusCode() + " " + exc.getMessage()));
            }
            TestLock011.addGlobalMessage((String)"3. LOCK the null-resource /TestLock011/TestLock011.txt", (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
            TestLock011.addGlobalMessage((String)"3. LOCK the null-resource /TestLock011/TestLock011.txt", (char)'I', (String)"Test failed due to some WebDAV feature. Expected: 409 Conflict");
            return;
        }
        catch (Exception exc) {
            TestLock011.addGlobalMessage((String)"3. LOCK the null-resource /TestLock011/TestLock011.txt", (char)'E', (String)("Java exception: " + exc.getMessage()));
            TestLock011.addGlobalMessage((String)"3. LOCK the null-resource /TestLock011/TestLock011.txt", (char)'I', (String)"Test failed due to some Java feature.");
            return;
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestLock011/TestLock011.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestLock011.addGlobalMessage((String)"4. DELETE resource /TestLock011/TestLock011.txt at baseUrl", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        if (resource.exists()) {
            locktoken = TestLock011.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr);
            TestLock011.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        }
    }
}

