/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.locktests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;
import org.w3c.dom.Document;

public class TestLock006
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static Document xmlDocument = null;

    public static void prepare() throws TestCaseException {
        TestLock006.createWebDAVSchema();
        TestLock006.addGlobalMessage((String)("prepare test " + TestLock006.getTestClassId()), (char)'I', (String)"lock a resource using an owner value that exceeds 450 characters and check whether the LOCK-owner is stored correctly. (currently it's a feature, that the server replies with '409 Conflict' on such a big LOCK-owner value)");
        host = new String(TestLock006.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestLock006.getPort();
        baseUrl = TestLock006.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestLock006.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestLock006.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestLock006.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestLock006.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestLock006.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestLock006.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestLock006.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestLock006.addGlobalMessage((String)"1. DELETE resource /TestLock006.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
            return;
        }
        if (resource.exists()) {
            locktoken = TestLock006.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr);
            TestLock006.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        }
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        if (!TestLock006.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        String lockOwner = "D041249";
        while (lockOwner.length() <= 450) {
            lockOwner = lockOwner + "D041249";
        }
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n";
        body = body + "<D:lockinfo xmlns:D=\"DAV:\">\n";
        body = body + "<D:locktype>\n";
        body = body + "<D:write/>\n";
        body = body + "</D:locktype>\n";
        body = body + "<D:lockscope>\n";
        body = body + "<D:exclusive/>\n";
        body = body + "</D:lockscope>\n";
        body = body + "<D:owner>" + lockOwner + "</D:owner>\n";
        body = body + "</D:lockinfo>\n";
        try {
            resource.LOCK(body, null);
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() == 409) {
                TestLock006.addGlobalMessage((String)"3. LOCK the resource /TestLock006.txt", (char)'I', (String)"Test was successful. The server replied: '409 Conflict'.");
            }
            TestLock006.addGlobalMessage((String)"3. LOCK the resource /TestLock006.txt", (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
            TestLock006.addGlobalMessage((String)"3. LOCK the resource /TestLock006.txt", (char)'I', (String)"Test failed due to some WebDAV feature.");
            return;
        }
        catch (Exception exc) {
            TestLock006.addGlobalMessage((String)"3. LOCK the resource /TestLock006.txt", (char)'E', (String)("Java exception: " + exc.getMessage()));
            TestLock006.addGlobalMessage((String)"3. LOCK the resource /TestLock006.txt", (char)'I', (String)"Test failed due to some Java feature.");
            return;
        }
    }

    public static void cleanUp() throws TestCaseException {
        if (resource.exists()) {
            locktoken = TestLock006.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr);
            TestLock006.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        }
    }
}

