/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.gettests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestGet002
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestGet002.createWebDAVSchema();
        TestGet002.addGlobalMessage((String)("prepare test " + TestGet002.getTestClassId()), (char)'I', (String)"get on a not existing resource");
        host = new String(TestGet002.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestGet002.getPort();
        baseUrl = TestGet002.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestGet002.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestGet002.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestGet002.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestGet002.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestGet002.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestGet002.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = "/TestGet002.txt";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestGet002.addGlobalMessage((String)"1. DELETE resource /TestGet002.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestGet002.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        try {
            String contentLengthR;
            String contentTypeR;
            String contentR = new String(resource.GET());
            if (contentR != null) {
                TestGet002.addGlobalMessage((String)("GET http://" + host + ":" + WDV_PORT + baseUrl + "/" + urlStr), (char)'E', (String)"Content was recieved!!!");
            }
            if ((contentTypeR = resource.getResponseHeaders().get("Content-Type").toString()) != null) {
                TestGet002.addGlobalMessage((String)("GET http://" + host + ":" + WDV_PORT + baseUrl + "/TestGet002.txt"), (char)'E', (String)"content type is different");
            }
            if ((contentLengthR = resource.getResponseHeaders().get("Content-Length").toString()) != null) {
                TestGet002.addGlobalMessage((String)("GET http://" + host + ":" + WDV_PORT + baseUrl + "/TestGet002.txt"), (char)'E', (String)"Content length recieved");
            }
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() == 404) {
                TestGet002.addGlobalMessage((String)("GET http://" + host + ":" + WDV_PORT + baseUrl + "/TestGet002.txt"), (char)'I', (String)("WebDAV says: " + exc.getStatusCode() + " " + exc.getMessage() + "    Test was successful!"));
            } else {
                TestGet002.addGlobalMessage((String)("GET http://" + host + ":" + WDV_PORT + baseUrl + "/TestGet002.txt"), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + "    Expected result: 404 Not found"));
            }
        }
        catch (Exception exc) {
            TestGet002.addGlobalMessage((String)("GET http://" + host + ":" + WDV_PORT + baseUrl + "/TestGet002.txt"), (char)'E', (String)("Java exception: " + exc));
        }
    }

    public static void cleanUp() throws TestCaseException {
    }
}

