/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.deletetests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestDelete004
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestDelete004.createWebDAVSchema();
        TestDelete004.addGlobalMessage((String)("prepare test " + TestDelete004.getTestClassId()), (char)'I', (String)"delete a not existing collection");
        host = new String(TestDelete004.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestDelete004.getPort();
        baseUrl = TestDelete004.getParameterString((String)"baseUrl", (String)"/webdav");
        start_server = TestDelete004.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestDelete004.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestDelete004.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestDelete004.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestDelete004.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = "/TestDelete004";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestDelete004.addGlobalMessage((String)"1. DELETE the collection /TestDelete004", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestDelete004.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        try {
            resource.DELETE(locktoken);
            if (resource.getStatus().getStatusCode() != 404) {
                TestDelete004.addGlobalMessage((String)("DELETE http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("WebDAV exception: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + " Expected result: 404 Not Found"));
                TestDelete004.addGlobalMessage((String)("DELETE http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test failed due to some WebDAV feature.");
            }
        }
        catch (WDVTestJ_WdvException exc) {
            if (resource.getStatus().getStatusCode() == 404) {
                TestDelete004.addGlobalMessage((String)("DELETE http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Status 404 Not Found as expected");
            } else {
                TestDelete004.addGlobalMessage((String)("DELETE http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + " Expected result: 404 Not Found"));
                TestDelete004.addGlobalMessage((String)("DELETE http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test failed due to some WebDAV feature");
            }
        }
        catch (Exception exc) {
            TestDelete004.addGlobalMessage((String)("DELETE http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("Java exception: " + exc));
            TestDelete004.addGlobalMessage((String)("DELETE http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test failed due to some Java feature");
        }
    }

    public static void cleanUp() throws TestCaseException {
    }
}

