/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.copytests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;

public class TestCopy006
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static String depth = null;

    public static void prepare() throws TestCaseException {
        TestCopy006.createWebDAVSchema();
        TestCopy006.addGlobalMessage((String)("prepare test " + TestCopy006.getTestClassId()), (char)'I', (String)"copy a collection with subfolders and resources using 'depth header = infintiy' explicitly");
        host = new String(TestCopy006.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestCopy006.getPort();
        baseUrl = TestCopy006.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestCopy006.getParameterString((String)"var_overwrite", (String)"F");
        depth = "infinity";
        start_server = TestCopy006.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestCopy006.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestCopy006.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestCopy006.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestCopy006.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestCopy006");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy006.addGlobalMessage((String)"1. DELETE /tempCopy006 and /TestCopy006 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestCopy006.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/tempCopy006");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy006.addGlobalMessage((String)"1. DELETE /tempCopy006 and /TestCopy006 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestCopy006.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/TestCopy006");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy006.addGlobalMessage((String)"2. create the folder /TestCopy006 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestCopy006.doMkCol(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/tempCopy006");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy006.addGlobalMessage((String)"2. create the folder /tempCopy006 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestCopy006.doMkCol(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        content = "Sind des Schaefchens Locken braun, lehnt es am Elektrozaun. Wenn es mit den Augen rollt, will es sagen: Zu viel Volt!";
        contentType = "text/plain";
        for (int a = 1; a <= 3; ++a) {
            urlStr = new String("/tempCopy006/folder006_a_" + a);
            resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
            if (resource == null) {
                TestCopy006.addGlobalMessage((String)("3. create sub-folder /folder006_a_" + a + " at /tempCopy006"), (char)'E', (String)"Preparations failed due to some Java feature.");
            }
            TestCopy006.doMkCol(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
            urlStr = new String("/tempCopy006/folder006_a_" + a + "/res006_" + a + ".txt");
            resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
            if (resource == null) {
                TestCopy006.addGlobalMessage((String)("4. create the resource /tempCopy006/folder006_a_" + a + "/res006_" + a + ".txt"), (char)'E', (String)"Preparations failed due to some Java feature.");
            }
            if (!TestCopy006.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
                throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
            }
            for (int b = 1; b <= 3; ++b) {
                urlStr = new String("/tempCopy006/folder006_a_" + a + "/folder006_b_" + b);
                resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
                if (resource == null) {
                    TestCopy006.addGlobalMessage((String)("3. create sub-folder /folder006_b_" + b + " at /tempCopy006/folder006_a_" + a), (char)'E', (String)"Preparations failed due to some Java feature.");
                }
                TestCopy006.doMkCol(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
                urlStr = new String("/tempCopy006/folder006_a_" + a + "/folder006_b_" + b + "/res006_" + b + ".txt");
                resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
                if (resource == null) {
                    TestCopy006.addGlobalMessage((String)("4. create the resource /tempCopy006/folder006_a_" + a + "/folder006_b_" + b + "/res006_" + b + ".txt"), (char)'E', (String)"Preparations failed due to some Java feature.");
                }
                if (!TestCopy006.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
                    throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
                }
                for (int c = 1; c <= 3; ++c) {
                    urlStr = new String("/tempCopy006/folder006_a_" + a + "/folder006_b_" + b + "/folder006_c_" + c);
                    resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
                    if (resource == null) {
                        TestCopy006.addGlobalMessage((String)("3. create sub-folder /folder006_c_" + c + " at /tempCopy006/folder006_a_" + a + "/folder006_b_" + b), (char)'E', (String)"Preparations failed due to some Java feature.");
                    }
                    TestCopy006.doMkCol(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
                    urlStr = new String("/tempCopy006/folder006_a_" + a + "/folder006_b_" + b + "/folder006_c_" + c + "/res006_" + c + ".txt");
                    resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
                    if (resource == null) {
                        TestCopy006.addGlobalMessage((String)("4. create the resource /tempCopy006/folder006_a_" + a + "/folder006_b_" + b + "/folder006_c_" + c + "/res006_" + c + ".txt"), (char)'E', (String)"Preparations failed due to some Java feature.");
                    }
                    if (TestCopy006.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) continue;
                    return;
                }
            }
        }
    }

    public void run() {
        urlStr = new String("/tempCopy006");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy006.addGlobalMessage((String)"5. COPY the collection /tempCopy006 to /TestCopy006 with depth = infinity", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        try {
            String dest_Url = new URL("http", host, WDV_PORT, baseUrl + "/TestCopy006/tempCopy006").toString();
            String body = null;
            locktoken = null;
            if (!TestCopy006.doCopy(resource, dest_Url, var_overwrite, body, locktoken, depth)) {
                return;
            }
        }
        catch (MalformedURLException exc) {
            TestCopy006.addGlobalMessage((String)"5. COPY the collection /tempCopy006 to /TestCopy006 with depth = infinity", (char)'E', (String)"Test failed due to some Java-URL feature");
        }
        for (int a = 1; a <= 3; ++a) {
            urlStr = new String("/TestCopy006/tempCopy006/folder006_a_" + a + "/res006_" + a + ".txt");
            resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
            if (resource == null) {
                TestCopy006.addGlobalMessage((String)("6. check for /TestCopy006/tempCopy006/folder006_a_" + a + "/res006_" + a + ".txt"), (char)'E', (String)"Preparations failed due to some Java feature.");
            }
            if (!TestCopy006.compareContent(resource, content, contentType, content.length(), host + ":" + WDV_PORT + baseUrl + urlStr)) {
                return;
            }
            for (int b = 1; b <= 3; ++b) {
                urlStr = new String("/TestCopy006/tempCopy006/folder006_a_" + a + "/folder006_b_" + b + "/res006_" + b + ".txt");
                resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
                if (resource == null) {
                    TestCopy006.addGlobalMessage((String)("6. /TestCopy006/tempCopy006/folder006_a_" + a + "/folder006_b_" + b + "/res006_" + b + ".txt"), (char)'E', (String)"Preparations failed due to some Java feature.");
                }
                if (!TestCopy006.compareContent(resource, content, contentType, content.length(), host + ":" + WDV_PORT + baseUrl + urlStr)) {
                    return;
                }
                for (int c = 1; c <= 3; ++c) {
                    urlStr = new String("/TestCopy006/tempCopy006/folder006_a_" + a + "/folder006_b_" + b + "/folder006_c_" + c + "/res006_" + c + ".txt");
                    resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
                    if (resource == null) {
                        TestCopy006.addGlobalMessage((String)("6. /TestCopy006/tempCopy006/folder006_a_" + a + "/folder006_b_" + b + "/folder006_c_" + c + "/res006_" + c + ".txt"), (char)'E', (String)"Preparations failed due to some Java feature.");
                    }
                    if (TestCopy006.compareContent(resource, content, contentType, content.length(), host + ":" + WDV_PORT + baseUrl + urlStr)) continue;
                    return;
                }
            }
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestCopy006");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy006.addGlobalMessage((String)"7. clean up and DELETE /tempCopy006 as well as /TestCopy006", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        TestCopy006.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/tempCopy006");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy006.addGlobalMessage((String)"7. clean up and DELETE /tempCopy006 as well as /TestCopy006", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        TestCopy006.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

