/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.gui.jface_viewer;

import com.sap.sdb.syncMan.design.DataBaseNode;
import com.sap.sdb.syncMan.design.DesignSQLLayer;
import com.sap.sdb.syncMan.design.ReplicationTable;
import com.sap.sdb.syncMan.design.SchemaNode;
import com.sap.sdb.syncMan.design.ServerNode;
import com.sap.sdb.syncMan.gui.jface_controls.ReplicationTableControl;
import com.sap.sdb.syncMan.gui.jface_controls.SyncManControl;
import java.sql.SQLException;
import java.util.Vector;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class RepTableTreeContentProvider
implements ITreeContentProvider {
    ReplicationTableControl _replicationTableControl;

    public RepTableTreeContentProvider(ReplicationTableControl replicationTableControl) {
        this._replicationTableControl = replicationTableControl;
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children = null;
        try {
            if (parentElement instanceof SchemaNode) {
                SchemaNode item = (SchemaNode)parentElement;
                Vector tables = DesignSQLLayer.selectRepTables(this._replicationTableControl.getConMetaData(), item, "%");
                children = tables.toArray();
            } else {
                ServerNode server = new ServerNode(this._replicationTableControl.getConMetaData().getHost());
                DataBaseNode db = new DataBaseNode(server, this._replicationTableControl.getConMetaData().getDataBase());
                Vector schemas = DesignSQLLayer.selectRepTableSchema(this._replicationTableControl.getConMetaData(), db);
                children = schemas.toArray();
            }
        }
        catch (SQLException ex) {
            SyncManControl.writeProt(ex);
        }
        if (children == null) {
            children = new Object[]{};
        }
        return children;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element == null) {
            return false;
        }
        if (element instanceof ReplicationTable) {
            return ((ReplicationTable)element).hasChilden();
        }
        return true;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement == null) {
            return null;
        }
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (oldInput != null) {
            // empty if block
        }
        if (newInput != null) {
            // empty if block
        }
    }
}

