/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.gui.jface_viewer;

import com.sap.sdb.syncMan.design.DesignSQLLayer;
import com.sap.sdb.syncMan.design.InstalledRepTable;
import com.sap.sdb.syncMan.design.Participant;
import com.sap.sdb.syncMan.design.TablesNode;
import com.sap.sdb.syncMan.gui.jface_controls.MonitorControl;
import com.sap.sdb.syncMan.tool.ConMessageServer;
import com.sap.sdb.syncMan.tool.Resources;
import java.util.Vector;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class MonitorTreeContentProvider
implements ITreeContentProvider {
    MonitorControl _monitorControl;

    public MonitorTreeContentProvider(MonitorControl MonitorControl2) {
        this._monitorControl = MonitorControl2;
    }

    public Object[] getChildren(Object parentElement) {
        Vector temp;
        block18: {
            temp = new Vector();
            if (parentElement instanceof String) {
                try {
                    if (parentElement.toString().startsWith(Resources.getString("Monitor.Message_Server"))) {
                        if (!this._monitorControl.getConMessageServer().isConnected()) {
                            MonitorControl.writeProt("Message Server is not connected.", true);
                            return temp.toArray();
                        }
                        temp = ConMessageServer.loadAllDestinations(this._monitorControl.getConMessageServer());
                        break block18;
                    }
                    if (parentElement.toString().startsWith("SYNC_TOPIC_")) {
                        if (!this._monitorControl.getConMessageServer().isConnected()) {
                            MonitorControl.writeProt("Message Server is not connected.", true);
                            return temp.toArray();
                        }
                        temp = ConMessageServer.loadSubscriptions(this._monitorControl.getConMessageServer(), parentElement.toString());
                        break block18;
                    }
                    if (!parentElement.toString().startsWith(Resources.getString("Monitor.Participants"))) break block18;
                    try {
                        if (!this._monitorControl.getConMetaData().isConnected()) {
                            MonitorControl.writeProt("Database is not connected.", true);
                            return temp.toArray();
                        }
                        temp = DesignSQLLayer.selectDistinctParticipants(this._monitorControl.getConMetaData());
                    }
                    catch (Exception ex) {
                        MonitorControl.writeProt(ex);
                        return temp.toArray();
                    }
                }
                catch (Exception ex) {
                    MonitorControl.writeProt(ex);
                }
            } else if (parentElement instanceof TablesNode) {
                temp = ((TablesNode)parentElement).getChildren();
            } else if (parentElement instanceof Participant) {
                try {
                    Vector tables = this._monitorControl.loadRepSystemTableNames((Participant)parentElement);
                    TablesNode audit = new TablesNode((Participant)parentElement, Resources.getString("Monitor.Audit_Tables"));
                    TablesNode shadow = new TablesNode((Participant)parentElement, Resources.getString("Monitor.Shadow_Tables"));
                    TablesNode version = new TablesNode((Participant)parentElement, Resources.getString("Monitor.Version_Tables"));
                    for (int i = 0; i < tables.size(); ++i) {
                        audit.addChild(((InstalledRepTable)tables.get(i)).getAuditTableName());
                        shadow.addChild(((InstalledRepTable)tables.get(i)).getShadowTableName());
                        version.addChild(((InstalledRepTable)tables.get(i)).getVersionTableName());
                    }
                    temp.add(audit);
                    temp.add(shadow);
                    temp.add(version);
                }
                catch (Exception ex) {
                    MonitorControl.writeProt(ex);
                }
            } else {
                temp.add(Resources.getString("Monitor.Participants"));
                temp.add(Resources.getString("Monitor.Message_Server"));
            }
        }
        return temp.toArray();
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element.toString().startsWith("SYNC_TOPIC_")) {
            return true;
        }
        if (element.toString().startsWith(Resources.getString("Monitor.Participants"))) {
            return true;
        }
        if (element.toString().startsWith(Resources.getString("Monitor.Message_Server"))) {
            return true;
        }
        if (element.toString().startsWith(Resources.getString("Monitor.Audit_Tables"))) {
            return true;
        }
        if (element.toString().startsWith(Resources.getString("Monitor.Shadow_Tables"))) {
            return true;
        }
        if (element.toString().startsWith(Resources.getString("Monitor.Version_Tables"))) {
            return true;
        }
        return element instanceof Participant;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement == null) {
            return null;
        }
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

