/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.gui.jface_dialog;

import com.sap.sdb.syncMan.tool.Resources;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MSConnectDialog
extends Dialog {
    private Text m_HostText;
    private Text m_PortText;
    private Text m_PasswordText;
    private Button m_UseSSLButton;
    private String m_Host = "";
    private String m_Port = "";
    private String m_Password = "";
    private boolean m_UseSSL = false;

    public MSConnectDialog(Shell parentShell, String host, int port, String password) {
        super(parentShell);
        this.m_Host = host;
        this.m_Port = Integer.toString(port);
        this.m_Password = password;
    }

    public void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Connect to Message Server");
        shell.setImage(Resources.getImage("connect"));
    }

    protected Control createButtonBar(Composite parent) {
        return super.createButtonBar(parent);
    }

    protected Control createDialogArea(Composite parent) {
        Composite page = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 10;
        gridLayout.horizontalSpacing = 10;
        page.setLayout((Layout)gridLayout);
        Group machineGroup = new Group(page, 0);
        machineGroup.setText("");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 10;
        gridLayout.horizontalSpacing = 10;
        machineGroup.setLayout((Layout)gridLayout);
        Label hostLabel = new Label((Composite)machineGroup, 0);
        hostLabel.setText(Resources.getString("Logon.Server"));
        GridData gridData = new GridData();
        gridData.widthHint = 100;
        hostLabel.setLayoutData((Object)gridData);
        this.m_HostText = new Text((Composite)machineGroup, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 100;
        this.m_HostText.setLayoutData((Object)gridData);
        if (this.m_Host != null) {
            this.m_HostText.setText(this.m_Host);
        }
        Label PortLabel = new Label((Composite)machineGroup, 0);
        PortLabel.setText(Resources.getString("Logon.Port"));
        this.m_PortText = new Text((Composite)machineGroup, 2048);
        gridData = new GridData(768);
        this.m_PortText.setLayoutData((Object)gridData);
        if (this.m_Port != null && !this.m_Port.equalsIgnoreCase("-1")) {
            this.m_PortText.setText(this.m_Port);
        }
        this.m_PortText.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                String text = e.text;
                char[] chars = new char[text.length()];
                text.getChars(0, chars.length, chars, 0);
                for (int i = 0; i < chars.length; ++i) {
                    if ('0' <= chars[i] && chars[i] <= '9') continue;
                    e.doit = false;
                    return;
                }
            }
        });
        Label passwordLabel = new Label((Composite)machineGroup, 0);
        passwordLabel.setText(Resources.getString("Logon.Password"));
        this.m_PasswordText = new Text((Composite)machineGroup, 2048);
        gridData = new GridData(768);
        this.m_PasswordText.setLayoutData((Object)gridData);
        this.m_PasswordText.setEchoChar('*');
        this.m_PasswordText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (MSConnectDialog.this.m_PasswordText.getText() != null && MSConnectDialog.this.m_PasswordText.getText().length() > 0 && MSConnectDialog.this.m_PasswordText.getText().charAt(0) != '\"' || (MSConnectDialog.this.m_PasswordText.getText() == null || MSConnectDialog.this.m_PasswordText.getText().length() < 1) && e.text.length() > 0 && e.text.charAt(0) != '\"') {
                    e.text = e.text.toUpperCase();
                }
            }
        });
        if (this.m_Password != null) {
            this.m_PasswordText.setText(this.m_Password);
        }
        this.m_UseSSLButton = new Button((Composite)machineGroup, 32);
        this.m_UseSSLButton.setText("SSL Connection");
        this.m_UseSSLButton.setSelection(this.m_UseSSL);
        if (this.m_HostText.getText() == null || this.m_HostText.getText().length() < 1) {
            this.m_HostText.setText(Resources.getString("DefaultHost"));
        }
        this.m_HostText.setFocus();
        return page;
    }

    protected void okPressed() {
        this.m_Host = this.m_HostText.getText();
        this.m_Port = this.m_PortText.getText();
        if (this.m_Port == null || this.m_Port.length() < 1) {
            this.m_PortText.setFocus();
            return;
        }
        this.m_Password = this.m_PasswordText.getText();
        if (this.m_Password == null || this.m_Password.length() < 1) {
            this.m_PasswordText.setFocus();
            return;
        }
        this.m_UseSSL = this.m_UseSSLButton.getSelection();
        super.okPressed();
    }

    public String getHost() {
        return this.m_Host;
    }

    public int getPort() {
        return Integer.parseInt(this.m_Port);
    }

    public String getPassword() {
        return this.m_Password;
    }

    public boolean useSSL() {
        return this.m_UseSSL;
    }
}

