/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.gui.jface_dialog;

import com.sap.sdb.syncMan.design.DesignSQLLayer;
import com.sap.sdb.syncMan.tool.ConDataBase;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ImportRepTableDialog
extends Dialog {
    int colWidth = 200;
    private Text _tableFilter;
    private Combo _schemas;
    private List _tables;
    private ConDataBase _conImportRepTable = null;
    private ConDataBase _conMetaData = null;

    public ImportRepTableDialog(Shell parentShell, ConDataBase conImportRepTable, ConDataBase conMetaData) {
        super(parentShell);
        this._conImportRepTable = conImportRepTable;
        this._conMetaData = conMetaData;
    }

    public void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Add Table");
    }

    protected Control createButtonBar(Composite parent) {
        Composite comp = (Composite)super.createButtonBar(parent);
        this.createButton(comp, "Refresh");
        return comp;
    }

    private Button createButton(Composite parent, String label) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        button.setText(label);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImportRepTableDialog.this.addTablesOfSchema(ImportRepTableDialog.this._schemas.getItem(ImportRepTableDialog.this._schemas.getSelectionIndex()), ImportRepTableDialog.this._tableFilter.getText());
            }
        });
        button.setFont(parent.getFont());
        this.setButtonLayoutData(button);
        return button;
    }

    protected Control createDialogArea(Composite parent) {
        Composite page = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 10;
        gridLayout.horizontalSpacing = 10;
        page.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        page.setLayoutData((Object)gridData);
        Label tableTables = new Label(page, 0);
        tableTables.setText("Tables:");
        this._tables = new List(page, 2818);
        gridData = new GridData(1808);
        int listHeight = this._tables.getItemHeight() * 10;
        Rectangle trim = this._tables.computeTrim(0, 0, this.colWidth, listHeight);
        gridData.heightHint = trim.height;
        gridData.widthHint = trim.width;
        this._tables.setLayoutData((Object)gridData);
        this._tables.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                ImportRepTableDialog.this.okPressed();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        Label tableFilterTable = new Label(page, 0);
        tableFilterTable.setText("Table Name:");
        this._tableFilter = new Text(page, 2048);
        this._tableFilter.setText("%");
        gridData = new GridData(768);
        trim = this._tables.computeTrim(0, 0, this.colWidth, 0);
        gridData.widthHint = trim.width;
        this._tableFilter.setLayoutData((Object)gridData);
        Label schemaLabel = new Label(page, 0);
        schemaLabel.setText("Table Schema:");
        this._schemas = new Combo(page, 12);
        this._schemas.setText("");
        this._schemas.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportRepTableDialog.this.addTablesOfSchema(ImportRepTableDialog.this._schemas.getItem(ImportRepTableDialog.this._schemas.getSelectionIndex()), ImportRepTableDialog.this._tableFilter.getText());
            }
        });
        gridData = new GridData(1808);
        trim = this._tables.computeTrim(0, 0, this.colWidth, 0);
        gridData.widthHint = trim.width;
        this._schemas.setLayoutData((Object)gridData);
        this.addSchemas();
        this.addTablesOfSchema(this._schemas.getItem(this._schemas.getSelectionIndex()), this._tableFilter.getText());
        return page;
    }

    protected void okPressed() {
        this.applySelectedTables();
        super.okPressed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void addSchemas() {
        block14: {
            ResultSet result;
            block13: {
                result = null;
                int index = 0;
                DatabaseMetaData meta = this._conImportRepTable.getConnection().getMetaData();
                result = meta.getSchemas();
                while (result.next()) {
                    String temp = result.getString(1);
                    if (temp.length() <= 0) continue;
                    if (temp.equals(this._conImportRepTable.getUser())) {
                        index = this._schemas.getItemCount();
                    }
                    this._schemas.add(temp);
                }
                if (this._schemas.getItemCount() <= 0) break block13;
                this._schemas.select(index);
            }
            Object var6_6 = null;
            try {
                if (result != null) {
                    result.close();
                }
                break block14;
            }
            catch (SQLException ex2) {}
            break block14;
            {
                catch (SQLException ex) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)ex.toString());
                    Object var6_7 = null;
                    try {
                        if (result != null) {
                            result.close();
                        }
                        break block14;
                    }
                    catch (SQLException ex2) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException ex2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void addTablesOfSchema(String schema, String filter) {
        block12: {
            this._tables.removeAll();
            ResultSet result = null;
            String[] types = new String[]{"TABLE", "SYSTEM"};
            DatabaseMetaData dbMeta = this._conImportRepTable.getConnection().getMetaData();
            result = dbMeta.getTables("", schema, filter, types);
            while (result.next()) {
                String name = result.getString("TABLE_NAME");
                this._tables.add(name);
            }
            Object var8_8 = null;
            try {
                if (result != null) {
                    result.close();
                }
                break block12;
            }
            catch (SQLException ex2) {}
            break block12;
            {
                catch (SQLException ex) {
                    ex.printStackTrace();
                    Object var8_9 = null;
                    try {
                        if (result != null) {
                            result.close();
                        }
                        break block12;
                    }
                    catch (SQLException ex2) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException ex2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private void applySelectedTables() {
        String[] selectedTables = this._tables.getSelection();
        for (int i = 0; i < selectedTables.length; ++i) {
            String schema = this._schemas.getItem(this._schemas.getSelectionIndex());
            String name = selectedTables[i];
            try {
                DesignSQLLayer.insertRepTable(this._conMetaData, schema, name);
                this._conMetaData.getConnection().commit();
                continue;
            }
            catch (Exception ex) {
                try {
                    this._conMetaData.getConnection().rollback();
                    MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)ex.toString());
                    continue;
                }
                catch (Exception ex2) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)ex.toString());
                }
            }
        }
    }
}

