/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.gui.jface_controls;

import com.sap.dbtech.powertoys.Loader;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.sdb.syncMan.capture.CaptureManager;
import com.sap.sdb.syncMan.design.Column;
import com.sap.sdb.syncMan.design.ColumnGroup;
import com.sap.sdb.syncMan.design.DesignSQLLayer;
import com.sap.sdb.syncMan.design.Participant;
import com.sap.sdb.syncMan.design.ParticipantConfig;
import com.sap.sdb.syncMan.design.TablesNode;
import com.sap.sdb.syncMan.design.UnitTable;
import com.sap.sdb.syncMan.design.UnitsNode;
import com.sap.sdb.syncMan.gui.SyncManGUI;
import com.sap.sdb.syncMan.gui.jface_controls.SyncManControl;
import com.sap.sdb.syncMan.gui.jface_dialog.ParticipantConfigDialog;
import com.sap.sdb.syncMan.gui.jface_dialog.ParticipantDialog;
import com.sap.sdb.syncMan.gui.jface_dialog.ReplicationTableDialog;
import com.sap.sdb.syncMan.gui.jface_dialog.ReplicationTablePropertiesDialog;
import com.sap.sdb.syncMan.gui.jface_viewer.ParticipantConfigCellModifier;
import com.sap.sdb.syncMan.gui.jface_viewer.ParticipantConfigContentProvider;
import com.sap.sdb.syncMan.gui.jface_viewer.ParticipantConfigLabelProvider;
import com.sap.sdb.syncMan.gui.jface_viewer.ReplicationTableCellModifier;
import com.sap.sdb.syncMan.gui.jface_viewer.ReplicationTableContentProvider;
import com.sap.sdb.syncMan.gui.jface_viewer.ReplicationTableLabelProvider;
import com.sap.sdb.syncMan.gui.jface_viewer.UnitTableCellModifier;
import com.sap.sdb.syncMan.gui.jface_viewer.UnitTableContentProvider;
import com.sap.sdb.syncMan.gui.jface_viewer.UnitTableLabelProvider;
import com.sap.sdb.syncMan.gui.jface_viewer.UnitTreeContentProvider;
import com.sap.sdb.syncMan.gui.jface_viewer.UnitTreeLabelProvider;
import com.sap.sdb.syncMan.tool.ConDataBase;
import com.sap.sdb.syncMan.tool.ConMessageServer;
import com.sap.sdb.syncMan.tool.Resources;
import com.sap.sdb.syncMan.util.GenUID;
import com.sap.sdb.syncMan.util.SQLBuilder;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TreeItem;

public class UnitControl
extends SyncManControl {
    private Vector m_particpantsToWork;
    private WorkerThread _workerThread;
    private Button _unitTablesSetSchema;
    private Button _unitTableEdit;
    private Button _configEdit;
    private Table _replicationTable;
    private TableViewer _replicationTableViewer;
    private Table _unitTables;
    private TableViewer _unitTablesViewer;
    private Table _configTable;
    private TableViewer _configViewer;
    private UnitTable m_selectedUnitTable;
    private Participant m_selectedMasterParticipant;
    private TabItem _tabTable;
    private Composite _tableWidget;
    private Composite _participantWidget;
    private TabFolder _tabFolder;
    private ClassLoader m_classLoader = null;
    private Participant _tempRefresh;
    private static final String JNDI_HOST = "jndi.host";
    private static final String JMS_HOST = "jms.host";
    private static final String JNDI_PORT = "jndi.port";
    private static final String JMS_PORT = "jms.port";
    private String[] tableColumnNames = new String[]{Resources.getString("Units.Selected"), Resources.getString("Units.Column_Groups")};
    private String[] UnitTableColumnNames = new String[]{Resources.getString("Units.Table_Schema"), Resources.getString("Units.Table_Name")};
    private String[] participantConfigColumnNames = new String[]{Resources.getString("Config.Server"), Resources.getString("Config.Database"), Resources.getString("Config.UseSSL"), Resources.getString("Config.JDBC_Driver")};

    public UnitControl(SyncManGUI syncManGUI, SashForm parent) {
        super(syncManGUI, parent);
        this.m_particpantsToWork = new Vector();
        this.m_classLoader = ClassLoader.getSystemClassLoader();
        this.createContents();
    }

    private void createContents() {
        SashForm sashHorizontal = new SashForm((Composite)this, 512);
        SashForm compositeParticipants = new SashForm((Composite)sashHorizontal, 2048);
        SashForm compositeConfig = new SashForm((Composite)sashHorizontal, 2048);
        this._tree = new TreeViewer((Composite)compositeParticipants, 4);
        this._tree.setContentProvider((IContentProvider)new UnitTreeContentProvider(this));
        this._tree.setLabelProvider((IBaseLabelProvider)new UnitTreeLabelProvider());
        this._tree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                event.getSelection();
                try {
                    UnitControl.this.m_selectedUnitTable = null;
                    UnitControl.this.m_selectedParticipant = null;
                    UnitControl.this.m_selectedMasterParticipant = null;
                    UnitControl.this._tabTable.setText("");
                    UnitControl.this._tabTable.setControl(null);
                    TreeItem[] selections = UnitControl.this._tree.getTree().getSelection();
                    if (selections != null && selections.length > 0) {
                        Object temp = selections[0].getData();
                        if (temp instanceof UnitTable) {
                            UnitControl.this.m_selectedUnitTable = (UnitTable)temp;
                            UnitControl.this.m_selectedMasterParticipant = (Participant)selections[0].getParentItem().getParentItem().getData();
                            UnitControl.this._tabTable.setText(Resources.getString("Units.Table"));
                            UnitControl.this._tabTable.setControl((Control)UnitControl.this._tableWidget);
                            UnitControl.this.displayUnitTable(UnitControl.this.m_selectedUnitTable);
                        } else if (temp instanceof Participant) {
                            UnitControl.this.m_selectedParticipant = (Participant)temp;
                            UnitControl.this.m_selectedParticipant.setConfig(null);
                            if (UnitControl.this.m_selectedParticipant.isMaster() || UnitControl.this.m_selectedParticipant.isInstalled()) {
                                UnitControl.this._unitTableEdit.setText(Resources.getString("Units.Show_Unit_Table"));
                                if (UnitControl.this.m_selectedParticipant.isMaster()) {
                                    UnitControl.this.m_selectedMasterParticipant = UnitControl.this.m_selectedParticipant;
                                } else {
                                    UnitControl.this.m_selectedMasterParticipant = (Participant)selections[0].getParentItem().getParentItem().getData();
                                }
                                UnitControl.this._unitTablesSetSchema.setEnabled(false);
                            } else {
                                UnitControl.this._unitTableEdit.setText(Resources.getString("Units.Edit_Unit_Table"));
                                UnitControl.this.m_selectedMasterParticipant = (Participant)selections[0].getParentItem().getParentItem().getData();
                                UnitControl.this._unitTablesSetSchema.setEnabled(true);
                            }
                            UnitControl.this._tabTable.setText(Resources.getString("Units.Participant") + ": " + UnitControl.this.m_selectedParticipant.getParticipantName());
                            UnitControl.this._tabTable.setControl((Control)UnitControl.this._participantWidget);
                            UnitControl.this.displayUnitTables(UnitControl.this.m_selectedParticipant);
                        } else if (temp instanceof TablesNode) {
                            UnitControl.this.m_selectedMasterParticipant = ((TablesNode)temp).participantNode();
                        } else if (temp instanceof UnitsNode) {
                            UnitControl.this.m_selectedMasterParticipant = ((UnitsNode)temp).participantNode();
                        }
                    }
                }
                catch (Exception ex) {
                    SyncManControl.writeProt(ex);
                }
            }
        });
        this._tree.getTree().addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Point point = new Point(event.x, event.y);
                TreeItem item = UnitControl.this._tree.getTree().getItem(point);
                if (item != null && event.button == 3) {
                    Rectangle rect = item.getBounds();
                    point = new Point(rect.x, rect.y + rect.height);
                    Point pt = UnitControl.this._tree.getTree().toDisplay(point);
                    UnitControl.this.m_SyncManGUI.showReplicationUnitContextMenu(pt);
                }
            }
        });
        this.createUnitWidgets((Composite)compositeParticipants);
        this.createConfigWidgets((Composite)compositeConfig);
        int[] weightsVertical = new int[]{3, 1};
        sashHorizontal.setWeights(weightsVertical);
        this.checkWidgets();
    }

    public void drawControl() {
        this.drawTree();
        this.drawDepenendTables();
    }

    public void drawTree() {
        Control control = this._tree.getControl();
        if (control != null && !control.isDisposed()) {
            control.setRedraw(false);
            Object[] expandedObjs = this._tree.getExpandedElements();
            this._tree.setInput((Object)new Participant(-1L, -1L, "", -1, "", "", "", "", true, false));
            for (int i = 0; i < expandedObjs.length; ++i) {
                this._tree.setExpandedState(expandedObjs[i], true);
            }
            control.setRedraw(true);
        }
        this.checkWidgets();
    }

    public void drawDepenendTables() {
        this._configViewer.setInput((Object)new ParticipantConfig("", "", false, ""));
        this.checkConfigWidgets();
    }

    public void clearTree() {
        this._tree.setInput(null);
        this.checkWidgets();
    }

    private void createUnitWidgets(Composite parent) {
        this._tabFolder = new TabFolder(parent, 0);
        this._tabFolder.setLayoutData((Object)new GridData(1808));
        this._tableWidget = this.createTableWidgets((Composite)this._tabFolder);
        this._participantWidget = this.createParticipantWidgets((Composite)this._tabFolder);
        this._tabTable = new TabItem(this._tabFolder, 0);
    }

    private Composite createParticipantWidgets(Composite parent) {
        ScrolledComposite scrollParticipants = new ScrolledComposite(parent, 768);
        Composite participantComposite = new Composite((Composite)scrollParticipants, 0);
        scrollParticipants.setContent((Control)participantComposite);
        scrollParticipants.setExpandHorizontal(true);
        scrollParticipants.setExpandVertical(true);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = 1;
        participantComposite.setLayout((Layout)compositeLayout);
        Group groupParticipant = new Group(participantComposite, 0);
        groupParticipant.setText(Resources.getString("Units.Unit_Tables"));
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 2;
        groupLayout.horizontalSpacing = 20;
        groupParticipant.setLayout((Layout)groupLayout);
        GridData groupData = new GridData(1808);
        groupParticipant.setLayoutData((Object)groupData);
        this.createUnitTablesViewer(groupParticipant);
        this._unitTableEdit = new Button((Composite)groupParticipant, 8);
        this._unitTableEdit.setText(Resources.getString("Units.Edit_Unit_Table"));
        this._unitTableEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UnitControl.this.displayUnitTable();
            }
        });
        this._unitTablesSetSchema = new Button((Composite)groupParticipant, 8);
        this._unitTablesSetSchema.setText(Resources.getString("Units.Set_Unit_Table_Schema"));
        this._unitTablesSetSchema.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IInputValidator inputValidator = new IInputValidator(this){
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public String isValid(String newText) {
                        if (newText.length() < 1) {
                            return Resources.getString("Units.Enter_Valid_Schema");
                        }
                        return null;
                    }
                };
                InputDialog dialog = new InputDialog(UnitControl.this.getShell(), Resources.getString("Units.Set_Schema_Of_Tables"), Resources.getString("Units.Schema_Of_Tables"), Resources.getString("Units.New_Schema"), inputValidator);
                if (dialog.open() == 0) {
                    try {
                        DesignSQLLayer.setUnitTableSchemas(UnitControl.this.getConMetaData(), UnitControl.this.m_selectedParticipant.getParticipantID(), dialog.getValue());
                        SyncManGUI.commitConnection(UnitControl.this.getConMetaData());
                        UnitControl.this.displayUnitTables(UnitControl.this.m_selectedParticipant);
                    }
                    catch (SQLException ex) {
                        SyncManGUI.rollBackConnection(UnitControl.this.getConMetaData());
                        SyncManControl.writeProt(ex);
                    }
                }
            }
        });
        Point pt = participantComposite.computeSize(-1, -1);
        scrollParticipants.setMinWidth(pt.x);
        scrollParticipants.setMinHeight(pt.y);
        return scrollParticipants;
    }

    private Composite createTableWidgets(Composite parent) {
        ScrolledComposite scrollTableColumns = new ScrolledComposite(parent, 768);
        Composite table = new Composite((Composite)scrollTableColumns, 0);
        scrollTableColumns.setContent((Control)table);
        scrollTableColumns.setExpandHorizontal(true);
        scrollTableColumns.setExpandVertical(true);
        GridLayout gridLayoutMain = new GridLayout();
        gridLayoutMain.numColumns = 1;
        table.setLayout((Layout)gridLayoutMain);
        Group groupFilter = new Group(table, 0);
        groupFilter.setText(Resources.getString("Units.RepColTable"));
        this.createReplicationTableViewer(groupFilter);
        GridLayout gridLayoutColLists = new GridLayout();
        gridLayoutColLists.numColumns = 1;
        gridLayoutColLists.makeColumnsEqualWidth = true;
        groupFilter.setLayout((Layout)gridLayoutColLists);
        GridData groupData = new GridData(1808);
        groupFilter.setLayoutData((Object)groupData);
        Point pt = table.computeSize(-1, -1);
        scrollTableColumns.setMinWidth(pt.x);
        scrollTableColumns.setMinHeight(pt.y);
        return scrollTableColumns;
    }

    private Composite createConfigWidgets(Composite parent) {
        ScrolledComposite scrollConfig = new ScrolledComposite(parent, 768);
        Composite config = new Composite((Composite)scrollConfig, 0);
        scrollConfig.setContent((Control)config);
        scrollConfig.setExpandHorizontal(true);
        scrollConfig.setExpandVertical(true);
        GridLayout gridLayoutMain = new GridLayout();
        gridLayoutMain.numColumns = 1;
        config.setLayout((Layout)gridLayoutMain);
        Group groupConfig = new Group(config, 0);
        groupConfig.setText(Resources.getString("Config.Label"));
        GridLayout gridLayoutConfig = new GridLayout();
        gridLayoutConfig.numColumns = 2;
        groupConfig.setLayout((Layout)gridLayoutConfig);
        GridData groupData = new GridData(1808);
        groupConfig.setLayoutData((Object)groupData);
        this.createConfigViewer(groupConfig);
        this._configEdit = new Button((Composite)groupConfig, 8);
        this._configEdit.setText(Resources.getString("Units.Edit_Configuration"));
        this._configEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UnitControl.this.displayParticipantConfigDialog();
            }
        });
        Point pt = config.computeSize(-1, -1);
        scrollConfig.setMinWidth(pt.x);
        scrollConfig.setMinHeight(pt.y);
        return scrollConfig;
    }

    protected boolean displayParticipantConfigDialog() {
        ParticipantConfig config = null;
        int i = this._configViewer.getTable().getSelectionIndex();
        if (i >= 0) {
            config = (ParticipantConfig)this._configViewer.getElementAt(i);
            if (config == null) {
                return false;
            }
        } else {
            return false;
        }
        ParticipantConfigDialog dlg = new ParticipantConfigDialog(this.getShell(), this.getConMetaData(), config);
        if (dlg.open() == 0) {
            this.updateConfigViewer(config);
            return true;
        }
        return false;
    }

    private void createReplicationTable(Composite parent) {
        int style = 2820;
        this._replicationTable = new Table(parent, style);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.heightHint = this._replicationTable.getItemHeight() * 7;
        this._replicationTable.setLayoutData((Object)gridData);
        this._replicationTable.setLinesVisible(true);
        this._replicationTable.setHeaderVisible(true);
        TableColumn column = new TableColumn(this._replicationTable, 0x1000000, 0);
        column.setText("");
        column.setWidth(20);
        column = new TableColumn(this._replicationTable, 16384, 1);
        column.setText(this.tableColumnNames[1]);
        column.setWidth(400);
    }

    private void createTableForParticpiantTables(Composite parent) {
        int style = 101124;
        this._unitTables = new Table(parent, style);
        this._unitTables.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                UnitControl.this.displayUnitTable();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.heightHint = this._unitTables.getItemHeight() * 7;
        this._unitTables.setLayoutData((Object)gridData);
        this._unitTables.setLinesVisible(true);
        this._unitTables.setHeaderVisible(true);
        TableColumn column = new TableColumn(this._unitTables, 16384, 0);
        column.setText(this.UnitTableColumnNames[0]);
        column.setWidth(150);
        column = new TableColumn(this._unitTables, 16384, 1);
        column.setText(this.UnitTableColumnNames[1]);
        column.setWidth(150);
    }

    private void createTableForConfig(Composite parent) {
        int style = 68356;
        this._configTable = new Table(parent, style);
        this._configTable.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                UnitControl.this.displayParticipantConfigDialog();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.heightHint = this._configTable.getItemHeight() * 4;
        this._configTable.setLayoutData((Object)gridData);
        this._configTable.setLinesVisible(true);
        this._configTable.setHeaderVisible(true);
        TableColumn column = new TableColumn(this._configTable, 16384, 0);
        column.setText(this.participantConfigColumnNames[0]);
        column.setWidth(100);
        column = new TableColumn(this._configTable, 16384, 1);
        column.setText(this.participantConfigColumnNames[1]);
        column.setWidth(100);
        column = new TableColumn(this._configTable, 16384, 2);
        column.setText(this.participantConfigColumnNames[2]);
        column.setWidth(150);
        column = new TableColumn(this._configTable, 16386, 3);
        column.setText(this.participantConfigColumnNames[3]);
        column.setWidth(250);
    }

    private void createReplicationTableViewer(Group groupFilter) {
        this.createReplicationTable((Composite)groupFilter);
        this._replicationTableViewer = new TableViewer(this._replicationTable);
        this._replicationTableViewer.setUseHashlookup(true);
        this._replicationTableViewer.setColumnProperties(this.tableColumnNames);
        CellEditor[] editors = new CellEditor[]{new CheckboxCellEditor((Composite)this._replicationTable), null};
        this._replicationTableViewer.setCellEditors(editors);
        this._replicationTableViewer.setCellModifier((ICellModifier)new ReplicationTableCellModifier(this));
        this._replicationTableViewer.setContentProvider((IContentProvider)new ReplicationTableContentProvider(this));
        this._replicationTableViewer.setLabelProvider((IBaseLabelProvider)new ReplicationTableLabelProvider());
    }

    private void createUnitTablesViewer(Group groupTable) {
        this.createTableForParticpiantTables((Composite)groupTable);
        this._unitTablesViewer = new TableViewer(this._unitTables);
        this._unitTablesViewer.setUseHashlookup(true);
        this._unitTablesViewer.setColumnProperties(this.UnitTableColumnNames);
        CellEditor[] editors = new CellEditor[]{null, null};
        this._unitTablesViewer.setCellEditors(editors);
        this._unitTablesViewer.setCellModifier((ICellModifier)new UnitTableCellModifier(this));
        this._unitTablesViewer.setContentProvider((IContentProvider)new UnitTableContentProvider(this));
        this._unitTablesViewer.setLabelProvider((IBaseLabelProvider)new UnitTableLabelProvider());
    }

    private void createConfigViewer(Group groupConfig) {
        this.createTableForConfig((Composite)groupConfig);
        this._configViewer = new TableViewer(this._configTable);
        this._configViewer.setUseHashlookup(true);
        this._configViewer.setColumnProperties(this.participantConfigColumnNames);
        CellEditor[] editors = new CellEditor[4];
        editors[0] = null;
        editors[1] = null;
        editors[2] = null;
        this._configViewer.setCellEditors(editors);
        this._configViewer.setCellModifier((ICellModifier)new ParticipantConfigCellModifier(Arrays.asList(this.participantConfigColumnNames)));
        this._configViewer.setContentProvider((IContentProvider)new ParticipantConfigContentProvider(this.getConMetaData()));
        this._configViewer.setLabelProvider((IBaseLabelProvider)new ParticipantConfigLabelProvider());
    }

    private void displayUnitTables(Participant participant) {
        this.checkWidgets();
        if (participant == null) {
            return;
        }
        this._unitTablesViewer.setInput((Object)participant);
    }

    private void displayUnitTable(UnitTable table) {
        this.checkWidgets();
        if (table == null) {
            return;
        }
        this._replicationTableViewer.setInput((Object)table);
    }

    public void displayNewClientParticipantDialog() {
        if (this.m_selectedMasterParticipant == null) {
            return;
        }
        long unitID = GenUID.getNext();
        int newUnitType = this.m_selectedMasterParticipant.getParticipantType();
        if (this.m_selectedMasterParticipant.getParticipantType() == 2) {
            newUnitType = 2;
        } else if (this.m_selectedMasterParticipant.getParticipantType() == 1) {
            newUnitType = 0;
        } else if (this.m_selectedMasterParticipant.getParticipantType() == 0) {
            newUnitType = 1;
        }
        Participant participant = new Participant(this.m_selectedMasterParticipant.getDesignID(), unitID, "", newUnitType, "", "", "", "", false, false);
        ParticipantDialog dlg = new ParticipantDialog(this.getShell(), this.getConMetaData(), this._hostHistory, this._participantNameHistory, participant, 1);
        dlg.setBlockOnOpen(true);
        int returnCode = dlg.open();
        if (returnCode == 0) {
            this.refreshTree();
            this.drawDepenendTables();
        }
    }

    public void displayNewMasterUnitDialog() {
        long unitID = GenUID.getNext();
        Participant participant = new Participant(unitID, unitID, "", 2, this.getConMetaData().getHost(), this.getConMetaData().getDataBase(), this.getConMetaData().getUser(), "", true, false);
        ParticipantDialog dlg = new ParticipantDialog(this.getShell(), this.getConMetaData(), this._hostHistory, this._participantNameHistory, participant, 0);
        if (dlg != null) {
            dlg.setBlockOnOpen(true);
            int returnCode = dlg.open();
            if (returnCode == 0) {
                this.drawTree();
                this.drawDepenendTables();
            }
        }
    }

    public List getTableColumnNames() {
        return Arrays.asList(this.tableColumnNames);
    }

    public List getUnitTableColumnNames() {
        return Arrays.asList(this.UnitTableColumnNames);
    }

    public List getConfigColumnNames() {
        return Arrays.asList(this.participantConfigColumnNames);
    }

    public void updateTableViewer(ColumnGroup cg) {
        this.applyTableChanges();
        this._replicationTableViewer.update((Object)cg, null);
    }

    private void updateParticipantViewer(UnitTable table) {
        this._unitTablesViewer.update((Object)table, null);
    }

    private void updateConfigViewer(ParticipantConfig config) {
        this._configViewer.update((Object)config, null);
    }

    public UnitTable getSelectedUnitTable() {
        return this.m_selectedUnitTable;
    }

    public Participant getSelectedMasterParticipant() {
        return this.m_selectedMasterParticipant;
    }

    public Participant getSelectedParticipant() {
        return this.m_selectedParticipant;
    }

    private void applyTableChanges() {
        if (this.m_selectedUnitTable == null) {
            return;
        }
        try {
            long count = DesignSQLLayer.selectNumberOfInstalledParticipants(this.getConMetaData(), this.m_selectedUnitTable.getDesignID());
            if (count > 0L) {
                UnitControl.writeProt(Resources.getString("Units.Unit_Has") + count + Resources.getString("Units.Active_Participants"), true);
                SyncManGUI.rollBackConnection(this.getConMetaData());
                this.displayUnitTable(this.m_selectedUnitTable);
                return;
            }
            for (int i = 0; i < this.m_selectedUnitTable.getColumnGroups().size(); ++i) {
                ColumnGroup cg = (ColumnGroup)this.m_selectedUnitTable.getColumnGroups().get(i);
                DesignSQLLayer.alterColumnGroup(this.getConMetaData(), -1L, this.m_selectedUnitTable.getTableID(), cg);
            }
            SyncManGUI.commitConnection(this.getConMetaData());
        }
        catch (Exception ex) {
            UnitControl.writeProt(ex);
            SyncManGUI.rollBackConnection(this.getConMetaData());
        }
    }

    private boolean prepareActivateAllParticipants(boolean activate) throws Exception {
        this.m_particpantsToWork.removeAllElements();
        Vector masterParticipantNodes = DesignSQLLayer.selectParticipants(this.getConMetaData(), -1L, true, false);
        for (int j = 0; j < masterParticipantNodes.size(); ++j) {
            Participant masterParticipantNode = (Participant)masterParticipantNodes.get(j);
            Vector clientParticpantsToWork = DesignSQLLayer.selectParticipants(this.getConMetaData(), masterParticipantNode.getDesignID(), true, true);
            for (int i = 0; i < clientParticpantsToWork.size(); ++i) {
                Participant part = (Participant)clientParticpantsToWork.get(i);
                if (!(activate ^ part.isInstalled())) continue;
                if (!this.completeParticipantParameters(part)) {
                    this.m_particpantsToWork.removeAllElements();
                    return false;
                }
                this.m_particpantsToWork.add(part);
            }
        }
        return true;
    }

    private void internalActivateAllParticipants(boolean activate) throws Exception {
        ConDataBase dbTarget = new ConDataBase(this.m_SyncManGUI.getShell(), SyncManGUI.getSecurityProvider(), SyncManGUI.getSyncSchema(), false, true);
        for (int i = 0; i < this.m_particpantsToWork.size(); ++i) {
            Participant part = (Participant)this.m_particpantsToWork.get(i);
            if (activate) {
                if (!part.isInstalled()) {
                    UnitControl.internalActivateParticipant(this.getConMetaData(), dbTarget, part, activate);
                }
            } else if (part.isInstalled()) {
                UnitControl.internalActivateParticipant(this.getConMetaData(), dbTarget, part, activate);
            }
            this._tempRefresh = part;
            if (this.m_selectedMasterParticipant != null && this.m_selectedMasterParticipant.getParticipantID() == part.getParticipantID()) {
                this.m_selectedMasterParticipant = part;
            }
            if (this.m_selectedParticipant != null && this.m_selectedParticipant.getParticipantID() == part.getParticipantID()) {
                this.m_selectedParticipant = part;
            }
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (UnitControl.this._tempRefresh != null) {
                        UnitControl.this._tree.refresh((Object)UnitControl.this._tempRefresh);
                        UnitControl.this._tempRefresh = null;
                    }
                }
            });
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                UnitControl.this.checkWidgets();
            }
        });
        if (this.m_selectedParticipant != null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (UnitControl.this.m_selectedParticipant.isMaster() || UnitControl.this.m_selectedParticipant.isInstalled()) {
                        UnitControl.this._unitTableEdit.setText(Resources.getString("Units.Show_Unit_Table"));
                    } else {
                        UnitControl.this._unitTableEdit.setText(Resources.getString("Units.Edit_Unit_Table"));
                    }
                }
            });
        }
        UnitControl.updateMsgServerDestinations(this.getConMetaData(), this.getConMessageServer());
    }

    public void activateAllParticipants() {
        try {
            if (this.prepareActivateAllParticipants(true)) {
                UnitControl.writeProtAsync("Activate " + this.m_particpantsToWork.size() + " unit(s) ...", false);
                this._workerThread = new WorkerThread(this, 1);
                this._workerThread.start();
            }
        }
        catch (Exception ex) {
            UnitControl.writeProt(ex);
        }
    }

    public void deactivateAllParticipants() {
        try {
            if (this.prepareActivateAllParticipants(false)) {
                UnitControl.writeProtAsync("Deactivate " + this.m_particpantsToWork.size() + " unit(s) ...", false);
                this._workerThread = new WorkerThread(this, 2);
                this._workerThread.start();
            }
        }
        catch (Exception ex) {
            UnitControl.writeProt(ex);
        }
    }

    public void activateSelectedParticipant() {
        if (this.m_selectedParticipant == null) {
            return;
        }
        if (!(this.m_selectedParticipant.isMaster() || this.m_selectedParticipant.isInstalled() || this.m_selectedMasterParticipant != null && this.m_selectedMasterParticipant.isInstalled())) {
            UnitControl.writeProt(Resources.getString("Please_Activate_Master_Unit_First"), true);
            return;
        }
        try {
            if (!this.completeParticipantParameters(this.m_selectedParticipant)) {
                return;
            }
        }
        catch (Exception ex) {
            UnitControl.writeProt(ex);
        }
        this._workerThread = new WorkerThread(this, 0);
        this._workerThread.start();
    }

    private void internalActivateSelectedParticipant() throws Exception {
        ConDataBase dbTarget = new ConDataBase(this.m_SyncManGUI.getShell(), SyncManGUI.getSecurityProvider(), SyncManGUI.getSyncSchema(), false, true);
        UnitControl.internalActivateParticipant(this.getConMetaData(), dbTarget, this.m_selectedParticipant, !this.m_selectedParticipant.isInstalled());
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                UnitControl.this._tree.refresh((Object)UnitControl.this.m_selectedParticipant);
                if (UnitControl.this.m_selectedParticipant.isMaster() || UnitControl.this.m_selectedParticipant.isInstalled()) {
                    UnitControl.this._unitTableEdit.setText(Resources.getString("Units.Show_Unit_Table"));
                } else {
                    UnitControl.this._unitTableEdit.setText(Resources.getString("Units.Edit_Unit_Table"));
                }
                UnitControl.this.checkWidgets();
            }
        });
        if (this.m_selectedParticipant.isInstalled()) {
            if (this.getConMessageServer().isConnected()) {
                DesignSQLLayer.createOneDestination(this.getConMetaData(), this.getConMessageServer(), this.m_selectedParticipant, true);
                UnitControl.writeProtAsync(Resources.getString("MessageServer.Dest_Sync_Success"), false);
            } else {
                UnitControl.writeProtAsync(Resources.getString("MsgServer.Error.Destination") + ":" + Resources.getString("Message_Server_No_Connection"), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void internalActivateParticipant(ConDataBase dbSource, ConDataBase dbTarget, Participant part, boolean activate) throws SQLException {
        oldInstalled = part.isInstalled();
        try {
            block23: {
                if (!part.isMaster()) {
                    dbTarget.setJDBCDriver(part.getConfig().jdbcDriver());
                    dbTarget.connect(part.getHost(), part.getDataBase(), part.getUser(), part.getPassWord(), part.getConfig().getUseSSL());
                } else {
                    dbTarget = dbSource;
                }
                if (dbTarget.isConnected()) break block23;
                var7_5 = null;
                ** GOTO lbl66
            }
            if (!dbTarget.isMaxDB() && !dbTarget.isMinDB() && part.getParticipantType() != 1) {
                throw new Exception(Resources.getString("Units.Unit_Type_Not_Allowed_For_Database"));
            }
            part.setPassWord(dbTarget.getPassWord());
            if (!activate) {
                block22: {
                    try {
                        DesignSQLLayer.unInstallReplicationUnit(dbSource, dbTarget, part, true);
                    }
                    catch (SQLException ex) {
                        if (dbTarget.isMinDB()) break block22;
                        throw new SQLException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode());
                    }
                }
                UnitControl.writeProtAsync(Resources.getString("Units.Unit") + part.getParticipantName() + Resources.getString("Units.On") + dbTarget.getUrl() + Resources.getString("Units.Deactivated"), false);
            } else {
                DesignSQLLayer.installReplicationUnit(dbSource, dbTarget, part);
                UnitControl.writeProtAsync(Resources.getString("Units.Unit") + part.getParticipantName() + " (" + part.getParticipantID() + ") on " + dbTarget.getUrl() + Resources.getString("Units.Activated"), false);
                if (part.getConfig() == null) {
                    throw new Exception(Resources.getString("Units.No_Valid_Participant"));
                }
            }
            part.setIsInstalled(activate);
            DesignSQLLayer.alterInstalledFlagForParticipant(dbSource, part);
            if (!part.isMaster()) {
                dbTarget.getConnection().commit();
            }
            dbSource.getConnection().commit();
            ** GOTO lbl73
        }
        catch (Exception ex) {
            if (!part.isMaster()) {
                part.setPassWord("");
            }
            UnitControl.writeProtAsync(ex);
            part.setIsInstalled(oldInstalled);
            if (dbSource.isConnected()) {
                dbSource.getConnection().rollback();
            }
            if (!part.isMaster() && dbTarget.isConnected()) {
                dbTarget.getConnection().rollback();
            }
            var7_7 = null;
            try {
                if (part.isMaster() != false) return;
                dbTarget.disconnect();
                return;
            }
            catch (SQLException ex) {
                UnitControl.writeProtAsync(ex);
                return;
            }
        }
        {
            catch (Throwable var6_15) {
                var7_8 = null;
                ** try [egrp 3[TRYBLOCK] [7 : 430->444)] { 
lbl60:
                // 1 sources

                if (part.isMaster() != false) throw var6_15;
                dbTarget.disconnect();
                throw var6_15;
lbl63:
                // 1 sources

                catch (SQLException ex) {
                    UnitControl.writeProtAsync(ex);
                }
                throw var6_15;
            }
lbl66:
            // 1 sources

            ** try [egrp 3[TRYBLOCK] [7 : 430->444)] { 
lbl67:
            // 1 sources

            if (part.isMaster() != false) return;
            dbTarget.disconnect();
            return;
lbl70:
            // 1 sources

            catch (SQLException ex) {
                UnitControl.writeProtAsync(ex);
            }
            return;
lbl73:
            // 1 sources

            var7_6 = null;
            try {}
            catch (SQLException ex) {}
            UnitControl.writeProtAsync(ex);
            return;
            if (part.isMaster() != false) return;
            dbTarget.disconnect();
            return;
        }
    }

    public void deleteSelectedParticipant() {
        if (this.m_selectedParticipant != null && !this.m_selectedParticipant.isMaster()) {
            try {
                if (this.m_selectedParticipant.isInstalled()) {
                    UnitControl.writeProt(Resources.getString("Units.Client_Unit_Is_Active"), true);
                    return;
                }
                DesignSQLLayer.deleteParticipant(this.getConMetaData(), this.m_selectedParticipant);
                SyncManGUI.commitConnection(this.getConMetaData());
                this._tree.remove((Object)this.m_selectedParticipant);
                this.m_selectedParticipant = null;
                this.drawDepenendTables();
            }
            catch (Exception ex) {
                UnitControl.writeProt(ex);
                SyncManGUI.rollBackConnection(this.getConMetaData());
            }
        }
    }

    public void deleteUnitTable() {
        if (this.m_selectedUnitTable != null) {
            try {
                long count = DesignSQLLayer.selectNumberOfInstalledParticipants(this.getConMetaData(), this.m_selectedMasterParticipant.getDesignID());
                if (count > 0L) {
                    UnitControl.writeProt(Resources.getString("Units.Unit_Has") + count + Resources.getString("Units.Active_Participants"), true);
                    SyncManGUI.rollBackConnection(this.getConMetaData());
                    return;
                }
                DesignSQLLayer.deleteTablesOfDesignNode(this.getConMetaData(), this.m_selectedUnitTable.getDesignID(), this.m_selectedUnitTable.getTableID());
                SyncManGUI.commitConnection(this.getConMetaData());
                this._tree.remove((Object)this.m_selectedUnitTable);
            }
            catch (Exception ex) {
                UnitControl.writeProt(ex);
                SyncManGUI.rollBackConnection(this.getConMetaData());
            }
        }
    }

    public void deleteDesignNode() {
        if (this.m_selectedMasterParticipant != null) {
            try {
                long count = DesignSQLLayer.selectNumberOfInstalledParticipants(this.getConMetaData(), this.m_selectedMasterParticipant.getDesignID());
                if (count > 0L) {
                    UnitControl.writeProt(Resources.getString("Units.Unit_Has") + count + Resources.getString("Units.Active_Participants"), true);
                    SyncManGUI.rollBackConnection(this.getConMetaData());
                    return;
                }
                DesignSQLLayer.deleteUnitNode(this.getConMetaData(), this.m_selectedMasterParticipant.getDesignID());
                SyncManGUI.commitConnection(this.getConMetaData());
                this._tree.remove((Object)this.m_selectedMasterParticipant);
                this.m_selectedMasterParticipant = null;
                this.drawDepenendTables();
            }
            catch (Exception ex) {
                UnitControl.writeProt(ex);
                SyncManGUI.rollBackConnection(this.getConMetaData());
            }
        }
    }

    private void checkWidgets() {
        this.checkTableWidgets(this.m_selectedUnitTable);
        this.checkParticipantWidgets(this.m_selectedParticipant);
        this.checkConfigWidgets();
    }

    private void checkConfigWidgets() {
        boolean empty;
        boolean bl = empty = !this.getConMetaData().isConnected();
        if (empty) {
            this._configViewer.setInput(null);
        }
    }

    private void checkTableWidgets(UnitTable table) {
        boolean empty;
        boolean bl = empty = !this.getConMetaData().isConnected() || table == null;
        if (empty) {
            this._replicationTableViewer.setInput(null);
        }
        this._replicationTable.setEnabled(!empty);
    }

    private void checkParticipantWidgets(Participant part) {
        UnitTableCellModifier tmp;
        boolean empty;
        boolean isMaster = false;
        boolean bl = empty = !this.getConMetaData().isConnected() || part == null;
        if (empty) {
            this._unitTablesViewer.setInput(null);
        }
        if (part != null) {
            isMaster = part.isMaster();
        }
        if ((tmp = (UnitTableCellModifier)this._unitTablesViewer.getCellModifier()) != null) {
            tmp.setReadOnly(isMaster || part == null || part.isInstalled());
        }
        this._unitTables.setEnabled(!empty);
        this._unitTableEdit.setEnabled(!empty);
    }

    private boolean displayUnitTable() {
        UnitTable table = null;
        int i = this._unitTablesViewer.getTable().getSelectionIndex();
        if (i >= 0) {
            table = (UnitTable)this._unitTablesViewer.getElementAt(i);
            if (table == null) {
                return false;
            }
        } else {
            return false;
        }
        ReplicationTablePropertiesDialog dlg = new ReplicationTablePropertiesDialog(this.getShell(), this.getConMetaData(), table, this.m_selectedParticipant.isInstalled() || table.getIsMasterTable());
        if (dlg.open() == 0) {
            this.updateParticipantViewer(table);
            return true;
        }
        return false;
    }

    public void displayImportRepTableDialog() {
        if (this.m_selectedMasterParticipant == null) {
            UnitControl.writeProt(Resources.getString("Units.No_Unit_Nodem_selected"), true);
            return;
        }
        try {
            long count = DesignSQLLayer.selectNumberOfInstalledParticipants(this.getConMetaData(), this.m_selectedMasterParticipant.getDesignID());
            if (count > 0L) {
                UnitControl.writeProt(Resources.getString("Units.Adding_Tables_Not_Possible") + Resources.getString("Units.Unit_Has") + count + Resources.getString("Units.Active_Participants"), true);
                SyncManGUI.rollBackConnection(this.getConMetaData());
                return;
            }
        }
        catch (SQLException e) {
            UnitControl.writeProt(e);
            return;
        }
        ReplicationTableDialog dlg = new ReplicationTableDialog(this.getShell(), this.getConMetaData(), this.m_selectedMasterParticipant);
        if (dlg != null) {
            dlg.setBlockOnOpen(true);
            int returnCode = dlg.open();
            if (returnCode == 0) {
                this.refreshTree();
            }
        }
    }

    public void reSyncClient() {
        this._workerThread = new WorkerThread(this, 3);
        this._workerThread.start();
    }

    private void internalReSyncClient() {
        if (this.m_selectedParticipant == null) {
            return;
        }
        if (!this.m_selectedParticipant.isInstalled()) {
            return;
        }
        if (this.m_selectedMasterParticipant == null) {
            return;
        }
        if (!this.getConMessageServer().isConnected()) {
            return;
        }
        String info = Resources.getString("Units.Synchronize_Client_Unit") + " '" + this.m_selectedParticipant.getParticipantName() + "'";
        UnitControl.writeProtAsync(info + " ...", false);
        info = info + ": ";
        try {
            long msgCount;
            Properties prop = new Properties();
            InputStream is = this.m_classLoader.getResourceAsStream("jndi.properties");
            prop.load(is);
            prop.put(JNDI_HOST, this.getConMessageServer().getJndiHost());
            prop.put(JMS_HOST, this.getConMessageServer().getMsgHost());
            prop.put(JNDI_PORT, Integer.toString(this.getConMessageServer().getJndiPort()));
            prop.put(JMS_PORT, Integer.toString(this.getConMessageServer().getMsgPort()));
            if (this.m_selectedMasterParticipant.getPassWord() == null || this.m_selectedMasterParticipant.getPassWord().length() < 1) {
                this.m_selectedMasterParticipant.setPassWord(this.getConMetaData().getPassWord());
            }
            if ((msgCount = CaptureManager.doInitialClientCopy((Properties)prop, (String)this.getConMetaData().getJDBCDriver(), (String)this.getConMetaData().getConnectString(), (String)this.m_selectedMasterParticipant.getUser(), (String)this.m_selectedMasterParticipant.getPassWord(), (long)this.m_selectedParticipant.getParticipantID(), (String)this.m_selectedMasterParticipant.getParticipantName(), (boolean)false, (int)3)) == 1L) {
                UnitControl.writeProtAsync(info + Resources.getString("Units.One_Message_Sent"), false);
            } else {
                UnitControl.writeProtAsync(info + msgCount + Resources.getString("Units.Messages_Sent"), false);
            }
        }
        catch (Exception ex) {
            UnitControl.writeProtAsync(info + ex.toString(), true);
        }
    }

    private void internalInitVersionTable() {
        if (this.m_selectedParticipant == null) {
            return;
        }
        if (!this.m_selectedParticipant.isInstalled()) {
            return;
        }
        if (!this.m_selectedParticipant.isMaster()) {
            return;
        }
        String info = Resources.getString("InitMasterVersions") + " '" + this.m_selectedParticipant.getParticipantName() + "'";
        UnitControl.writeProtAsync(info + " ...", false);
        info = info + ": ";
        try {
            if (!DesignSQLLayer.checkParticipantParameters(this.getConMetaData(), this.m_selectedParticipant)) {
                SQLBuilder.writeProt((String)(Resources.getString("Insufficient_Connect_Parameter") + " " + this.m_selectedParticipant.getParticipantName()), (boolean)true);
                return;
            }
            long createdVersions = CaptureManager.initRowVersions((String)this.getConMetaData().getJDBCDriver(), (String)this.getConMetaData().getConnectString(), (String)this.m_selectedParticipant.getUser(), (String)this.m_selectedParticipant.getPassWord(), (String)this.m_selectedParticipant.getParticipantName(), (int)3);
            if (createdVersions == 1L) {
                UnitControl.writeProtAsync(info + Resources.getString("Units.One_Version_Entry_Inserted"), false);
            } else {
                UnitControl.writeProtAsync(info + createdVersions + Resources.getString("Units.Versions_Entries_Inserted"), false);
            }
        }
        catch (Exception ex) {
            UnitControl.writeProtAsync(info + ex.toString(), true);
        }
    }

    private void refreshTree() {
        Control control = this._tree.getControl();
        if (control != null && !control.isDisposed()) {
            control.setRedraw(false);
            TreeItem[] item = this._tree.getTree().getSelection();
            if (item != null && item.length > 0) {
                boolean isExpanded = false;
                Object temp = item[0].getData();
                if (temp instanceof Participant) {
                    if (((Participant)temp).isMaster()) {
                        int i;
                        isExpanded = item[0].getExpanded();
                        TreeItem[] childs = item[0].getItems();
                        boolean[] childexpand = new boolean[childs.length];
                        for (i = 0; i < childs.length; ++i) {
                            childexpand[i] = childs[i].getExpanded();
                        }
                        this._tree.refresh(temp);
                        item[0].setExpanded(isExpanded);
                        for (i = 0; i < childs.length; ++i) {
                            this._tree.refresh(childs[i].getData());
                            childs[i].setExpanded(childexpand[i]);
                        }
                    } else {
                        isExpanded = item[0].getParentItem().getExpanded();
                        this._tree.refresh(item[0].getParentItem().getData());
                        item[0].getParentItem().setExpanded(isExpanded);
                    }
                } else if (temp instanceof UnitTable) {
                    isExpanded = item[0].getParentItem().getExpanded();
                    this._tree.refresh(item[0].getParentItem().getData());
                    item[0].getParentItem().setExpanded(isExpanded);
                } else if (temp instanceof TablesNode || temp instanceof UnitsNode) {
                    isExpanded = item[0].getExpanded();
                    this._tree.refresh(temp);
                    item[0].setExpanded(isExpanded);
                }
            }
        }
        control.setRedraw(true);
    }

    public synchronized boolean isAsyncWorking() {
        return this._workerThread != null && this._workerThread.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateMsgServerDestinations(ConDataBase dbCon, ConMessageServer msCon) {
        if (!msCon.isConnected()) {
            UnitControl.writeProtAsync(Resources.getString("MsgServer.Error.Destination") + ":" + Resources.getString("Message_Server_No_Connection"), true);
            return;
        }
        try {
            DesignSQLLayer.createDestinations(dbCon, msCon, true);
            UnitControl.writeProtAsync(Resources.getString("MessageServer.Created_destinations_on_message_server"), false);
            UnitControl.writeProtAsync(Resources.getString("MessageServer.Dest_Sync_Success"), false);
        }
        catch (Exception ex) {
            UnitControl.writeProtAsync(ex);
        }
        finally {
            SyncManGUI.commitConnection(dbCon);
        }
    }

    private boolean completeParticipantParameters(Participant part) throws SQLException {
        part.setConfig(null);
        if (!DesignSQLLayer.checkParticipantParameters(this.getConMetaData(), part)) {
            this.displayParticipantDialog(part, true);
        }
        if (!DesignSQLLayer.checkParticipantParameters(this.getConMetaData(), part)) {
            SQLBuilder.writeProt((String)(Resources.getString("Insufficient_Connect_Parameter") + " " + part.getParticipantName()), (boolean)true);
            return false;
        }
        return true;
    }

    public static void activateParticipant(ConDataBase dbSource, ConDataBase dbTarget, Participant part, boolean activate) throws SQLException {
        if (!DesignSQLLayer.checkParticipantParameters(dbSource, part)) {
            UnitControl.writeProt(Resources.getString("Insufficient_Connect_Parameter") + part.getParticipantName(), true);
            return;
        }
        UnitControl.internalActivateParticipant(dbSource, dbTarget, part, activate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initClientVersionWithLoader() {
        if (!this.getConMetaData().isMaxDB()) {
            UnitControl.writeProt(Resources.getString("Loader.Usage"), true);
            return;
        }
        dbTarget = new ConDataBase(this.m_SyncManGUI.getShell(), SyncManGUI.getSecurityProvider(), SyncManGUI.getSyncSchema(), false, true);
        clientLoader = null;
        masterLoader = null;
        loaderClientProperties = null;
        loaderMasterProperties = null;
        try {
            block56: {
                block55: {
                    if (this.completeParticipantParameters(this.m_selectedParticipant)) break block55;
                    UnitControl.writeProt(Resources.getString("Insufficient_Connect_Parameter") + this.m_selectedParticipant.getParticipantName(), true);
                    var23_6 = null;
                    ** GOTO lbl195
                }
                dbTarget.setJDBCDriver(this.m_selectedParticipant.getConfig().jdbcDriver());
                dbTarget.connect(this.m_selectedParticipant.getHost(), this.m_selectedParticipant.getDataBase(), this.m_selectedParticipant.getUser(), this.m_selectedParticipant.getPassWord(), this.m_selectedParticipant.getConfig().getUseSSL());
                if (dbTarget.isMaxDB()) break block56;
                UnitControl.writeProt(Resources.getString("Loader.Usage"), true);
                ** GOTO lbl211
            }
            loaderMasterProperties = new Properties();
            loaderMasterProperties.setProperty("dbname", this.getConMetaData().getDataBase());
            loaderMasterProperties.setProperty("host", this.getConMetaData().getHost());
            loaderClientProperties = new Properties();
            loaderClientProperties.setProperty("dbname", this.m_selectedParticipant.getDataBase());
            loaderClientProperties.setProperty("host", this.m_selectedParticipant.getHost());
            masterTables = DesignSQLLayer.selectUnitTables(this.getConMetaData(), this.m_selectedMasterParticipant.getDesignID(), this.m_selectedMasterParticipant.getParticipantID());
            UnitControl.writeProt("Starting Export/Import ...", false);
            try {
                masterLoader = new Loader(loaderMasterProperties);
            }
            catch (RTEException ex2) {
                UnitControl.writeProt("Could not create loader object due to: " + ex2.toString(), true);
                dbTarget.disconnect();
                var23_8 = null;
                try {
                    if (dbTarget != null) {
                        try {
                            dbTarget.disconnect();
                        }
                        catch (SQLException ex) {
                            // empty catch block
                        }
                    }
                    if (masterLoader != null) {
                        masterLoader.release();
                    }
                    if (clientLoader == null) return;
                    clientLoader.release();
                    return;
                }
                catch (RTEException e) {
                    UnitControl.writeProt((Exception)e);
                }
                return;
            }
            try {
                clientLoader = new Loader(loaderClientProperties);
            }
            catch (RTEException ex2) {
                block49: {
                    UnitControl.writeProt("Could not create loader object due to: " + ex2.toString(), true);
                    dbTarget.disconnect();
                    var23_9 = null;
                    ** try [egrp 4[TRYBLOCK] [15 : 1685->1717)] { 
lbl69:
                    // 1 sources

                    if (dbTarget != null) {
                        ** try [egrp 5[TRYBLOCK] [14 : 1689->1696)] { 
lbl71:
                        // 1 sources

                        dbTarget.disconnect();
                        break block49;
lbl73:
                        // 1 sources

                        catch (SQLException ex) {
                            // empty catch block
                        }
                    }
                }
                if (masterLoader != null) {
                    masterLoader.release();
                }
                if (clientLoader == null) return;
                clientLoader.release();
                return;
lbl81:
                // 1 sources

                catch (RTEException e) {
                    UnitControl.writeProt((Exception)e);
                }
                return;
            }
            versionColCount = 0;
            cmdVersion = "use user " + this.getConMetaData().getUser() + " " + this.getConMetaData().getPassWord() + " serverdb " + this.getConMetaData().getDataBase();
            UnitControl.writeProt(cmdVersion, false);
            masterLoader.cmd(cmdVersion);
            for (i = 0; i < masterTables.size(); ++i) {
                j = 0;
                utMaster = (UnitTable)masterTables.get(i);
                utClient = DesignSQLLayer.selectUnitTable(this.getConMetaData(), this.m_selectedParticipant.getDesignID(), this.m_selectedParticipant.getParticipantID(), utMaster.getTableID());
                utClient.loadColumns(this.getConMetaData());
                clientColumns = utClient.getColumns();
                cmdVersion = "SET FORMAT ISO";
                masterLoader.cmd(cmdVersion);
                where = " WHERE ";
                oneWhere = false;
                cmdVersion = "DATAEXTRACT ";
                dbTableID = DesignSQLLayer.selectTableID(this.getConMetaData(), utMaster.getSchema(), utMaster.getName());
                vTable = "SYNCHRONIZATIONSERVICE.\"_R_V_" + dbTableID + "\"";
                mTable = utMaster.getSchema() + ".\"" + utMaster.getName() + "\"";
                keyWhere = null;
                for (j = 0; j < clientColumns.size(); ++j) {
                    col = (Column)clientColumns.get(j);
                    if (col.keyPos() > 0) {
                        cmdVersion = cmdVersion + "\"_" + col.masterColumnName() + "\",";
                        keyWhere = mTable + ".\"" + col.masterColumnName() + "\" = " + vTable + ".\"_" + col.masterColumnName() + "\"";
                    }
                    if ((tmp = ((Column)clientColumns.get(j)).getConstaintExpression()).trim().length() <= 1) continue;
                    if (!oneWhere) {
                        oneWhere = true;
                    }
                    where = where + "\"" + col.masterColumnName() + "\" " + tmp + "and ";
                }
                cmdVersion = cmdVersion.substring(0, cmdVersion.length() - 1);
                cmdVersion = cmdVersion + ",ROW_CREATOR,ROW_VERSION,LAST_UPDATER,COL_GROUP_VERSION";
                cmdVersion = cmdVersion + " FROM " + vTable;
                if (oneWhere) {
                    cmdVersion = cmdVersion + "," + mTable;
                }
                if (oneWhere) {
                    cmdVersion = cmdVersion + where.substring(0, where.length()) + keyWhere;
                }
                cmdVersion = cmdVersion + " OUTFIELDS ";
                versionColCount = 0;
                for (j = 0; j < clientColumns.size(); ++j) {
                    col = (Column)clientColumns.get(j);
                    if (col.keyPos() <= 0) continue;
                    ++versionColCount;
                    cmdVersion = cmdVersion + " \"_" + col.masterColumnName() + "\" " + (j + 1);
                }
                cmdVersion = cmdVersion + " ROW_CREATOR " + Integer.toString(versionColCount + 1) + " " + "ROW_VERSION" + " " + Integer.toString(versionColCount + 2) + " " + "LAST_UPDATER" + " " + Integer.toString(versionColCount + 3) + " " + "COL_GROUP_VERSION" + " " + Integer.toString(versionColCount + 4);
                cmdVersion = cmdVersion + " OUTSTREAM FILE 'my_file_version' RECORDS";
                UnitControl.writeProt(cmdVersion, false);
                masterLoader.cmd(cmdVersion);
                cmdVersion = "use user " + this.m_selectedParticipant.getUser() + " " + this.m_selectedParticipant.getPassWord() + " serverdb " + this.m_selectedParticipant.getDataBase();
                UnitControl.writeProt(cmdVersion, false);
                clientLoader.cmd(cmdVersion);
                dbTableID = DesignSQLLayer.selectTableID(dbTarget, utClient.getSchema(), utClient.getName());
                cmdVersion = "IMPORT TABLE SYNCHRONIZATIONSERVICE.\"_R_V_" + dbTableID + "\"";
                cmdVersion = cmdVersion + " DATA INSTREAM FILE 'my_file_version' RECORDS";
                versionColCount = 0;
                for (j = 0; j < clientColumns.size(); ++j) {
                    col = (Column)clientColumns.get(j);
                    if (col.keyPos() <= 0) continue;
                    ++versionColCount;
                    cmdVersion = cmdVersion + " \"_" + col.columnName() + "\" " + (j + 1);
                }
                cmdVersion = cmdVersion + " ROW_CREATOR " + Integer.toString(versionColCount + 1) + " " + "ROW_VERSION" + " " + Integer.toString(versionColCount + 2) + " " + "LAST_UPDATER" + " " + Integer.toString(versionColCount + 3) + " " + "COL_GROUP_VERSION" + " " + Integer.toString(versionColCount + 4);
                UnitControl.writeProt(cmdVersion, false);
                clientLoader.cmd(cmdVersion);
            }
            UnitControl.writeProt("Export/Import finished", false);
            ** GOTO lbl228
        }
        catch (Exception ex) {
            block50: {
                UnitControl.writeProt(ex);
                var23_11 = null;
                try {}
                catch (RTEException e) {
                    UnitControl.writeProt((Exception)e);
                    return;
                }
                if (dbTarget != null) {
                    ** try [egrp 5[TRYBLOCK] [14 : 1689->1696)] { 
lbl166:
                    // 1 sources

                    dbTarget.disconnect();
                    break block50;
lbl168:
                    // 1 sources

                    catch (SQLException ex) {
                        // empty catch block
                    }
                }
            }
            if (masterLoader != null) {
                masterLoader.release();
            }
            if (clientLoader == null) return;
            clientLoader.release();
            return;
        }
        {
            block54: {
                block53: {
                    block52: {
                        catch (Throwable var22_46) {
                            block51: {
                                var23_12 = null;
                                ** try [egrp 4[TRYBLOCK] [15 : 1685->1717)] { 
lbl180:
                                // 1 sources

                                if (dbTarget != null) {
                                    ** try [egrp 5[TRYBLOCK] [14 : 1689->1696)] { 
lbl182:
                                    // 1 sources

                                    dbTarget.disconnect();
                                    break block51;
lbl184:
                                    // 1 sources

                                    catch (SQLException ex) {
                                        // empty catch block
                                    }
                                }
                            }
                            if (masterLoader != null) {
                                masterLoader.release();
                            }
                            if (clientLoader == null) throw var22_46;
                            clientLoader.release();
                            throw var22_46;
lbl192:
                            // 1 sources

                            catch (RTEException e) {
                                UnitControl.writeProt((Exception)e);
                            }
                            throw var22_46;
                        }
lbl195:
                        // 1 sources

                        ** try [egrp 4[TRYBLOCK] [15 : 1685->1717)] { 
lbl196:
                        // 1 sources

                        if (dbTarget != null) {
                            ** try [egrp 5[TRYBLOCK] [14 : 1689->1696)] { 
lbl198:
                            // 1 sources

                            dbTarget.disconnect();
                            break block52;
lbl200:
                            // 1 sources

                            catch (SQLException ex) {
                                // empty catch block
                            }
                        }
                    }
                    if (masterLoader != null) {
                        masterLoader.release();
                    }
                    if (clientLoader == null) return;
                    clientLoader.release();
                    return;
lbl208:
                    // 1 sources

                    catch (RTEException e) {
                        UnitControl.writeProt((Exception)e);
                    }
                    return;
lbl211:
                    // 1 sources

                    var23_7 = null;
                    ** try [egrp 4[TRYBLOCK] [15 : 1685->1717)] { 
lbl213:
                    // 1 sources

                    if (dbTarget != null) {
                        ** try [egrp 5[TRYBLOCK] [14 : 1689->1696)] { 
lbl215:
                        // 1 sources

                        dbTarget.disconnect();
                        break block53;
lbl217:
                        // 1 sources

                        catch (SQLException ex) {
                            // empty catch block
                        }
                    }
                }
                if (masterLoader != null) {
                    masterLoader.release();
                }
                if (clientLoader == null) return;
                clientLoader.release();
                return;
lbl225:
                // 1 sources

                catch (RTEException e) {
                    UnitControl.writeProt((Exception)e);
                }
                return;
lbl228:
                // 1 sources

                var23_10 = null;
                try {}
                catch (RTEException e) {}
                UnitControl.writeProt((Exception)e);
                return;
                if (dbTarget != null) {
                    ** try [egrp 5[TRYBLOCK] [14 : 1689->1696)] { 
lbl235:
                    // 1 sources

                    dbTarget.disconnect();
                    break block54;
lbl237:
                    // 1 sources

                    catch (SQLException ex) {
                        // empty catch block
                    }
                }
            }
            if (masterLoader != null) {
                masterLoader.release();
            }
            if (clientLoader == null) return;
            clientLoader.release();
            return;
        }
    }

    public void initVersionTable() {
        this._workerThread = new WorkerThread(this, 4);
        this._workerThread.start();
    }

    private class WorkerThread
    extends Thread {
        private UnitControl _parent;
        private int _actionType;
        private static final int ACTIVATE_PARTICIPANT = 0;
        private static final int ACTIVATE_ALL_PARTICIPANT = 1;
        private static final int DEACTIVATE_ALL_PARTICIPANT = 2;
        private static final int RE_SYNC_CLIENT = 3;
        private static final int INIT_VERSION_TABLE = 4;

        private WorkerThread(UnitControl parent, int actionType) {
            super(Resources.getString("Units.WorkerThread") + " " + actionType);
            this._parent = parent;
            this._actionType = actionType;
        }

        public void run() {
            try {
                if (this._actionType == 0) {
                    this._parent.internalActivateSelectedParticipant();
                } else if (this._actionType == 3) {
                    this._parent.internalReSyncClient();
                } else if (this._actionType == 1) {
                    this._parent.internalActivateAllParticipants(true);
                } else if (this._actionType == 2) {
                    this._parent.internalActivateAllParticipants(false);
                } else if (this._actionType == 4) {
                    this._parent.internalInitVersionTable();
                } else {
                    SyncManControl.writeProtAsync(Resources.getString("No_Valid_Action"), true);
                }
            }
            catch (Exception ex) {
                SyncManControl.writeProtAsync(ex);
            }
        }
    }
}

