/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.gui.jface_controls;

import com.sap.sdb.syncMan.design.DesignSQLLayer;
import com.sap.sdb.syncMan.design.Participant;
import com.sap.sdb.syncMan.gui.SyncManGUI;
import com.sap.sdb.syncMan.gui.jface_dialog.ParticipantDialog;
import com.sap.sdb.syncMan.tool.ConDataBase;
import com.sap.sdb.syncMan.tool.ConMessageServer;
import com.sap.sdb.syncMan.util.SQLBuilder;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;

public abstract class SyncManControl
extends SashForm {
    protected SyncManGUI m_SyncManGUI;
    Hashtable _hostHistory;
    Hashtable _participantNameHistory;
    protected TreeViewer _tree;
    protected Participant m_selectedParticipant;

    public SyncManControl(SyncManGUI syncManGUI, SashForm parent) {
        super((Composite)parent, 256);
        this.m_SyncManGUI = syncManGUI;
        this._hostHistory = new Hashtable();
        this._participantNameHistory = new Hashtable();
    }

    public static void writeProt(Exception ex) {
        SQLBuilder.writeProt((Exception)ex);
    }

    public static void writeProtAsync(Exception ex) {
        SQLBuilder.writeProtAsync((Exception)ex);
    }

    public static void writeProt(String text, boolean color) {
        SQLBuilder.writeProt((String)text, (boolean)color);
    }

    public static void writeProtAsync(String text, boolean color) {
        SQLBuilder.writeProtAsync((String)text, (boolean)color);
    }

    public abstract void drawTree();

    public abstract void clearTree();

    protected abstract void drawDepenendTables();

    public ConDataBase getConMetaData() {
        return this.m_SyncManGUI.getConMetaData();
    }

    public ConMessageServer getConMessageServer() {
        return this.m_SyncManGUI.getConMessageServer();
    }

    public void displayParticipantDialog(Participant participant, boolean askForPassWord) {
        ParticipantDialog dlg;
        if (participant == null) {
            return;
        }
        if (!askForPassWord) {
            try {
                Participant masterParticipant = null;
                participant = DesignSQLLayer.selectParticipant(this.getConMetaData(), participant.getParticipantID());
                Vector masterParticipants = DesignSQLLayer.selectParticipants(this.getConMetaData(), participant.getDesignID(), true, false);
                if (masterParticipants.size() == 1) {
                    masterParticipant = (Participant)masterParticipants.get(0);
                    participant.setMasterParticipantType(masterParticipant.getParticipantType());
                }
            }
            catch (SQLException ex) {
                SQLBuilder.writeProt((Exception)ex);
                SyncManGUI.rollBackConnection(this.getConMetaData());
            }
        }
        if (participant.isMaster()) {
            dlg = new ParticipantDialog(this.getShell(), this.getConMetaData(), this._hostHistory, this._participantNameHistory, participant, askForPassWord ? 4 : 3);
            if (dlg != null) {
                dlg.setBlockOnOpen(true);
                int returnCode = dlg.open();
                if (returnCode == 0) {
                    this._tree.update((Object)participant, null);
                    this.m_selectedParticipant = participant;
                    this.drawDepenendTables();
                }
            }
        } else {
            dlg = new ParticipantDialog(this.getShell(), this.getConMetaData(), this._hostHistory, this._participantNameHistory, participant, askForPassWord ? 4 : 2);
            dlg.setBlockOnOpen(true);
            int returnCode = dlg.open();
            if (returnCode == 0) {
                this._tree.update((Object)participant, null);
                this.m_selectedParticipant = participant;
                this.drawDepenendTables();
            }
        }
    }
}

