/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.gui;

import com.sap.sdb.programmargs.AccParams;
import com.sap.sdb.programmargs.PasswordPrompt;
import com.sap.sdb.syncMan.design.DesignSQLLayer;
import com.sap.sdb.syncMan.design.Participant;
import com.sap.sdb.syncMan.gui.SyncGUIParams;
import com.sap.sdb.syncMan.gui.jface_controls.MonitorControl;
import com.sap.sdb.syncMan.gui.jface_controls.ReplicationTableControl;
import com.sap.sdb.syncMan.gui.jface_controls.UnitControl;
import com.sap.sdb.syncMan.gui.jface_menu.AboutAction;
import com.sap.sdb.syncMan.gui.jface_menu.ActivateAllParticipantsAction;
import com.sap.sdb.syncMan.gui.jface_menu.ActivateParticipantAction;
import com.sap.sdb.syncMan.gui.jface_menu.ClearLogWindowAction;
import com.sap.sdb.syncMan.gui.jface_menu.DBConnectAction;
import com.sap.sdb.syncMan.gui.jface_menu.DeactivateAllParticipantsAction;
import com.sap.sdb.syncMan.gui.jface_menu.DeactivateDestinationAction;
import com.sap.sdb.syncMan.gui.jface_menu.DeleteDestinationAction;
import com.sap.sdb.syncMan.gui.jface_menu.DeleteParticipantAction;
import com.sap.sdb.syncMan.gui.jface_menu.DeleteRepUnitAction;
import com.sap.sdb.syncMan.gui.jface_menu.DeleteTableAction;
import com.sap.sdb.syncMan.gui.jface_menu.DeleteUnitTableAction;
import com.sap.sdb.syncMan.gui.jface_menu.ExitAction;
import com.sap.sdb.syncMan.gui.jface_menu.GetMessagesAction;
import com.sap.sdb.syncMan.gui.jface_menu.InitClientVersionWithLoaderAction;
import com.sap.sdb.syncMan.gui.jface_menu.InitVersionTableAction;
import com.sap.sdb.syncMan.gui.jface_menu.MSConnectAction;
import com.sap.sdb.syncMan.gui.jface_menu.MessageServerDebugOptions;
import com.sap.sdb.syncMan.gui.jface_menu.NewParticipantAction;
import com.sap.sdb.syncMan.gui.jface_menu.NewRepUnitAction;
import com.sap.sdb.syncMan.gui.jface_menu.ParticipantPropertiesAction;
import com.sap.sdb.syncMan.gui.jface_menu.ReSyncUnitAction;
import com.sap.sdb.syncMan.gui.jface_menu.RepTableAddAction;
import com.sap.sdb.syncMan.gui.jface_menu.RepTableDeleteAction;
import com.sap.sdb.syncMan.gui.jface_menu.RepTableToUnitAction;
import com.sap.sdb.syncMan.gui.jface_menu.ShowMSStatusAction;
import com.sap.sdb.syncMan.gui.jface_menu.SyncDestinationAction;
import com.sap.sdb.syncMan.tool.ConDataBase;
import com.sap.sdb.syncMan.tool.ConMessageServer;
import com.sap.sdb.syncMan.tool.ProtocolViewer;
import com.sap.sdb.syncMan.tool.Resources;
import com.sap.sdb.syncMan.util.SQLBuilder;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class SyncManGUI
extends ApplicationWindow {
    private static final String DB_HOST = "-database_host";
    private static final String DB_NAME = "-database_name";
    private static final String USER = "-user";
    private static final String PASSWORD = "-password";
    private static final String ACCESS_KEY = "-access_key";
    private static final String DB_ENCRYPTION = "-database_encryption";
    private static final String MSG_ENCRYPTION = "-msgserver_encryption";
    private static final String MSG_SERVER = "-msgserver_host";
    private static final String JNDI_SERVER = "-jndiserver_host";
    private static final String MSG_SERVER_PORT = "-msgserver_port";
    private static final String JNDI_SERVER_PORT = "-jndiserver_port";
    private static final String MSG_SERVER_ADMIN_PORT = "-msgserver_admin_port";
    private static final String MSG_SERVER_PASSWORD = "-msgserver_password";
    private static final String SECURITY_PROVIDER = "-security_provider";
    private static final String HELP1 = "-help";
    private static final String HELP2 = "-h";
    private static final String HELP3 = "-?";
    static String cmd_host = null;
    static String cmd_database = null;
    static String cmd_additionalURL = null;
    static String cmd_user = null;
    static String cmd_password = null;
    static String cmd_db_ssl = null;
    static String cmd_ms_password = null;
    static String cmd_msg_server = null;
    static String cmd_jndi_server = null;
    static String cmd_ms_admin_port = null;
    static String cmd_ms_msg_port = null;
    static String cmd_ms_jndi_port = null;
    static String cmd_ms_ssl = null;
    static String cmd_jdbcdriver = null;
    static String cmd_access_key = null;
    static String cmd_activate_units = null;
    static String cmd_security_provider = null;
    private ConDataBase m_conMetaData = null;
    private ConMessageServer m_conMessageServer = null;
    private static ProtocolViewer _protocolViewer = null;
    private ReplicationTableControl _replicationTableControl;
    private UnitControl m_unitControl;
    private MonitorControl _monitorControl;
    private DBConnectAction _metaDataConnectAction;
    private MSConnectAction _msgConnectAction;
    private ExitAction _exitAction;
    private ClearLogWindowAction _clearLogWindowAction;
    private RepTableAddAction m_actionRepTableAdd;
    private RepTableDeleteAction m_actionRepTableDelete;
    private RepTableToUnitAction m_repTableToUnit;
    private NewRepUnitAction m_actionNewRepUnit;
    private NewParticipantAction m_actionNewParticipant;
    private ParticipantPropertiesAction m_participantPropertiesAction;
    private ActivateParticipantAction m_activateParticipantAction;
    private DeleteRepUnitAction m_deleteRepUnit;
    private InitVersionTableAction m_initVersionTable;
    private DeleteParticipantAction m_deleteParticipantAction;
    private DeleteUnitTableAction m_deleteUnitTableAction;
    private ActivateAllParticipantsAction m_activateAllParticipantsAction;
    private DeactivateAllParticipantsAction m_deactivateAllParticipantsAction;
    private ShowMSStatusAction m_actionMsgServerStatus;
    private MessageServerDebugOptions m_actionMsgServerDebugOptions;
    private SyncDestinationAction m_actionSyncDestination;
    private DeleteDestinationAction m_deleteDestinationAction;
    private DeleteTableAction m_deleteTableAction;
    private DeactivateDestinationAction m_deactivateDestinationAction;
    private ReSyncUnitAction m_reSyncUnitAction;
    private InitClientVersionWithLoaderAction m_initClientVersionWithLoaderAction;
    private GetMessagesAction m_actionGetMessages;
    private AboutAction m_actionAbout;
    private Action m_actionRefresh;
    private Action m_actionDestinationCount;
    private TabFolder m_mainTab;
    private Menu m_contextMenuRepTable;
    private Menu m_contextMenuReplicationUnit;
    private Menu m_contextMenuMessageServer;
    private Menu m_contextMenuMonitor;
    private MenuManager m_mainMenuManager;
    private MenuManager m_menuSession;
    private MenuManager m_menuRepTable;
    private MenuManager m_menuReplicationUnit;
    private MenuManager m_menuMonitor;
    private MenuManager m_menuHelp;
    private MenuManager m_menuLRU_DB;
    private MenuManager m_menuLRU_MSG;
    private Shell m_mainShell;
    private SyncGUIParams m_params;
    private static String m_SyncSchema;

    public SyncManGUI() {
        super(null);
        m_SyncSchema = "SYNCHRONIZATIONSERVICE";
        this.m_params = new SyncGUIParams();
        try {
            Resources.createInstance();
            SQLBuilder.createInstance(null);
            this.m_params.loadParameters();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_conMetaData = new ConDataBase(this.getShell(), cmd_security_provider, m_SyncSchema, true, true);
        if (cmd_jdbcdriver != null && cmd_jdbcdriver.length() > 0) {
            this.m_conMetaData.setJDBCDriver(cmd_jdbcdriver);
        } else {
            this.m_conMetaData.setJDBCDriver("com.sap.dbtech.jdbc.DriverSapDB");
        }
        this.m_conMessageServer = new ConMessageServer(this.getShell());
        this.createActions();
        this.addToolBar(0);
        this.addMenuBar();
    }

    private void destroyActions() {
        this.m_actionAbout = null;
        this._metaDataConnectAction = null;
        this._msgConnectAction = null;
        this._exitAction = null;
        this._clearLogWindowAction = null;
        this.m_actionRepTableAdd = null;
        this.m_actionRepTableDelete = null;
        this.m_repTableToUnit = null;
        this.m_actionNewRepUnit = null;
        this.m_actionNewParticipant = null;
        this.m_participantPropertiesAction = null;
        this.m_activateParticipantAction = null;
        this.m_activateAllParticipantsAction = null;
        this.m_deactivateAllParticipantsAction = null;
        this.m_deleteRepUnit = null;
        this.m_initVersionTable = null;
        this.m_reSyncUnitAction = null;
        this.m_initClientVersionWithLoaderAction = null;
        this.m_deleteParticipantAction = null;
        this.m_deleteUnitTableAction = null;
        this.m_actionMsgServerStatus = null;
        this.m_actionGetMessages = null;
        this.m_actionMsgServerDebugOptions = null;
        this.m_deleteDestinationAction = null;
        this.m_deleteTableAction = null;
        this.m_deactivateDestinationAction = null;
        this.m_actionSyncDestination = null;
        this.m_actionDestinationCount = null;
    }

    private void createActions() {
        this.m_actionAbout = new AboutAction(this);
        this._metaDataConnectAction = new DBConnectAction(this, this.m_conMetaData);
        this._msgConnectAction = new MSConnectAction(this, this.m_conMessageServer);
        this._exitAction = new ExitAction(this);
        this._clearLogWindowAction = new ClearLogWindowAction(this);
        this.m_actionRepTableAdd = new RepTableAddAction();
        this.m_actionRepTableDelete = new RepTableDeleteAction();
        this.m_repTableToUnit = new RepTableToUnitAction();
        this.m_actionNewRepUnit = new NewRepUnitAction();
        this.m_actionNewParticipant = new NewParticipantAction();
        this.m_participantPropertiesAction = new ParticipantPropertiesAction();
        this.m_activateParticipantAction = new ActivateParticipantAction();
        this.m_activateAllParticipantsAction = new ActivateAllParticipantsAction();
        this.m_deactivateAllParticipantsAction = new DeactivateAllParticipantsAction();
        this.m_deleteRepUnit = new DeleteRepUnitAction();
        this.m_initVersionTable = new InitVersionTableAction();
        this.m_reSyncUnitAction = new ReSyncUnitAction();
        this.m_initClientVersionWithLoaderAction = new InitClientVersionWithLoaderAction();
        this.m_deleteParticipantAction = new DeleteParticipantAction();
        this.m_deleteUnitTableAction = new DeleteUnitTableAction();
        this.m_actionMsgServerStatus = new ShowMSStatusAction();
        this.m_actionGetMessages = new GetMessagesAction();
        this.m_actionMsgServerDebugOptions = new MessageServerDebugOptions();
        this.m_deleteDestinationAction = new DeleteDestinationAction();
        this.m_deleteTableAction = new DeleteTableAction();
        this.m_deactivateDestinationAction = new DeactivateDestinationAction();
        this.m_actionSyncDestination = new SyncDestinationAction();
        this.m_actionRefresh = new Action(Resources.getString("Action.Refresh")){

            public void run() {
                SyncManGUI.this._monitorControl.drawTree();
            }
        };
        this.m_actionDestinationCount = new Action(Resources.getString("Action.Synchronization_Message_Count")){

            public void run() {
                SyncManGUI.this._monitorControl.showDestinationCount();
            }
        };
    }

    protected Control createContents(Composite parent) {
        this.getShell().setText(Resources.getString("SyncManGUI.SyncronizationManagerGUI"));
        this.getShell().setImage(Resources.getImage("in_out"));
        SashForm sashMainHorizontal = new SashForm(parent, 512);
        this.m_mainTab = new TabFolder((Composite)sashMainHorizontal, 0);
        this.m_mainTab.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        _protocolViewer = new ProtocolViewer((Composite)sashMainHorizontal, 768);
        _protocolViewer.setEditable(false);
        try {
            SQLBuilder.destroyInstance();
            SQLBuilder.createInstance((Object)((Object)_protocolViewer));
        }
        catch (Exception ex) {
            SQLBuilder.writeProt((Exception)ex);
        }
        SQLBuilder.writeProt((String)Resources.getString("SyncManGUI.WelcometoMaxDB"), (boolean)false);
        SashForm sashTables = new SashForm((Composite)this.m_mainTab, 512);
        SashForm sashUnits = new SashForm((Composite)this.m_mainTab, 512);
        SashForm sashMonitor = new SashForm((Composite)this.m_mainTab, 512);
        this._replicationTableControl = new ReplicationTableControl(this, sashTables);
        this._replicationTableControl.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 3) {
                    SyncManGUI.this.showRepTableContextMenu(new Point(e.x, e.y));
                }
            }
        });
        this.m_actionRepTableAdd.setControl(this._replicationTableControl);
        this.m_actionRepTableDelete.setControl(this._replicationTableControl);
        this.m_unitControl = new UnitControl(this, sashUnits);
        this.m_actionNewRepUnit.setControl(this.m_unitControl);
        this.m_actionNewParticipant.setControl(this.m_unitControl);
        this.m_participantPropertiesAction.setControl(this.m_unitControl);
        this.m_activateParticipantAction.setControl(this.m_unitControl);
        this.m_activateAllParticipantsAction.setControl(this.m_unitControl);
        this.m_deactivateAllParticipantsAction.setControl(this.m_unitControl);
        this.m_deleteRepUnit.setControl(this.m_unitControl);
        this.m_deleteParticipantAction.setControl(this.m_unitControl);
        this.m_reSyncUnitAction.setControl(this.m_unitControl);
        this.m_initVersionTable.setControl(this.m_unitControl);
        this.m_initClientVersionWithLoaderAction.setControl(this.m_unitControl);
        this.m_deleteUnitTableAction.setControl(this.m_unitControl);
        this.m_repTableToUnit.setControl(this.m_unitControl);
        this.m_actionSyncDestination.setControl(this.m_unitControl);
        this._monitorControl = new MonitorControl(this, sashMonitor);
        this.m_actionMsgServerStatus.setControl(this._monitorControl);
        this.m_actionGetMessages.setControl(this._monitorControl);
        this.m_actionMsgServerDebugOptions.setControl(this._monitorControl);
        this.m_deleteDestinationAction.setControl(this._monitorControl);
        this.m_deleteTableAction.setControl(this._monitorControl);
        this.m_deactivateDestinationAction.setControl(this._monitorControl);
        int[] weightsVertical = new int[]{8, 1};
        sashMainHorizontal.setWeights(weightsVertical);
        TabItem tabTables = new TabItem(this.m_mainTab, 0);
        tabTables.setText(Resources.getString("SyncManGUI.ReplicationTables"));
        TabItem tabUnits = new TabItem(this.m_mainTab, 0);
        tabUnits.setText(Resources.getString("SyncManGUI.ReplicationUnits"));
        TabItem tabMonitor = new TabItem(this.m_mainTab, 0);
        tabMonitor.setText(Resources.getString("SyncManGUI.Monitor"));
        tabTables.setControl((Control)sashTables);
        tabUnits.setControl((Control)sashUnits);
        tabMonitor.setControl((Control)sashMonitor);
        if (this.m_conMetaData.isConnected()) {
            this.drawDataBaseItems();
        }
        if (this.getConMessageServer().isConnected()) {
            this.drawMessageServerItems();
        }
        this.createContextMenus();
        return sashMainHorizontal;
    }

    protected MenuManager createMenuManager() {
        this.m_mainMenuManager = new MenuManager(Resources.getString("SyncManGUI.TheMenu"));
        this.m_menuSession = new MenuManager(Resources.getString("SyncManGUI.Session"));
        this.m_menuSession.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                SyncManGUI.this.checkSessionMenus();
            }
        });
        this.m_mainMenuManager.add((IContributionItem)this.m_menuSession);
        this.m_menuSession.add((IContributionItem)new GroupMarker("ConnectionGroup"));
        this.m_menuSession.insertAfter("ConnectionGroup", (IContributionItem)new Separator("ExitSeparator"));
        this.m_menuLRU_MSG = new MenuManager(Resources.getString("SyncManGUI.Recent_MessageServers"));
        this.m_menuSession.insertAfter("ExitSeparator", (IContributionItem)this.m_menuLRU_MSG);
        this.drawMSG_LRU();
        this.m_menuLRU_DB = new MenuManager(Resources.getString("SyncManGUI.Recent_Databases"));
        this.drawDB_LRU();
        this.m_menuSession.insertAfter("ExitSeparator", (IContributionItem)this.m_menuLRU_DB);
        this.m_menuSession.insertAfter("ExitSeparator", (IContributionItem)new Separator("LRU_DB_Separator"));
        this.m_menuSession.insertAfter("ExitSeparator", (IAction)this._exitAction);
        this.m_menuSession.insertAfter("ExitSeparator", (IAction)this._clearLogWindowAction);
        this.m_menuSession.insertAfter("ConnectionGroup", (IContributionItem)new Separator("XMLSeparator"));
        this.m_menuSession.insertAfter("ConnectionGroup", (IAction)this._msgConnectAction);
        this.m_menuSession.insertAfter("ConnectionGroup", (IAction)this._metaDataConnectAction);
        this.m_menuRepTable = new MenuManager("&" + Resources.getString("SyncManGUI.ReplicationTables"));
        this.m_mainMenuManager.add((IContributionItem)this.m_menuRepTable);
        this.createRepTableMenu(this.m_menuRepTable);
        this.m_menuReplicationUnit = new MenuManager("Replication &Units");
        this.m_mainMenuManager.add((IContributionItem)this.m_menuReplicationUnit);
        this.createReplicationUnitMenu(this.m_menuReplicationUnit);
        this.m_menuMonitor = new MenuManager("M&onitor");
        this.m_mainMenuManager.add((IContributionItem)this.m_menuMonitor);
        this.createMonitorControlMenu(this.m_menuMonitor);
        this.m_menuHelp = new MenuManager("&Help");
        this.m_mainMenuManager.add((IContributionItem)this.m_menuHelp);
        this.m_menuHelp.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                SyncManGUI.this.checkHelpMenus();
            }
        });
        this.m_menuHelp.add((IContributionItem)new GroupMarker(Resources.getString("SyncManGUI.HelpMenu")));
        this.m_menuHelp.insertAfter(Resources.getString("SyncManGUI.HelpMenu"), (IAction)this.m_actionAbout);
        return this.m_mainMenuManager;
    }

    protected ToolBarManager createToolBarManager(int arg0) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800040);
        return toolBarManager;
    }

    public void run() {
        this.open();
        this.m_mainShell = this.getShell();
        this.m_mainShell.setBounds(this.m_params.getX(), this.m_params.getY(), this.m_params.getWidth(), this.m_params.getHeight());
        this.m_mainShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SyncManGUI.this.m_params.setX(((SyncManGUI)SyncManGUI.this).m_mainShell.getBounds().x);
                SyncManGUI.this.m_params.setY(((SyncManGUI)SyncManGUI.this).m_mainShell.getBounds().y);
                SyncManGUI.this.m_params.setWidth(((SyncManGUI)SyncManGUI.this).m_mainShell.getBounds().width);
                SyncManGUI.this.m_params.setHeight(((SyncManGUI)SyncManGUI.this).m_mainShell.getBounds().height);
            }
        });
        Display display = Display.getCurrent();
        while (!this.m_mainShell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        try {
            this.m_params.saveParameters(true);
        }
        catch (IOException ex) {
            SQLBuilder.writeProt((Exception)ex);
        }
        SQLBuilder.destroyInstance();
        display.dispose();
    }

    public void displayHelp() {
        String text = "No yet implemented.";
        MessageDialog.openInformation((Shell)this.getShell(), (String)"MaxDB", (String)text);
    }

    public void displayAbout() {
        MessageDialog.openInformation((Shell)this.getShell(), (String)Resources.getString("SyncManGUI.MaxDB"), (String)Resources.getString("GUI_Version"));
    }

    public boolean close() {
        this.closeDatabaseConnections();
        this.closeMSConnection();
        Resources.destroyInstance();
        this.destroyActions();
        return super.close();
    }

    private static void displayCmdHelp() {
        System.out.println("-database_host  | -n        // host");
        System.out.println("-database_name  | -d        // database");
        System.out.println("-user                       // user");
        System.out.println("-password                   // password");
        System.out.println("-database_encryption ssl    // use a ssl socket");
        System.out.println("-msgserver_host             // message server");
        System.out.println("-msgserver_port             // message server port");
        System.out.println("-jndiserver_host            // jndi server");
        System.out.println("-jndiserver_port            // jndi server port");
        System.out.println("-msgserver_admin_port       // message server admin port");
        System.out.println("-msgserver_password         // message server password");
        System.out.println("-msgserver_encryption ssl   // use ssl sockets");
        System.out.println("-security_provider          //class name of a security provider.");
        System.out.println("-help                       // help");
        System.out.println("-h                          // help");
        System.out.println("-?                          // help");
        System.exit(0);
    }

    public static void main(String[] args) {
        try {
            int i = 0;
            while (i < args.length) {
                String tmp;
                if (args[i].trim().length() < 1) {
                    ++i;
                    continue;
                }
                if (args[i].equals("-A") || args[i].equals(ACCESS_KEY)) {
                    cmd_access_key = args[i + 1];
                    i += 2;
                    AccParams param = new AccParams(cmd_access_key, cmd_security_provider);
                    param.loadParameters();
                    if (cmd_host != null && cmd_host.length() > 0) {
                        System.out.println("Host " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_host = param.getDBHost();
                    if (cmd_database != null && cmd_database.length() > 0) {
                        System.out.println("Database " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_database = param.getDBName();
                    if (cmd_user != null && cmd_user.length() > 1) {
                        System.out.println("User " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_user = param.getDBUser();
                    if (cmd_password != null && cmd_password.length() > 0) {
                        System.out.println("Password " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_password = param.getDBPassword();
                    if (cmd_jdbcdriver != null && cmd_jdbcdriver.length() > 0) {
                        System.out.println("JDBC Driver " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    if (cmd_msg_server != null && cmd_msg_server.length() > 0) {
                        System.out.println("Message Server Host " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_msg_server = param.getMsgServer();
                    if (cmd_jndi_server != null && cmd_jndi_server.length() > 0) {
                        System.out.println("Jndi Server Host " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_jndi_server = param.getJndiServer();
                    if (cmd_ms_admin_port != null && cmd_ms_admin_port.length() > 0) {
                        System.out.println("Message Server Admin Port " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_ms_admin_port = param.getMsgSvrAdminPort();
                    if (cmd_ms_jndi_port != null && cmd_ms_jndi_port.length() > 0) {
                        System.out.println("Jndi Port " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_ms_jndi_port = param.getJndiPort();
                    if (cmd_ms_msg_port != null && cmd_ms_msg_port.length() > 0) {
                        System.out.println("Message Server Admin Port " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_ms_msg_port = param.getMsgPort();
                    if (cmd_ms_password != null && cmd_ms_password.length() > 0) {
                        System.out.println("Message Server Password " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_ms_password = param.getMsgAdminPassword();
                    if (cmd_ms_ssl != null && cmd_ms_ssl.length() > 0) {
                        System.out.println("Message Server Secure " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_ms_ssl = param.getMsg_SSL();
                    continue;
                }
                if (args[i].equals("-n") || args[i].equals(DB_HOST)) {
                    if (cmd_host != null && cmd_host.length() > 0) {
                        System.out.println("Host " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_host = args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals("-d") || args[i].equals(DB_NAME)) {
                    if (cmd_database != null && cmd_database.length() > 0) {
                        System.out.println("Database " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_database = args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals("-u")) {
                    StringTokenizer st = new StringTokenizer(args[i + 1], ",");
                    if (st.hasMoreTokens()) {
                        if (cmd_user != null && cmd_user.length() > 1) {
                            System.out.println("User " + Resources.getString("CMDLine.Error"));
                            System.exit(1);
                        }
                        cmd_user = st.nextToken();
                    }
                    if (st.hasMoreTokens()) {
                        if (cmd_password != null && cmd_password.length() > 0) {
                            System.out.println("Password " + Resources.getString("CMDLine.Error"));
                            System.exit(1);
                        }
                        cmd_password = st.nextToken();
                        i += 2;
                        continue;
                    }
                    if (cmd_password == null || cmd_password.length() < 1) {
                        cmd_password = PasswordPrompt.getPassword("Database Password:\n");
                    }
                    ++i;
                    continue;
                }
                if (args[i].equals(USER)) {
                    if (cmd_user != null && cmd_user.length() > 1) {
                        System.out.println("User " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_user = args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals(PASSWORD)) {
                    if (cmd_password != null && cmd_password.length() > 0) {
                        System.out.println("Password " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    try {
                        tmp = args[i + 1];
                        if (!tmp.startsWith("-")) {
                            cmd_password = tmp;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        // empty catch block
                    }
                    if (cmd_password == null || cmd_password.length() < 1) {
                        ++i;
                        cmd_password = PasswordPrompt.getPassword("Database Password:\n");
                        continue;
                    }
                    i += 2;
                    continue;
                }
                if (args[i].equals(DB_ENCRYPTION)) {
                    if (cmd_db_ssl != null && cmd_db_ssl.length() > 0) {
                        System.out.println("Database Secure " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_db_ssl = args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals(MSG_SERVER)) {
                    if (cmd_msg_server != null && cmd_msg_server.length() > 0) {
                        System.out.println("Message Server Host " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_msg_server = args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals(JNDI_SERVER)) {
                    if (cmd_jndi_server != null && cmd_jndi_server.length() > 0) {
                        System.out.println("Jndi Server Host " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_jndi_server = args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals(MSG_SERVER_PORT)) {
                    if (cmd_ms_msg_port != null && cmd_ms_msg_port.length() > 0) {
                        System.out.println("Message Server Port " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_ms_msg_port = args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals(JNDI_SERVER_PORT)) {
                    if (cmd_ms_jndi_port != null && cmd_ms_jndi_port.length() > 0) {
                        System.out.println("Jndi Server Port " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_ms_jndi_port = args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals(MSG_SERVER_ADMIN_PORT)) {
                    if (cmd_ms_admin_port != null && cmd_ms_admin_port.length() > 0) {
                        System.out.println("Message Server Amin Port " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_ms_admin_port = args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals(MSG_ENCRYPTION)) {
                    if (cmd_ms_ssl != null && cmd_ms_ssl.length() > 0) {
                        System.out.println("Message Server Secure " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_ms_ssl = args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals(SECURITY_PROVIDER)) {
                    cmd_security_provider = args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals(MSG_SERVER_PASSWORD)) {
                    if (cmd_ms_password != null && cmd_ms_password.length() > 0) {
                        System.out.println("Message Server Password " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    try {
                        tmp = args[i + 1];
                        if (!tmp.startsWith("-")) {
                            cmd_ms_password = tmp;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        // empty catch block
                    }
                    if (cmd_ms_password == null || cmd_ms_password.length() < 1) {
                        ++i;
                        cmd_ms_password = PasswordPrompt.getPassword("Message Server Password:\n");
                        continue;
                    }
                    i += 2;
                    continue;
                }
                if (args[i].equals("-j") || args[i].equals("-driver")) {
                    if (cmd_jdbcdriver != null && cmd_jdbcdriver.length() > 0) {
                        System.out.println("JDBC Driver " + Resources.getString("CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_jdbcdriver = args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals(HELP1) || args[i].equals(HELP2) || args[i].equals(HELP3)) {
                    SyncManGUI.displayCmdHelp();
                    return;
                }
                if (args[i].equals("-activateunits")) {
                    cmd_activate_units = args[i];
                    ++i;
                    continue;
                }
                System.out.println("unknown argument in command line at position " + (i + 1) + ": " + args[i]);
                SyncManGUI.displayCmdHelp();
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SyncManGUI window = new SyncManGUI();
        try {
            if (cmd_database != null && cmd_database.length() > 0 && cmd_user != null && cmd_user.length() > 0 && cmd_password != null && cmd_password.length() > 0) {
                boolean db_ssl = cmd_db_ssl != null && cmd_db_ssl.equalsIgnoreCase("ssl");
                window.getConMetaData().connect(cmd_host, cmd_database, cmd_user, cmd_password, db_ssl, cmd_additionalURL);
                if (window.getConMetaData().isConnected()) {
                    window.addLRU_DB(window.getConMetaData());
                    if (cmd_activate_units != null) {
                        SyncManGUI.activateAllUnits(window);
                    }
                }
            }
            if (cmd_ms_admin_port != null && cmd_ms_admin_port.length() > 0 && cmd_ms_password != null && cmd_ms_password.length() > 0) {
                boolean msssl = cmd_ms_ssl != null && cmd_ms_ssl.equalsIgnoreCase("ssl");
                int msgPort = -1;
                if (cmd_ms_msg_port != null && cmd_ms_msg_port.length() > 0) {
                    msgPort = Integer.parseInt(cmd_ms_msg_port);
                }
                int jndiPort = -1;
                if (cmd_ms_jndi_port != null && cmd_ms_jndi_port.length() > 0) {
                    jndiPort = Integer.parseInt(cmd_ms_jndi_port);
                }
                window.getConMessageServer().connect(cmd_msg_server, msgPort, cmd_jndi_server, jndiPort, cmd_ms_admin_port != null ? Integer.parseInt(cmd_ms_admin_port) : -1, cmd_ms_password, msssl);
                window.addLRU_MSG(window.getConMessageServer());
            }
            if (window.getConMessageServer().isConnected()) {
                SQLBuilder.writeProt((String)Resources.getString("SyncMan.Connected_to_message_server"), (boolean)false);
                if (cmd_activate_units != null) {
                    UnitControl.updateMsgServerDestinations(window.getConMetaData(), window.getConMessageServer());
                    SQLBuilder.writeProt((String)Resources.getString("SyncMan.Synchronized_destinations_on_message_server"), (boolean)false);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println(ex.toString());
            System.exit(1);
        }
        if (cmd_activate_units != null) {
            System.out.println(Resources.getString("SyncMan.Exit_from_commandline"));
            System.exit(0);
        }
        window.run();
    }

    private static void activateAllUnits(SyncManGUI window) throws SQLException {
        ConDataBase dbTarget = new ConDataBase(window.getShell(), cmd_security_provider, m_SyncSchema, false, true);
        Vector masterParticipantNodes = DesignSQLLayer.selectParticipants(window.getConMetaData(), -1L, true, false);
        for (int j = 0; j < masterParticipantNodes.size(); ++j) {
            Participant masterParticipantNode = (Participant)masterParticipantNodes.get(j);
            Vector repPart = DesignSQLLayer.selectParticipants(window.getConMetaData(), masterParticipantNode.getDesignID(), true, true);
            for (int i = 0; i < repPart.size(); ++i) {
                Participant part = (Participant)repPart.get(i);
                if (!part.isInstalled()) continue;
                UnitControl.activateParticipant(window.getConMetaData(), dbTarget, part, true);
            }
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Resources.getString("SyncManGUI.New_Application"));
    }

    public ConDataBase getConMetaData() {
        return this.m_conMetaData;
    }

    public ConMessageServer getConMessageServer() {
        return this.m_conMessageServer;
    }

    private void closeDatabaseConnections() {
        try {
            if (this.m_conMetaData != null && this.m_conMetaData.isConnected()) {
                this.m_conMetaData.disconnect();
            }
        }
        catch (SQLException ex) {
            SQLBuilder.writeProt((Exception)ex);
        }
        if (this._metaDataConnectAction != null) {
            this._metaDataConnectAction.setEnabled(!this.m_conMetaData.isConnected());
        }
        SQLBuilder.writeProt((String)Resources.getString("SyncManGUI.Database_Connection_closed"), (boolean)false);
    }

    private void closeMSConnection() {
        try {
            if (this.m_conMessageServer != null && this.m_conMessageServer.isConnected()) {
                this.m_conMessageServer.disconnect();
            }
        }
        catch (IOException ex) {
            SQLBuilder.writeProt((Exception)ex);
        }
        this._msgConnectAction.setEnabled(!this.m_conMessageServer.isConnected());
        SQLBuilder.writeProt((String)Resources.getString("SyncManGUI.Message_Server_Connection_closed"), (boolean)false);
    }

    private void checkHelpMenus() {
    }

    private void checkSessionMenus() {
        this._metaDataConnectAction.setEnabled(!this._metaDataConnectAction.isConnecting() && !this.m_unitControl.isAsyncWorking());
        if (this.m_conMetaData.isConnected()) {
            this._metaDataConnectAction.setText(Resources.getString("Session.Application.DBDisconnect"));
            this._metaDataConnectAction.setToolTipText(Resources.getString("Session.Application.DBDisconnect"));
        } else {
            this._metaDataConnectAction.setText(Resources.getString("Session.Application.DBConnect"));
            this._metaDataConnectAction.setToolTipText(Resources.getString("Session.Application.DBConnect"));
        }
        if (this.m_conMessageServer.isConnected()) {
            this._msgConnectAction.setText(Resources.getString("Session.Application.MSDisconnect"));
            this._msgConnectAction.setToolTipText(Resources.getString("Session.Application.MSDisconnect"));
        } else {
            this._msgConnectAction.setText(Resources.getString("Session.Application.MSConnect"));
            this._msgConnectAction.setToolTipText(Resources.getString("Session.Application.MSConnect"));
        }
    }

    private void checkMonitorMenus() {
        boolean tabActive = this.m_mainTab.getSelectionIndex() == 2;
        this.m_actionRefresh.setEnabled(tabActive && this._monitorControl != null);
        this.m_actionMsgServerStatus.setEnabled(tabActive && this._monitorControl != null && this.m_conMessageServer.isConnected());
        this.m_actionGetMessages.setEnabled(tabActive && this._monitorControl != null && this._monitorControl.getSelectedDestrination() != null && this.m_conMessageServer.isConnected());
        this.m_actionDestinationCount.setEnabled(tabActive && this._monitorControl != null && this._monitorControl.getSelectedDestrination() != null && this.m_conMessageServer.isConnected());
        this.m_actionMsgServerDebugOptions.setEnabled(tabActive && this._monitorControl != null && this.m_conMessageServer.isConnected());
        this.m_deleteDestinationAction.setEnabled(tabActive && this._monitorControl != null && this.m_conMessageServer.isConnected() && this.m_unitControl != null && this._monitorControl.getSelectedDestrination() != null && !this.m_unitControl.isAsyncWorking());
        this.m_deactivateDestinationAction.setEnabled(tabActive && this._monitorControl != null && this.m_conMessageServer.isConnected());
        this.m_deleteTableAction.setEnabled(tabActive && this._monitorControl != null && this.m_unitControl != null && this._monitorControl.getSelectedTable() != null && this._monitorControl.getSelectedTable().startsWith("_R_A_") && !this.m_unitControl.isAsyncWorking());
    }

    private void checkReplicationTableMenus() {
        boolean tabActive = this.m_mainTab.getSelectionIndex() == 0;
        this.m_actionRepTableAdd.setEnabled(tabActive && this._replicationTableControl != null && this.m_conMetaData.isConnected());
        this.m_actionRepTableDelete.setEnabled(tabActive && this._replicationTableControl != null && this.m_conMetaData.isConnected() && this._replicationTableControl.getSelectedRepTable() != null);
    }

    private void checkParticipantMenus() {
        boolean tabActive = this.m_mainTab.getSelectionIndex() == 1;
        this.m_actionNewRepUnit.setEnabled(tabActive && this.m_unitControl != null && this.m_conMetaData.isConnected() && !this.m_unitControl.isAsyncWorking());
        this.m_actionNewParticipant.setEnabled(tabActive && this.m_unitControl != null && this.m_conMetaData.isConnected() && this.m_unitControl.getSelectedMasterParticipant() != null && !this.m_unitControl.isAsyncWorking());
        this.m_participantPropertiesAction.setEnabled(tabActive && this.m_unitControl != null && this.m_conMetaData.isConnected() && this.m_unitControl.getSelectedParticipant() != null && !this.m_unitControl.isAsyncWorking());
        this.m_activateParticipantAction.setEnabled(tabActive && this.m_unitControl != null && this.m_conMetaData.isConnected() && this.m_unitControl.getSelectedParticipant() != null && !this.m_unitControl.isAsyncWorking());
        if (this.m_unitControl.getSelectedParticipant() != null) {
            String menu = (this.m_unitControl.getSelectedParticipant().isInstalled() ? Resources.getString("RepParticipantAction.Menu.DeactivateParticpant") : Resources.getString("RepParticipantAction.Menu.ActivateParticpant")) + (this.m_unitControl.getSelectedParticipant().isMaster() ? " Master" : " Client") + " Unit";
            this.m_activateParticipantAction.setText(menu);
            this.m_activateParticipantAction.setToolTipText(menu);
        }
        this.m_activateAllParticipantsAction.setEnabled(tabActive && this.m_unitControl != null && this.m_conMetaData.isConnected() && !this.m_unitControl.isAsyncWorking());
        this.m_deactivateAllParticipantsAction.setEnabled(tabActive && this.m_unitControl != null && this.m_conMetaData.isConnected() && !this.m_unitControl.isAsyncWorking());
        this.m_deleteParticipantAction.setEnabled(tabActive && this.m_unitControl != null && this.m_conMetaData.isConnected() && this.m_unitControl.getSelectedParticipant() != null && !this.m_unitControl.getSelectedParticipant().isMaster() && !this.m_unitControl.getSelectedParticipant().isInstalled() && !this.m_unitControl.isAsyncWorking());
        this.m_reSyncUnitAction.setEnabled(tabActive && this.m_unitControl != null && this.m_conMetaData.isConnected() && this.m_conMessageServer.isConnected() && this.m_unitControl.getSelectedMasterParticipant() != null && this.m_unitControl.getSelectedMasterParticipant().isInstalled() && this.m_unitControl.getSelectedParticipant() != null && !this.m_unitControl.getSelectedParticipant().isMaster() && this.m_unitControl.getSelectedParticipant().isInstalled() && !this.m_unitControl.isAsyncWorking());
        this.m_initClientVersionWithLoaderAction.setEnabled(tabActive && this.m_unitControl != null && this.m_conMetaData.isConnected() && this.m_unitControl.getSelectedMasterParticipant() != null && this.m_unitControl.getSelectedParticipant() != null && !this.m_unitControl.getSelectedParticipant().isMaster() && this.m_unitControl.getSelectedParticipant().isInstalled() && !this.m_unitControl.isAsyncWorking());
        this.m_deleteRepUnit.setEnabled(tabActive && this.m_unitControl != null && this.m_conMetaData.isConnected() && this.m_unitControl.getSelectedMasterParticipant() != null && this.m_unitControl.getSelectedMasterParticipant().isMaster() && !this.m_unitControl.getSelectedMasterParticipant().isInstalled() && !this.m_unitControl.isAsyncWorking());
        this.m_deleteUnitTableAction.setEnabled(tabActive && this.m_unitControl != null && this.m_conMetaData.isConnected() && this.m_unitControl.getSelectedUnitTable() != null && !this.m_unitControl.isAsyncWorking());
        this.m_repTableToUnit.setEnabled(tabActive && this.m_unitControl != null && this.m_conMetaData.isConnected() && this.m_unitControl.getSelectedMasterParticipant() != null && !this.m_unitControl.isAsyncWorking());
        this.m_actionSyncDestination.setEnabled(tabActive && this.m_unitControl != null && this.m_conMessageServer.isConnected() && this.m_unitControl != null && !this.m_unitControl.isAsyncWorking());
        this.m_initVersionTable.setEnabled(tabActive && this.m_unitControl != null && this.m_conMetaData.isConnected() && this.m_unitControl.getSelectedParticipant() != null && this.m_unitControl.getSelectedParticipant().isMaster() && this.m_unitControl.getSelectedParticipant().isInstalled() && !this.m_unitControl.isAsyncWorking());
    }

    public static void commitConnection(ConDataBase con) {
        try {
            con.getConnection().commit();
        }
        catch (SQLException ex) {
            SQLBuilder.writeProt((Exception)ex);
        }
    }

    public static void rollBackConnection(ConDataBase con) {
        if (con == null) {
            return;
        }
        try {
            con.getConnection().rollback();
        }
        catch (SQLException ex) {
            SQLBuilder.writeProt((Exception)ex);
        }
    }

    public void drawDataBaseItems() {
        if (this.m_conMetaData.isConnected()) {
            if (this._replicationTableControl != null) {
                this._replicationTableControl.drawTree();
            }
            if (this.m_unitControl != null) {
                this.m_unitControl.drawControl();
            }
            if (this._monitorControl != null) {
                this._monitorControl.drawTree();
            }
        } else {
            if (this._replicationTableControl != null) {
                this._replicationTableControl.clearTree();
            }
            if (this.m_unitControl != null) {
                this.m_unitControl.clearTree();
            }
            if (this._monitorControl != null) {
                this._monitorControl.clearTree();
            }
        }
    }

    public void drawMessageServerItems() {
        if (this.m_conMessageServer.isConnected()) {
            if (this._monitorControl != null) {
                this._monitorControl.drawTree();
            }
        } else {
            this._monitorControl.clearTree();
        }
    }

    public void showRepTableContextMenu(Point p) {
        this.m_contextMenuRepTable.setLocation(p.x, p.y);
        this.m_contextMenuRepTable.setVisible(true);
        this.getShell().setMenu(this.m_contextMenuRepTable);
    }

    public void showMessageServerContextMenu(Point p) {
        this.m_contextMenuMessageServer.setLocation(p.x, p.y);
        this.m_contextMenuMessageServer.setVisible(true);
        this.getShell().setMenu(this.m_contextMenuMessageServer);
    }

    public void showMonitorContextMenu(Point p) {
        this.m_contextMenuMonitor.setLocation(p.x, p.y);
        this.m_contextMenuMonitor.setVisible(true);
        this.getShell().setMenu(this.m_contextMenuMonitor);
    }

    public void showReplicationUnitContextMenu(Point p) {
        this.m_contextMenuReplicationUnit.setLocation(p.x, p.y);
        this.m_contextMenuReplicationUnit.setVisible(true);
        this.getShell().setMenu(this.m_contextMenuReplicationUnit);
    }

    private void createRepTableMenu(MenuManager m_menuRepTable) {
        m_menuRepTable.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                SyncManGUI.this.checkReplicationTableMenus();
            }
        });
        m_menuRepTable.add((IContributionItem)new GroupMarker(Resources.getString("SyncManGUI.RepTable")));
        m_menuRepTable.insertAfter("RepTable", (IAction)this.m_actionRepTableDelete);
        m_menuRepTable.insertAfter("RepTable", (IAction)this.m_actionRepTableAdd);
    }

    private void createReplicationUnitMenu(MenuManager menuReplicationUnit) {
        menuReplicationUnit.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                SyncManGUI.this.checkParticipantMenus();
            }
        });
        menuReplicationUnit.add((IContributionItem)new GroupMarker("ReplicationUnit"));
        menuReplicationUnit.insertAfter("ReplicationUnit", (IAction)this.m_actionSyncDestination);
        menuReplicationUnit.insertAfter("ReplicationUnit", (IContributionItem)new Separator("ReplicationUnitSeparator1"));
        menuReplicationUnit.insertAfter("ReplicationUnit", (IAction)this.m_deactivateAllParticipantsAction);
        menuReplicationUnit.insertAfter("ReplicationUnit", (IAction)this.m_activateAllParticipantsAction);
        menuReplicationUnit.insertAfter("ReplicationUnit", (IContributionItem)new Separator("ReplicationUnitSeparator2"));
        menuReplicationUnit.insertAfter("ReplicationUnit", (IAction)this.m_initClientVersionWithLoaderAction);
        menuReplicationUnit.insertAfter("ReplicationUnit", (IAction)this.m_initVersionTable);
        menuReplicationUnit.insertAfter("ReplicationUnit", (IContributionItem)new Separator("ReplicationUnitSeparator3"));
        menuReplicationUnit.insertAfter("ReplicationUnit", (IAction)this.m_reSyncUnitAction);
        menuReplicationUnit.insertAfter("ReplicationUnit", (IAction)this.m_activateParticipantAction);
        menuReplicationUnit.insertAfter("ReplicationUnit", (IContributionItem)new Separator("ReplicationUnitSeparator3"));
        menuReplicationUnit.insertAfter("ReplicationUnit", (IAction)this.m_deleteUnitTableAction);
        menuReplicationUnit.insertAfter("ReplicationUnit", (IAction)this.m_repTableToUnit);
        menuReplicationUnit.insertAfter("ReplicationUnit", (IContributionItem)new Separator("ReplicationUnitSeparator4"));
        menuReplicationUnit.insertAfter("ReplicationUnit", (IAction)this.m_deleteParticipantAction);
        menuReplicationUnit.insertAfter("ReplicationUnit", (IAction)this.m_actionNewParticipant);
        menuReplicationUnit.insertAfter("ReplicationUnit", (IContributionItem)new Separator("ReplicationUnitSeparator5"));
        menuReplicationUnit.insertAfter("ReplicationUnit", (IAction)this.m_participantPropertiesAction);
        menuReplicationUnit.insertAfter("ReplicationUnit", (IContributionItem)new Separator("ReplicationUnitSeparator6"));
        menuReplicationUnit.insertAfter("ReplicationUnit", (IAction)this.m_deleteRepUnit);
        menuReplicationUnit.insertAfter("ReplicationUnit", (IAction)this.m_actionNewRepUnit);
    }

    public void createContextMenus() {
        MenuManager popMenuRepTable = new MenuManager("&" + Resources.getString("SyncManGUI.ReplicationTables"));
        this.createRepTableMenu(popMenuRepTable);
        this.m_contextMenuRepTable = popMenuRepTable.createContextMenu((Control)this._replicationTableControl);
        MenuManager popMenuReplicationUnit = new MenuManager("Replication &Units");
        this.createReplicationUnitMenu(popMenuReplicationUnit);
        this.m_contextMenuReplicationUnit = popMenuReplicationUnit.createContextMenu((Control)this.m_unitControl);
        MenuManager popMenuMonitorControl = new MenuManager("M&onitor");
        this.createMonitorControlMenu(popMenuMonitorControl);
        this.m_contextMenuMonitor = popMenuMonitorControl.createContextMenu((Control)this._monitorControl);
    }

    private void createMonitorControlMenu(MenuManager menuMonitor) {
        menuMonitor.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                SyncManGUI.this.checkMonitorMenus();
            }
        });
        menuMonitor.add((IContributionItem)new GroupMarker("Monitor"));
        menuMonitor.insertAfter("Monitor", (IAction)this.m_deleteTableAction);
        menuMonitor.insertAfter("Monitor", (IContributionItem)new Separator("MonitorSeparator4"));
        menuMonitor.insertAfter("Monitor", (IAction)this.m_deactivateDestinationAction);
        menuMonitor.insertAfter("Monitor", (IAction)this.m_deleteDestinationAction);
        menuMonitor.insertAfter("Monitor", (IContributionItem)new Separator("MonitorSeparator3"));
        menuMonitor.insertAfter("Monitor", (IAction)this.m_actionGetMessages);
        menuMonitor.insertAfter("Monitor", (IAction)this.m_actionDestinationCount);
        menuMonitor.insertAfter("Monitor", (IContributionItem)new Separator("MonitorSeparator1"));
        menuMonitor.insertAfter("Monitor", (IAction)this.m_actionMsgServerDebugOptions);
        menuMonitor.insertAfter("Monitor", (IAction)this.m_actionMsgServerStatus);
        menuMonitor.insertAfter("Monitor", (IContributionItem)new Separator("MonitorSeparator1"));
        menuMonitor.insertAfter("Monitor", (IAction)this.m_actionRefresh);
    }

    public void addLRU_DB(ConDataBase con) {
        ConDataBase tmp = new ConDataBase(cmd_security_provider, m_SyncSchema, true, true);
        try {
            tmp.setConnectParam(con.getHost(), con.getDataBase(), con.getUser(), con.getPassWord(), con.getUseSSL(), false);
            this.m_params.getLRU_DB().put(tmp.toString(), tmp);
        }
        catch (SQLException ex) {
            SQLBuilder.writeProt((Exception)ex);
        }
        this.drawDB_LRU();
    }

    private void drawDB_LRU() {
        this.m_menuLRU_DB.removeAll();
        this.m_menuLRU_DB.add((IContributionItem)new GroupMarker("LRU_DB"));
        Iterator it = this.m_params.getLRU_DB().values().iterator();
        int i = this.m_params.getLRU_DB().values().size();
        while (it.hasNext()) {
            ConDataBase temp = (ConDataBase)it.next();
            DBConnectAction dbcon = new DBConnectAction(this, this.m_conMetaData);
            dbcon.setLRUConnection(temp);
            dbcon.setText("&" + i + " " + temp.toString());
            dbcon.setToolTipText(temp.toString());
            this.m_menuLRU_DB.insertAfter("LRU_DB", (IAction)dbcon);
            --i;
        }
        if (this.m_menuLRU_DB.getItems().length < 2) {
            this.m_menuLRU_DB.insertAfter("LRU_DB", (IAction)new Action(""){});
        }
    }

    public void addLRU_MSG(ConMessageServer con) {
        ConMessageServer tmp = new ConMessageServer();
        tmp.setConnectParam(con.getMsgHost(), con.getMsgPort(), con.getJndiHost(), con.getJndiPort(), con.getAdminPort(), con.getPassWord(), con.getUseSSL());
        this.m_params.getLRU_MSG().put(tmp.toString(), tmp);
        this.drawMSG_LRU();
    }

    private void drawMSG_LRU() {
        this.m_menuLRU_MSG.removeAll();
        this.m_menuLRU_MSG.add((IContributionItem)new GroupMarker("LRU_MSG"));
        Iterator it = this.m_params.getLRU_MSG().values().iterator();
        int i = this.m_params.getLRU_MSG().values().size();
        while (it.hasNext()) {
            ConMessageServer temp = (ConMessageServer)it.next();
            MSConnectAction mscon = new MSConnectAction(this, this.m_conMessageServer);
            mscon.setLRUConnection(temp);
            mscon.setText("&" + i + " " + temp.toString());
            mscon.setToolTipText(temp.toString());
            this.m_menuLRU_MSG.insertAfter("LRU_MSG", (IAction)mscon);
            --i;
        }
        if (this.m_menuLRU_MSG.getItems().length < 2) {
            this.m_menuLRU_MSG.insertAfter("LRU_MSG", (IAction)new Action(""){});
        }
    }

    public static String getSyncSchema() {
        return m_SyncSchema;
    }

    public static String getSecurityProvider() {
        return cmd_security_provider;
    }
}

