/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.programmargs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class PasswordPrompt {
    public static String getPassword(String prompt) {
        String retval = null;
        MaskingThread et = new MaskingThread(prompt);
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        et.start();
        try {
            retval = in.readLine();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        et.stopMasking();
        return retval;
    }

    public static void main(String[] argv) {
        System.out.println("Password=" + PasswordPrompt.getPassword("Password:\n"));
    }

    private static class MaskingThread
    extends Thread {
        private volatile boolean stop;
        private char echochar = (char)32;

        public MaskingThread(String prompt) {
            System.out.print(prompt);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            int priority = this.getPriority();
            this.setPriority(10);
            try {
                this.stop = true;
                while (this.stop) {
                    System.out.print("\b" + this.echochar + "\b");
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException iex) {
                        this.interrupt();
                        this.setPriority(priority);
                        return;
                    }
                }
            }
            finally {
                this.setPriority(priority);
            }
        }

        public void stopMasking() {
            this.stop = false;
        }
    }
}

