/*
        ========== licence begin  GPL
        Copyright (C) 2006 SAP AG

        This program is free software; you can redistribute it and/or
        modify it under the terms of the GNU General Public License
        as published by the Free Software Foundation; either version 2
        of the License, or (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
        ========== licence end
 */
#ifndef IOMAN_MESSAGES_HPP
#define IOMAN_MESSAGES_HPP

// Generated Header file IOMan_Messages.hpp.
// Generated by genmsg V2.2 DO NOT EDIT

#include "SAPDBCommon/ErrorsAndMessages/SAPDBErr_MessageList.hpp"

#define IOMAN_INFO_UNSET_BAD_VOLUME           SAPDBErr_MessageList::Info,20000,"Reset bad flag for %s volume %s",2
#define IOMAN_INFO_UNSET_BAD_VOLUME_ID 20000
#define IOMAN_INFO_VOLUME_MARKED_AS_BAD       SAPDBErr_MessageList::Info,20001,"%s volume %s is marked as bad",2
#define IOMAN_INFO_VOLUME_MARKED_AS_BAD_ID 20001
#define IOMAN_INFO_ADD_VOLUME                 SAPDBErr_MessageList::Info,20002,"Add %s volume %s with %s pages successfully executed",3
#define IOMAN_INFO_ADD_VOLUME_ID 20002
#define IOMAN_INFO_DO_MIGRATION               SAPDBErr_MessageList::Info,20003,"Start data base inplace migration",0
#define IOMAN_INFO_DO_MIGRATION_ID 20003
#define IOMAN_INFO_MIGRATION_FINISHED         SAPDBErr_MessageList::Info,20004,"Data base migration successfully finished",0
#define IOMAN_INFO_MIGRATION_FINISHED_ID 20004
#define IOMAN_INFO_CONV_PAGES_MIGRATED        SAPDBErr_MessageList::Info,20005,"Migration: converter page count %s / data page count %s",2
#define IOMAN_INFO_CONV_PAGES_MIGRATED_ID 20005
#define IOMAN_INFO_START_REINTEGRATION        SAPDBErr_MessageList::Info,20006,"Start reintegration for log device %s from '%s' to '%s'",3
#define IOMAN_INFO_START_REINTEGRATION_ID 20006
#define IOMAN_INFO_STOP_REINTEGRATION         SAPDBErr_MessageList::Info,20007,"Reintegration successfully finished",0
#define IOMAN_INFO_STOP_REINTEGRATION_ID 20007
#define IOMAN_INFO_BAD_VOLUME_NOT_FOUND       SAPDBErr_MessageList::Info,20008,"Bad log volume '%s' not found",1
#define IOMAN_INFO_BAD_VOLUME_NOT_FOUND_ID 20008
#define IOMAN_INFO_VOLUME_NOT_BAD             SAPDBErr_MessageList::Info,20009,"Given log volume '%s' is not marked as bad",1
#define IOMAN_INFO_VOLUME_NOT_BAD_ID 20009
#define IOMAN_INFO_START_VOLUME_MIGRATION     SAPDBErr_MessageList::Info,20010,"Start volume info page migration",0
#define IOMAN_INFO_START_VOLUME_MIGRATION_ID 20010
#define IOMAN_INFO_STOP_VOLUME_MIGRATION      SAPDBErr_MessageList::Info,20011,"Volume info page migration successfully finished",0
#define IOMAN_INFO_STOP_VOLUME_MIGRATION_ID 20011
#define IOMAN_INFO_DROP_NOT_WITH_SNAPSHOT     SAPDBErr_MessageList::Info,20012,"Drop data volume failed - a snapshot exists",0
#define IOMAN_INFO_DROP_NOT_WITH_SNAPSHOT_ID 20012
#define IOMAN_INFO_DROP_MOVE_RESTART_PAGE     SAPDBErr_MessageList::Info,20013,"Drop data volume - move restart page to data volume: %s block: %s",2
#define IOMAN_INFO_DROP_MOVE_RESTART_PAGE_ID 20013
#define IOMAN_INFO_DROP_VOLUME_FINISHED       SAPDBErr_MessageList::Info,20014,"Drop data volume %s successfully executed",1
#define IOMAN_INFO_DROP_VOLUME_FINISHED_ID 20014
#define IOMAN_INFO_DROP_VOLUME_IS_OFFLINE     SAPDBErr_MessageList::Info,20015,"Drop data volume failed - volume %s is not online",1
#define IOMAN_INFO_DROP_VOLUME_IS_OFFLINE_ID 20015
#define IOMAN_INFO_ONLY_ONE_VOLUME            SAPDBErr_MessageList::Info,20016,"Drop data volume failed - data area has only one volume",0
#define IOMAN_INFO_ONLY_ONE_VOLUME_ID 20016
#define IOMAN_INFO_REMAINNING_SPACE_TOO_SMALL SAPDBErr_MessageList::Info,20017,"Drop data volume failed - remaining data area is too small",0
#define IOMAN_INFO_REMAINNING_SPACE_TOO_SMALL_ID 20017
#define IOMAN_INFO_START_DROP_VOLUME          SAPDBErr_MessageList::Info,20018,"Start reading pages from data volume %s for dropping",1
#define IOMAN_INFO_START_DROP_VOLUME_ID 20018
#define IOMAN_INFO_STOP_DROP_VOLUME           SAPDBErr_MessageList::Info,20019,"Stop reading pages from data volume %s for dropping",1
#define IOMAN_INFO_STOP_DROP_VOLUME_ID 20019
#define IOMAN_INFO_CANCEL_DROP_VOLUME         SAPDBErr_MessageList::Info,20020,"Drop data volume %s was canceled",1
#define IOMAN_INFO_CANCEL_DROP_VOLUME_ID 20020
#define IOMAN_INFO_DBFULL_DROP_VOLUME         SAPDBErr_MessageList::Info,20021,"Drop data volume %s was aborted, database was full",1
#define IOMAN_INFO_DBFULL_DROP_VOLUME_ID 20021
#define IOMAN_INFO_VOLUME_SET_TO_READ_ONLY    SAPDBErr_MessageList::Info,20022,"Data volume %s is set to read only",1
#define IOMAN_INFO_VOLUME_SET_TO_READ_ONLY_ID 20022
#define IOMAN_WRN_VOLUME_OFFLINE              SAPDBErr_MessageList::Warning,20023,"The %s volume %s is offline.",2
#define IOMAN_WRN_VOLUME_OFFLINE_ID 20023
#define IOMAN_WRN_SAVE_PARAM_FAILED           SAPDBErr_MessageList::Warning,20024,"Saving of data base configuration file failed: %s",1
#define IOMAN_WRN_SAVE_PARAM_FAILED_ID 20024
#define IOMAN_WRN_LOG_AREA_NOT_WRITEABLE      SAPDBErr_MessageList::Warning,20025,"Operation not possible, because the log area is not writable",0
#define IOMAN_WRN_LOG_AREA_NOT_WRITEABLE_ID 20025
#define IOMAN_BAD_PAGE                        SAPDBErr_MessageList::Error,20026,"Bad page on %s volume %s blockno %s",3
#define IOMAN_BAD_PAGE_ID 20026
#define IOMAN_ATTACH_FAILED                   SAPDBErr_MessageList::Error,20027,"Attach error on %s volume %s: %s",3
#define IOMAN_ATTACH_FAILED_ID 20027
#define IOMAN_NOT_ACCESSIBLE                  SAPDBErr_MessageList::Error,20028,"Access error on %s volume %s blockno %s: %s",4
#define IOMAN_NOT_ACCESSIBLE_ID 20028
#define IOMAN_ERR_SINGLE_FORMAT               SAPDBErr_MessageList::Error,20029,"Formatting of %s volume %s failed",2
#define IOMAN_ERR_SINGLE_FORMAT_ID 20029
#define IOMAN_ERR_ALL_FORMAT                  SAPDBErr_MessageList::Error,20030,"Formatting of %s area failed",1
#define IOMAN_ERR_ALL_FORMAT_ID 20030
#define IOMAN_EMERGENCY_MSG1                  SAPDBErr_MessageList::Error,20031,"EMERGENCY SHUTDOWN",0
#define IOMAN_EMERGENCY_MSG1_ID 20031
#define IOMAN_WRONG_PAGENO                    SAPDBErr_MessageList::Error,20032,"Wrong data page on data volume %s blockno %s",2
#define IOMAN_WRONG_PAGENO_ID 20032
#define IOMAN_WRONG_PAGENO2                   SAPDBErr_MessageList::Error,20033,"Wrong data page - Requested pageno %s (%s) read pageno %s",3
#define IOMAN_WRONG_PAGENO2_ID 20033
#define IOMAN_BAD_OUTPUT_PAGE                 SAPDBErr_MessageList::Error,20034,"Bad output page for %s volume %s blockno %s",3
#define IOMAN_BAD_OUTPUT_PAGE_ID 20034
#define IOMAN_MIN_DATA_PAGES                  SAPDBErr_MessageList::Error,20035,"Minimum of data areas size is %s pages and not %s",2
#define IOMAN_MIN_DATA_PAGES_ID 20035
#define IOMAN_WRONG_CONV_PAGE                 SAPDBErr_MessageList::Error,20036,"Wrong converter page on %s volume %s blockno %s",3
#define IOMAN_WRONG_CONV_PAGE_ID 20036
#define IOMAN_FBM_FULL                        SAPDBErr_MessageList::Error,20037,"No more free block address available from FBM",0
#define IOMAN_FBM_FULL_ID 20037
#define IOMAN_BAD_RESTART_PAGE                SAPDBErr_MessageList::Error,20038,"Bad restart page on %s volume %s blockno %s",3
#define IOMAN_BAD_RESTART_PAGE_ID 20038
#define IOMAN_BAD_DATA_PAGE                   SAPDBErr_MessageList::Error,20039,"Bad data page - Requested pageno %s (%s) read pageno %s",3
#define IOMAN_BAD_DATA_PAGE_ID 20039
#define IOMAN_READ_INFO_PAGE_FAILED           SAPDBErr_MessageList::Error,20040,"Cannot read info page from %s volume %s",2
#define IOMAN_READ_INFO_PAGE_FAILED_ID 20040
#define IOMAN_WRITE_INFO_PAGE_FAILED          SAPDBErr_MessageList::Error,20041,"Cannot write info page into %s volume %s",2
#define IOMAN_WRITE_INFO_PAGE_FAILED_ID 20041
#define IOMAN_DEVNO_MISSMATCH                 SAPDBErr_MessageList::Error,20042,"Volume id from %s volume in configuration and info page are different: %s vs %s",3
#define IOMAN_DEVNO_MISSMATCH_ID 20042
#define IOMAN_CAPACITY_MISSMATCH              SAPDBErr_MessageList::Error,20043,"Capacity of %s volume %s is different between configuration and info page: %s vs. %s",4
#define IOMAN_CAPACITY_MISSMATCH_ID 20043
#define IOMAN_BLOCKSIZE_MISSMATCH             SAPDBErr_MessageList::Error,20044,"Block size of %s volume %s is different between configuration and info page: %s vs. %s",4
#define IOMAN_BLOCKSIZE_MISSMATCH_ID 20044
#define IOMAN_CORRUPTED_CONFIGURATION         SAPDBErr_MessageList::Error,20045,"%s volume configuration corrupted: Linkage missmatch between volume %s and %s",3
#define IOMAN_CORRUPTED_CONFIGURATION_ID 20045
#define IOMAN_DB_IDENTIFIER_MISSMATCH         SAPDBErr_MessageList::Error,20046,"DB volume GUID '%s' of %s volume %s is not equal to the given volume GUID '%s'",4
#define IOMAN_DB_IDENTIFIER_MISSMATCH_ID 20046
#define IOMAN_ERR_MISSING_PREDECESSOR         SAPDBErr_MessageList::Error,20047,"%s volume configuration corrupted: Predecessor of volume %s should be %s",3
#define IOMAN_ERR_MISSING_PREDECESSOR_ID 20047
#define IOMAN_ERR_MISSING_SUCCESSOR           SAPDBErr_MessageList::Error,20048,"%s volume configuration corrupted: Successor of volume %s should be %s",3
#define IOMAN_ERR_MISSING_SUCCESSOR_ID 20048
#define IOMAN_ERR_BAD_VOLUME                  SAPDBErr_MessageList::Error,20049,"%s volume %s is set to bad",2
#define IOMAN_ERR_BAD_VOLUME_ID 20049
#define IOMAN_ERR_DATA_DEVNO_OUT_OF_RANGE     SAPDBErr_MessageList::Error,20050,"Data volume number %s is out of range. Upper limit is %s",2
#define IOMAN_ERR_DATA_DEVNO_OUT_OF_RANGE_ID 20050
#define IOMAN_ERR_LOG_DEVNO_OUT_OF_RANGE      SAPDBErr_MessageList::Error,20051,"Log volume number %s is out of range. Upper limit is %s",2
#define IOMAN_ERR_LOG_DEVNO_OUT_OF_RANGE_ID 20051
#define IOMAN_ERR_VOLUME_IS_ONLINE            SAPDBErr_MessageList::Error,20052,"Added %s volume %s is already online",2
#define IOMAN_ERR_VOLUME_IS_ONLINE_ID 20052
#define IOMAN_ERR_NEW_VOLUME_FAILED           SAPDBErr_MessageList::Error,20053,"Adding of %s volume %s to the RTE failed",2
#define IOMAN_ERR_NEW_VOLUME_FAILED_ID 20053
#define IOMAN_ERR_CREATE_LINKAGE              SAPDBErr_MessageList::Error,20054,"Create linkage between %s volume %s and %s failed",3
#define IOMAN_ERR_CREATE_LINKAGE_ID 20054
#define IOMAN_ERR_MIG_LOG_FAILED              SAPDBErr_MessageList::Error,20055,"Create log volume during migration failed",0
#define IOMAN_ERR_MIG_LOG_FAILED_ID 20055
#define IOMAN_ERR_MIG_LOG_FORMAT_FAILED       SAPDBErr_MessageList::Error,20056,"Format log volume during migration failed, because of %s",1
#define IOMAN_ERR_MIG_LOG_FORMAT_FAILED_ID 20056
#define IOMAN_ERR_MIG_DATA_FAILED             SAPDBErr_MessageList::Error,20057,"Create data volume during migration failed",0
#define IOMAN_ERR_MIG_DATA_FAILED_ID 20057
#define IOMAN_ERR_ILLEGAL_DATA_AREA_SIZE      SAPDBErr_MessageList::Error,20058,"Illegal data area size. Restart record %s vs. data base %s",2
#define IOMAN_ERR_ILLEGAL_DATA_AREA_SIZE_ID 20058
#define IOMAN_ERR_MIG_RESTARTREC_FAILED       SAPDBErr_MessageList::Error,20059,"Migration of restart record failed",0
#define IOMAN_ERR_MIG_RESTARTREC_FAILED_ID 20059
#define IOMAN_ERR_READ_PAGE_FAILED            SAPDBErr_MessageList::Error,20060,"Read page from %s volume %s on blockno %s failed",3
#define IOMAN_ERR_READ_PAGE_FAILED_ID 20060
#define IOMAN_ERR_CONV_MIG_FAILED             SAPDBErr_MessageList::Error,20061,"Migration of converter failed, because of base error: %s",1
#define IOMAN_ERR_CONV_MIG_FAILED_ID 20061
#define IOMAN_ERR_MIG_ATTACH_FAILED           SAPDBErr_MessageList::Error,20062,"Attach error on migration volume %s: %s",2
#define IOMAN_ERR_MIG_ATTACH_FAILED_ID 20062
#define IOMAN_ERR_MIG_ALREADY_RUNNING         SAPDBErr_MessageList::Error,20063,"Data base migration already running.",0
#define IOMAN_ERR_MIG_ALREADY_RUNNING_ID 20063
#define IOMAN_ERR_MIG_PARAM_FAILED            SAPDBErr_MessageList::Error,20064,"Could not update param file during migration, because: %s",1
#define IOMAN_ERR_MIG_PARAM_FAILED_ID 20064
#define IOMAN_ERR_MIG_NOT_POSSIBLE            SAPDBErr_MessageList::Error,20065,"The inplace migration of a liveCache is not possible",0
#define IOMAN_ERR_MIG_NOT_POSSIBLE_ID 20065
#define IOMAN_ERR_NOT_PREPARED_FOR_MIG        SAPDBErr_MessageList::Error,20066,"The inplace migration is not possible, because the migrate command was not executed in 7.2/7.3",0
#define IOMAN_ERR_NOT_PREPARED_FOR_MIG_ID 20066
#define IOMAN_ERR_CAPACITY_MISMATCH           SAPDBErr_MessageList::Error,20067,"Capacity mismatch for dual log device %s. Volume capacity %s. Mirrored volume capacity %s",3
#define IOMAN_ERR_CAPACITY_MISMATCH_ID 20067
#define IOMAN_ERR_STOP_REINTEGRATION          SAPDBErr_MessageList::Error,20068,"Reintegration unsuccessfully finished: %s",1
#define IOMAN_ERR_STOP_REINTEGRATION_ID 20068
#define IOMAN_ERR_NOT_WRITEABLE               SAPDBErr_MessageList::Error,20069,"The %s volume %s is not writeable. State is %s",3
#define IOMAN_ERR_NOT_WRITEABLE_ID 20069
#define IOMAN_ERR_LOG_OFFSET_OUT_OF_RANGE     SAPDBErr_MessageList::Error,20070,"Given log offset %s is out of range. Total log area size %s",2
#define IOMAN_ERR_LOG_OFFSET_OUT_OF_RANGE_ID 20070
#define IOMAN_ERR_LOG_OFFSET_OUT_OF_RANGE_1   SAPDBErr_MessageList::Error,20071,"Given log offset %s with blockcount %s is out of range. Total log area size %s",3
#define IOMAN_ERR_LOG_OFFSET_OUT_OF_RANGE_1_ID 20071
#define IOMAN_ERR_LOG_AREA_ALREADY_ONLINE     SAPDBErr_MessageList::Error,20072,"Create log area not allowed, because log area is still in use",0
#define IOMAN_ERR_LOG_AREA_ALREADY_ONLINE_ID 20072
#define IOMAN_ERR_DATA_AREA_ALREADY_ONLINE    SAPDBErr_MessageList::Error,20073,"Create data area not allowed, because data area is still in use",0
#define IOMAN_ERR_DATA_AREA_ALREADY_ONLINE_ID 20073
#define IOMAN_ERR_STOP_VOLUME_MIGRATION       SAPDBErr_MessageList::Error,20074,"Volume info page migration unsuccessfully finished",0
#define IOMAN_ERR_STOP_VOLUME_MIGRATION_ID 20074
#define IOMAN_ERR_MIG_COULD_NOT_START_FBM     SAPDBErr_MessageList::Error,20075,"FBM could not be started during data base migration",0
#define IOMAN_ERR_MIG_COULD_NOT_START_FBM_ID 20075
#define IOMAN_ERR_DATA_VOLUME_NOT_EMPTY       SAPDBErr_MessageList::Error,20076,"Drop data volume failed - volume %s still contains %s pages",2
#define IOMAN_ERR_DATA_VOLUME_NOT_EMPTY_ID 20076
#define IOMAN_ERR_ABORT_DROP_VOLUME           SAPDBErr_MessageList::Error,20077,"Abort reading pages for dropping: %s",1
#define IOMAN_ERR_ABORT_DROP_VOLUME_ID 20077
#define IOMAN_ERR_DROP_FAILED                 SAPDBErr_MessageList::Error,20078,"Drop data volume %s failed - iomanager reason: %s",2
#define IOMAN_ERR_DROP_FAILED_ID 20078
#define IOMAN_ERR_CANT_PREPARE_DROP_VOLUME    SAPDBErr_MessageList::Error,20079,"Drop data volume failed - cannot set data volume %s to read only",1
#define IOMAN_ERR_CANT_PREPARE_DROP_VOLUME_ID 20079
#define IOMAN_ERR_START_SVP_FAILED_DROP       SAPDBErr_MessageList::Error,20080,"Drop data volume failed - start savepoint failed",0
#define IOMAN_ERR_START_SVP_FAILED_DROP_ID 20080
#define IOMAN_ERR_DEREGISTER_DROP_FAILED      SAPDBErr_MessageList::Error,20081,"Drop data volume failed - cannot deregister volume in FBM",0
#define IOMAN_ERR_DEREGISTER_DROP_FAILED_ID 20081
#define IOMAN_BAD_RESTART_PAGE_ADDRESS        SAPDBErr_MessageList::Error,20082,"Bad restart page address: %s volume %s blockno %s",3
#define IOMAN_BAD_RESTART_PAGE_ADDRESS_ID 20082
#define IOMAN_INVALID_DATA_IO_BLOCK_COUNT     SAPDBErr_MessageList::Error,20083,"Mismatch between activated and configured DATA_IO_BLOCK_COUNT: on volume: %s in config: %s",2
#define IOMAN_INVALID_DATA_IO_BLOCK_COUNT_ID 20083

#endif /* IOMAN_MESSAGES_HPP */
