/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbcext;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;

import javax.naming.Context;
import javax.naming.Name;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;

public class XADataSourceSapDBFactory
    implements ObjectFactory
{
    static HashSet forbiddenproperties;

    public Object getObjectInstance(Object obj,
                                    Name name,
                                    Context nameCtx,
                                    Hashtable environment)
    {
        if(obj instanceof javax.naming.Reference) {
            javax.naming.Reference ref=(javax.naming.Reference)obj;
            if(!"com.sap.dbtech.jdbcext.XADataSourceSapDB".equals(ref.getClassName())) {
                return null;
            }
            Properties p=propertiesFromRef(ref);
            XADataSourceSapDB result=new XADataSourceSapDB();
            result.setProperties(p);
            return result;
        } else {
            return null;
        }
    }

    
    private Properties propertiesFromRef(javax.naming.Reference ref)
    {
        Enumeration refaddrs=ref.getAll();
        Properties result=new Properties();
        while(refaddrs.hasMoreElements()) {
            Object o=refaddrs.nextElement();
            try {
                StringRefAddr stringref=(StringRefAddr)o;
                if(forbiddenproperties.contains(stringref.getType())) {
                    continue;
                }
                if(!stringref.getType().equals("isolation")) {                
                    result.setProperty(stringref.getType(), (String) (stringref.getContent()));               
                } else {
                    String j2eeisolation=(String) (stringref.getContent());
                    if(j2eeisolation.equals("none")) { // inqmy for 'dont set this!'
                        continue;
                    } else if(j2eeisolation.equals("ruc")) { // inqmy for read uncommitted
                        j2eeisolation="TRANSACTION_READ_UNCOMMITTED";
                    } else if(j2eeisolation.equals("rc")) { // inqmy for read committed
                        j2eeisolation="TRANSACTION_READ_COMMITTED";
                    } else if(j2eeisolation.equals("rr")) { // inqmy for repeatable read 
                        j2eeisolation="TRANSACTION_REPEATABLE_READ";
                    } else if(j2eeisolation.equals("s")) { // inqmy for serializable
                        j2eeisolation="TRANSACTION_SERIALIZABLE";
                    }
                    result.setProperty("isolation", j2eeisolation);
                }
            } catch(ClassCastException ccx) {
            }
        }
        return result;
    }
    
    static {
        forbiddenproperties=new HashSet();
        forbiddenproperties.add("autocommit");
    }
}
