/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.udeserver;

import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.ParameterMetaDataSapDB;
import com.sap.dbtech.jdbc.exceptions.JDBCDriverException;
import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.packet.ReplyPacket;
import com.sap.dbtech.jdbc.translators.AbstractABAPStreamGetval;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.udeserver.Log;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StructuredMem;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;

public class ProcParameterList
implements SQLParamController {
    private DBTechTranslator[] translators;
    private StructuredMem dataMem;
    private Object[] outputArgs;
    private ParameterMetaData metaData;
    private boolean lastWasNull = false;
    private List outCursors;

    ProcParameterList(ReplyPacket replyPacket, DBTechTranslator[] dBTechTranslatorArray) {
        try {
            if (dBTechTranslatorArray == null) {
                dBTechTranslatorArray = ProcParameterList.createTranslators(replyPacket);
            }
            this.translators = dBTechTranslatorArray;
            this.metaData = new ParameterMetaDataSapDB(this.translators);
            replyPacket.findPart(5);
            this.dataMem = replyPacket.getPointer(replyPacket.getPartDataPos());
            this.outputArgs = new Object[dBTechTranslatorArray.length];
        }
        catch (Throwable throwable) {
            Log.traceException(throwable);
            throw new Error(throwable.getMessage());
        }
    }

    ProcParameterList(ReplyPacket replyPacket) {
        this(replyPacket, null);
    }

    public static DBTechTranslator[] createTranslators(ReplyPacket replyPacket) throws Throwable {
        replyPacket.findPart(14);
        return replyPacket.parseShortFields(false, false, null);
    }

    public ParameterMetaData getParameterMetaData() {
        return this.metaData;
    }

    boolean hasOutputParameter() {
        for (int i = 0; i < this.translators.length; ++i) {
            if (!this.translators[i].isOutput()) continue;
            return true;
        }
        return false;
    }

    void copyToOutputPacket(DataPart dataPart) throws SQLException {
        for (int i = 0; i < this.translators.length; ++i) {
            if (!this.translators[i].isOutput()) continue;
            Log.log("Out " + (i + 1) + " => " + this.outputArgs[i]);
            this.translators[i].putProcOutput(dataPart, this.outputArgs[i]);
        }
    }

    private DBTechTranslator findColInfo(int n) throws SQLException {
        DBTechTranslator dBTechTranslator;
        try {
            dBTechTranslator = this.translators[n - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new JDBCDriverException(MessageTranslator.translate((String)"error.colindex.notfound", (Object)Integer.toString(n)), (Object)this);
        }
        return dBTechTranslator;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.findColInfo(n).getBigDecimal((SQLParamController)this, this.dataMem);
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.findColInfo(n).getBigDecimal(n2, (SQLParamController)this, this.dataMem);
    }

    public boolean getBoolean(int n) throws SQLException {
        return this.findColInfo(n).getBoolean((SQLParamController)this, this.dataMem);
    }

    public byte getByte(int n) throws SQLException {
        return this.findColInfo(n).getByte((SQLParamController)this, this.dataMem);
    }

    public byte[] getBytes(int n) throws SQLException {
        return this.findColInfo(n).getBytes((SQLParamController)this, this.dataMem);
    }

    public Date getDate(int n) throws SQLException {
        return this.findColInfo(n).getDate((SQLParamController)this, this.dataMem, null);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.findColInfo(n).getDate((SQLParamController)this, this.dataMem, calendar);
    }

    public double getDouble(int n) throws SQLException {
        return this.findColInfo(n).getDouble((SQLParamController)this, this.dataMem);
    }

    public float getFloat(int n) throws SQLException {
        return this.findColInfo(n).getFloat((SQLParamController)this, this.dataMem);
    }

    public int getInt(int n) throws SQLException {
        return this.findColInfo(n).getInt((SQLParamController)this, this.dataMem);
    }

    public long getLong(int n) throws SQLException {
        return this.findColInfo(n).getLong((SQLParamController)this, this.dataMem);
    }

    public Object getObject(int n) throws SQLException {
        return this.findColInfo(n).getObject((SQLParamController)this, this.dataMem);
    }

    public short getShort(int n) throws SQLException {
        return this.findColInfo(n).getShort((SQLParamController)this, this.dataMem);
    }

    public String getString(int n) throws SQLException {
        return this.findColInfo(n).getString((SQLParamController)this, this.dataMem);
    }

    public Time getTime(int n) throws SQLException {
        return this.findColInfo(n).getTime((SQLParamController)this, this.dataMem, null);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.findColInfo(n).getTime((SQLParamController)this, this.dataMem, calendar);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this.findColInfo(n).getTimestamp((SQLParamController)this, this.dataMem, null);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.findColInfo(n).getTimestamp((SQLParamController)this, this.dataMem, calendar);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        Object object;
        this.outputArgs[n - 1] = object = this.findColInfo(n).transBigDecimalForInput(bigDecimal);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        Object object;
        this.outputArgs[n - 1] = object = this.findColInfo(n).transBooleanForInput(bl);
    }

    public void setByte(int n, byte by) throws SQLException {
        Object object;
        this.outputArgs[n - 1] = object = this.findColInfo(n).transByteForInput(by);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        Object object;
        this.outputArgs[n - 1] = object = this.findColInfo(n).transBytesForInput(byArray);
    }

    public void setDate(int n, Date date) throws SQLException {
        this.setDate(n, date, null);
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        Object object;
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        this.outputArgs[n - 1] = object = this.findColInfo(n).transDateForInput(date, calendar);
    }

    public void setDouble(int n, double d) throws SQLException {
        Object object;
        this.outputArgs[n - 1] = object = this.findColInfo(n).transDoubleForInput(d);
    }

    public void setFloat(int n, float f) throws SQLException {
        Object object;
        this.outputArgs[n - 1] = object = this.findColInfo(n).transFloatForInput(f);
    }

    public void setInt(int n, int n2) throws SQLException {
        Object object;
        this.outputArgs[n - 1] = object = this.findColInfo(n).transIntForInput(n2);
    }

    public void setLong(int n, long l) throws SQLException {
        Object object;
        this.outputArgs[n - 1] = object = this.findColInfo(n).transLongForInput(l);
    }

    public void setNull(int n, int n2) throws SQLException {
        this.outputArgs[n - 1] = null;
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.setNull(n, n2);
    }

    public void setObject(int n, Object object) throws SQLException {
        Object object2;
        this.outputArgs[n - 1] = object2 = this.findColInfo(n).transObjectForInput(object);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        switch (n2) {
            case 4: {
                if (!(object instanceof Number)) break;
                Number number = (Number)object;
                this.setInt(n, number.intValue());
                return;
            }
            case -5: {
                if (!(object instanceof Number)) break;
                Number number = (Number)object;
                this.setLong(n, number.longValue());
                return;
            }
        }
        this.setObject(n, object);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.setObject(n, object, n3);
    }

    public void setShort(int n, short s) throws SQLException {
        Object object;
        this.outputArgs[n - 1] = object = this.findColInfo(n).transShortForInput(s);
    }

    public void setString(int n, String string) throws SQLException {
        Object object;
        this.outputArgs[n - 1] = object = this.findColInfo(n).transStringForInput(string);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.setTime(n, time, null);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        Object object;
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        this.outputArgs[n - 1] = object = this.findColInfo(n).transTimeForInput(time, calendar);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setTimestamp(n, timestamp, null);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        Object object;
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        this.outputArgs[n - 1] = object = this.findColInfo(n).transTimestampForInput(timestamp, calendar);
    }

    public void addWarning(SQLWarning sQLWarning) {
    }

    public ConnectionSapDB getConnectionSapDB() {
        return null;
    }

    public StructuredMem getReplyData() throws SQLException {
        return this.dataMem;
    }

    public void setLastWasNull(boolean bl) {
        this.lastWasNull = bl;
    }

    public boolean wasNull() throws SQLException {
        return this.lastWasNull;
    }

    public AbstractABAPStreamGetval getOMSGetval(int n) {
        return null;
    }

    public void addCursorName(String string) {
        if (this.outCursors == null) {
            this.outCursors = new ArrayList();
        }
        this.outCursors.add(string);
    }

    public Iterator getCursorNames() {
        if (this.outCursors == null) {
            return null;
        }
        return this.outCursors.iterator();
    }
}

