#!/usr/bin/perl
# usecheck [-m] parameter   3.1.3   1993-12-07   kern   elke
#
# Parameter must be a standard module name, i.e. the directory
# "$SRC/$L, where L=`expr "parameter" : "v\(..\)"`, must exist.
# An implicit "iget -e0 parameter" is performed.
# If the option -m is specified, it is propagated to "iget".
# If an error occurred, the files "parameter.err", which contains the
# error messages, and "parameter.pre", which contains the generated
# output, are moved to "$WRK/fast/prot".
use Env;
use Getopt::Std;
use File::Copy;
use Win32::File;

getopts('mh');

if ( defined($opt_h) or @ARGV != 1 ) {
	print "Usage: usecheck [-m]  parameter\n";
	exit 11;
}
$Param = $ARGV[0];

$L = "";

if ( $Param !~ m!.*\\! ) {

	($L) = $Param =~ m!v(\w\w)\w+!;
	if ( ($L eq "") or (! -d "$SRC/$L") ) { $L = ""	} else { $DIR = "$SRC/$L" }
}

if ( $L eq "" ) {
	print "Error: module name $Param is illegal.\n";
	exit 12;
}

chdir("$WRK/fast/prot") || die "Can't change to directory $WRK/fast/prot: $!";

if ( -f "$DIR/$Param" ) {
	copy("$DIR/$Param", "./$Param") ;
} else {

        @ARGV = ("-e0", $Param);
		do "$TOOL/bin/iview$TOOLEXT";
		if ( $@ ) { die "Error while executing iview$TOOLEXT: $@" }
		Win32::File::SetAttributes("$TMP/$Param", NORMAL);
        copy("$TMP/$Param", "./$Param");
}

if ($RELVER ge "R71") {
    $usecheckexe = "usecheckx";
}
else {
    $usecheckexe = "usecheck";
}

system("$TOOL/pgm/$usecheckexe $Param");
$RET = $?;

unlink($Param, "$Param.pre");

if   ( $RET != 0 ) {
   if ($RELVER ge "R71") {
	if   ( -s "$Param.use" ) { open(FILE_IN, "<$Param.use"); print <FILE_IN>; close(FILE_IN) }
   }
   else {
	if   ( -s "$Param.err" ) { open(FILE_IN, "<$Param.err"); print <FILE_IN>; close(FILE_IN) }
   }
}
else {
   if ($RELVER ge "R71") {
      unlink("$Param.use")
	  }
   else {
      unlink("$Param.err")
	  }
	}


exit $RET;
